/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherForecastPrediction;
import org.powertac.common.WeatherReport;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CapacityStructure;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ParserFunctions;
import org.powertac.factoredcustomer.TimeseriesGenerator;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;

@Domain
class DefaultCapacityOriginator
implements CapacityOriginator {
    protected Logger log = Logger.getLogger((String)DefaultCapacityOriginator.class.getName());
    protected final FactoredCustomerService service;
    private final double SMOOTHING_WEIGHT = 0.4;
    private final TimeseriesGenerator tsGenerator;
    private final CapacityStructure capacityStructure;
    private final CapacityBundle parentBundle;
    protected final String logIdentifier;
    private final Map<Integer, Double> baseCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> forecastCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> actualCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> curtailedCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> shiftedCurtailments = new HashMap<Integer, Double>();

    DefaultCapacityOriginator(FactoredCustomerService service, CapacityStructure structure, CapacityBundle bundle) {
        this.service = service;
        this.capacityStructure = structure;
        this.parentBundle = bundle;
        this.logIdentifier = this.capacityStructure.capacityName.isEmpty() ? bundle.getName() : bundle.getName() + "#" + this.capacityStructure.capacityName;
        this.tsGenerator = this.capacityStructure.baseCapacityType == CapacityStructure.BaseCapacityType.TIMESERIES ? new TimeseriesGenerator(service, this.capacityStructure.baseTimeseriesStructure) : null;
    }

    @Override
    public CapacityProfile getCurrentForecast() {
        int timeslot = this.service.getTimeslotRepo().currentSerialNumber();
        return this.getForecastForTimeslot(timeslot);
    }

    @Override
    public CapacityProfile getForecastForNextTimeslot() {
        int timeslot = this.service.getTimeslotRepo().currentSerialNumber();
        return this.getForecastForTimeslot(timeslot + 1);
    }

    public CapacityProfile getForecastForTimeslot(int timeslot) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < 24; ++i) {
            Double forecastCapacity = this.forecastCapacities.get(timeslot);
            if (forecastCapacity != null) {
                values.add(forecastCapacity);
            } else {
                values.add(this.getForecastCapacity(timeslot));
            }
            ++timeslot;
        }
        return new CapacityProfile(values);
    }

    @Override
    public CapacityProfile getCurrentForecastPerSub(TariffSubscription sub) {
        return this.getCurrentForecast();
    }

    @Override
    public CapacityProfile getForecastPerSubStartingAt(int startingTimeslot, TariffSubscription subscription) {
        return this.getForecastForTimeslot(startingTimeslot);
    }

    protected double getForecastCapacity(int timeslot) {
        Double ret = this.forecastCapacities.get(timeslot);
        if (ret == null) {
            ret = this.computeForecastCapacity(timeslot);
        }
        return ret;
    }

    private double computeForecastCapacity(int future) {
        int now = this.service.getTimeslotRepo().currentSerialNumber();
        int timeToFuture = future - now;
        Weather weather = null;
        if (timeToFuture == 0) {
            weather = new Weather(this.service.getWeatherReportRepo().currentWeatherReport());
        } else {
            WeatherForecast forecast = this.service.getWeatherForecastRepo().currentWeatherForecast();
            List predictions = forecast.getPredictions();
            for (WeatherForecastPrediction prediction : predictions) {
                if (prediction.getForecastTime() != timeToFuture) continue;
                weather = new Weather(prediction);
            }
        }
        if (weather == null) {
            throw new Error("Could not find weather forecast for timeslot " + future);
        }
        double baseCapacity = this.getBaseCapacity(future);
        if (Double.isNaN(baseCapacity)) {
            throw new Error("Base capacity is NaN!");
        }
        double forecastCapacity = baseCapacity;
        forecastCapacity = this.adjustCapacityForPeriodicSkew(forecastCapacity, this.service.getTimeslotRepo().getDateTimeForIndex(future), false);
        if (Double.isNaN(forecastCapacity = this.adjustCapacityForWeather(forecastCapacity, weather, false))) {
            throw new Error("Adjusted capacity is NaN for base capacity = " + baseCapacity);
        }
        forecastCapacity = this.truncateTo2Decimals(forecastCapacity);
        this.forecastCapacities.put(future, forecastCapacity);
        this.log.debug((Object)(this.logIdentifier + ": Daniel Forecast capacity for timeslot " + future + " = " + forecastCapacity));
        return forecastCapacity;
    }

    private double getBaseCapacity(int future) {
        Double ret = this.baseCapacities.get(future);
        if (ret == null) {
            ret = this.drawBaseCapacitySample(future);
        }
        return ret;
    }

    private double drawBaseCapacitySample(int timeslot) {
        double baseCapacity = 0.0;
        switch (this.capacityStructure.baseCapacityType) {
            case POPULATION: {
                baseCapacity = this.capacityStructure.basePopulationCapacity.drawSample();
                break;
            }
            case INDIVIDUAL: {
                for (int i = 0; i < this.parentBundle.getPopulation(); ++i) {
                    double draw = this.capacityStructure.baseIndividualCapacity.drawSample();
                    baseCapacity += draw;
                }
                break;
            }
            case TIMESERIES: {
                baseCapacity = this.getBaseCapacityFromTimeseries(timeslot);
                break;
            }
            default: {
                throw new Error(this.logIdentifier + ": Unexpected base capacity type: " + (Object)((Object)this.capacityStructure.baseCapacityType));
            }
        }
        Double prevCapacity = this.baseCapacities.get(timeslot - 1);
        if (prevCapacity != null) {
            baseCapacity = 0.4 * prevCapacity + 0.6 * baseCapacity;
        }
        baseCapacity = this.truncateTo2Decimals(baseCapacity);
        this.baseCapacities.put(timeslot, baseCapacity);
        return baseCapacity;
    }

    private double getBaseCapacityFromTimeseries(int timeslot) {
        try {
            return this.tsGenerator.generateNext(timeslot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.log.error((Object)(this.logIdentifier + ": Tried to get base capacity from time series at index beyond maximum!"));
            throw e;
        }
    }

    @Override
    public double getShiftingInconvenienceFactor(Tariff tariff) {
        return 0.0;
    }

    @Override
    public double useCapacity(TariffSubscription subscription) {
        int timeslot = this.service.getTimeslotRepo().currentSerialNumber();
        double baseCapacity = this.getBaseCapacity(timeslot);
        if (Double.isNaN(baseCapacity)) {
            throw new Error("Base capacity is NaN!");
        }
        this.logCapacityDetails(this.logIdentifier + ": Base capacity for timeslot " + timeslot + " = " + baseCapacity);
        double adjustedCapacity = baseCapacity;
        if (this.parentBundle.getPowerType().isInterruptible()) {
            adjustedCapacity = this.adjustCapacityForCurtailments(timeslot, adjustedCapacity, subscription);
        }
        adjustedCapacity = this.adjustCapacityForPeriodicSkew(adjustedCapacity, this.service.getTimeService().getCurrentDateTime(), true);
        adjustedCapacity = this.adjustCapacityForCurrentWeather(adjustedCapacity, true);
        if (Double.isNaN(adjustedCapacity = this.adjustCapacityForSubscription(timeslot, adjustedCapacity, subscription))) {
            throw new Error("Adjusted capacity is NaN for base capacity = " + baseCapacity);
        }
        adjustedCapacity = this.truncateTo2Decimals(adjustedCapacity);
        this.actualCapacities.put(timeslot, adjustedCapacity);
        this.log.info((Object)(this.logIdentifier + ": Adjusted capacity for tariff " + subscription.getTariff().getId() + " = " + adjustedCapacity));
        return adjustedCapacity;
    }

    private double adjustCapacityForCurtailments(int timeslot, double capacity, TariffSubscription subscription) {
        Double currentShift;
        double lastCurtailment = subscription.getCurtailment();
        if (Math.abs(lastCurtailment) > 0.01) {
            this.curtailedCapacities.put(timeslot - 1, lastCurtailment);
            if (this.capacityStructure.curtailmentShifts != null) {
                for (int i = 0; i < this.capacityStructure.curtailmentShifts.length; ++i) {
                    double shiftingFactor = this.capacityStructure.curtailmentShifts[i];
                    double shiftedCapacity = lastCurtailment * shiftingFactor;
                    Double previousShifts = this.shiftedCurtailments.get(timeslot + i);
                    if (previousShifts == null) {
                        this.shiftedCurtailments.put(timeslot + i, shiftedCapacity);
                        continue;
                    }
                    this.shiftedCurtailments.put(timeslot + i, previousShifts + shiftedCapacity);
                }
            }
        }
        return (currentShift = this.shiftedCurtailments.get(timeslot)) == null ? capacity : capacity + currentShift;
    }

    private double adjustCapacityForPeriodicSkew(double capacity, DateTime when, boolean verbose) {
        int day = when.getDayOfWeek();
        int hour = when.getHourOfDay();
        double periodicSkew = this.capacityStructure.dailySkew[day - 1] * this.capacityStructure.hourlySkew[hour];
        if (verbose) {
            this.logCapacityDetails(this.logIdentifier + ": periodic skew = " + periodicSkew);
        }
        return capacity * periodicSkew;
    }

    private double adjustCapacityForCurrentWeather(double capacity, boolean verbose) {
        WeatherReport weatherReport = this.service.getWeatherReportRepo().currentWeatherReport();
        return this.adjustCapacityForWeather(capacity, new Weather(weatherReport), verbose);
    }

    private double adjustCapacityForWeather(double capacity, Weather weather, boolean verbose) {
        if (verbose) {
            this.logCapacityDetails(this.logIdentifier + ": weather = (" + weather.getTemperature() + ", " + weather.getWindSpeed() + ", " + weather.getWindDirection() + ", " + weather.getCloudCover() + ")");
        }
        double weatherFactor = 1.0;
        if (this.capacityStructure.temperatureInfluence == CapacityStructure.InfluenceKind.DIRECT) {
            int temperature = (int)Math.round(weather.getTemperature());
            weatherFactor *= this.capacityStructure.temperatureMap.get(temperature).doubleValue();
        } else if (this.capacityStructure.temperatureInfluence == CapacityStructure.InfluenceKind.DEVIATION) {
            int curr = (int)Math.round(weather.getTemperature());
            int ref = (int)Math.round(this.capacityStructure.temperatureReference);
            double deviationFactor = 1.0;
            if (curr > ref) {
                for (int t = ref + 1; t <= curr; ++t) {
                    deviationFactor += this.capacityStructure.temperatureMap.get(t).doubleValue();
                }
            } else if (curr < ref) {
                for (int t = curr; t < ref; ++t) {
                    deviationFactor += this.capacityStructure.temperatureMap.get(t).doubleValue();
                }
            }
            weatherFactor *= deviationFactor;
        }
        if (this.capacityStructure.windSpeedInfluence == CapacityStructure.InfluenceKind.DIRECT) {
            int windSpeed = (int)Math.round(weather.getWindSpeed());
            weatherFactor *= this.capacityStructure.windSpeedMap.get(windSpeed).doubleValue();
            if ((double)windSpeed > 0.0 && this.capacityStructure.windDirectionInfluence == CapacityStructure.InfluenceKind.DIRECT) {
                int windDirection = (int)Math.round(weather.getWindDirection());
                weatherFactor *= this.capacityStructure.windDirectionMap.get(windDirection).doubleValue();
            }
        }
        if (this.capacityStructure.cloudCoverInfluence == CapacityStructure.InfluenceKind.DIRECT) {
            int cloudCover = (int)Math.round(100.0 * weather.getCloudCover());
            weatherFactor *= this.capacityStructure.cloudCoverMap.get(cloudCover).doubleValue();
        }
        if (verbose) {
            this.logCapacityDetails(this.logIdentifier + ": weather factor = " + weatherFactor);
        }
        return capacity * weatherFactor;
    }

    @Override
    public double adjustCapacityForSubscription(int timeslot, double totalCapacity, TariffSubscription subscription) {
        double subCapacity = this.adjustCapacityForPopulationRatio(totalCapacity, subscription);
        return this.adjustCapacityForTariffRates(timeslot, subCapacity, subscription);
    }

    private double adjustCapacityForPopulationRatio(double capacity, TariffSubscription subscription) {
        double popRatio = this.getPopulationRatio(subscription.getCustomersCommitted(), this.parentBundle.getPopulation());
        this.logCapacityDetails(this.logIdentifier + ": population ratio = " + popRatio);
        return capacity * popRatio;
    }

    private double getPopulationRatio(int customerCount, int population) {
        return (double)customerCount / (double)population;
    }

    protected double adjustCapacityForTariffRates(int timeslot, double baseCapacity, TariffSubscription subscription) {
        if (baseCapacity - 0.0 < 0.01) {
            return baseCapacity;
        }
        double chargeForBase = subscription.getTariff().getUsageCharge(this.service.getTimeslotRepo().getTimeForIndex(timeslot), baseCapacity, subscription.getTotalUsage());
        double rateForBase = chargeForBase / baseCapacity;
        double benchmarkRate = this.capacityStructure.benchmarkRates.get(this.service.getTimeService().getHourOfDay());
        double rateRatio = rateForBase / benchmarkRate;
        double tariffRatesFactor = this.determineTariffRatesFactor(rateRatio);
        this.logCapacityDetails(this.logIdentifier + ": tariff rates factor = " + tariffRatesFactor);
        return baseCapacity * tariffRatesFactor;
    }

    private double determineTariffRatesFactor(double rateRatio) {
        switch (this.capacityStructure.elasticityModelType) {
            case CONTINUOUS: {
                return this.determineContinuousElasticityFactor(rateRatio);
            }
            case STEPWISE: {
                return this.determineStepwiseElasticityFactor(rateRatio);
            }
        }
        throw new Error("Unexpected elasticity model type: " + (Object)((Object)this.capacityStructure.elasticityModelType));
    }

    private double determineContinuousElasticityFactor(double rateRatio) {
        double percentChange = (rateRatio - 1.0) / 0.01;
        double elasticityRatio = Double.parseDouble(this.capacityStructure.elasticityModelXml.getAttribute("ratio"));
        String range = this.capacityStructure.elasticityModelXml.getAttribute("range");
        String[] minmax = range.split("~");
        double low = Double.parseDouble(minmax[0]);
        double high = Double.parseDouble(minmax[1]);
        return Math.max(low, Math.min(high, 1.0 + percentChange * elasticityRatio));
    }

    private double determineStepwiseElasticityFactor(double rateRatio) {
        double[][] elasticity = null;
        if (elasticity == null) {
            elasticity = ParserFunctions.parseMapToDoubleArray(this.capacityStructure.elasticityModelXml.getAttribute("map"));
        }
        if (Math.abs(rateRatio - 1.0) < 0.01 || elasticity.length == 0) {
            return 1.0;
        }
        PowerType powerType = this.parentBundle.getPowerType();
        if (powerType.isConsumption() && rateRatio < 1.0) {
            return 1.0;
        }
        if (powerType.isProduction() && rateRatio > 1.0) {
            return 1.0;
        }
        boolean RATE_RATIO_INDEX = false;
        boolean CAPACITY_FACTOR_INDEX = true;
        double rateLowerBound = Double.NEGATIVE_INFINITY;
        double rateUpperBound = Double.POSITIVE_INFINITY;
        double lowerBoundCapacityFactor = 1.0;
        double upperBoundCapacityFactor = 1.0;
        for (int i = 0; i < elasticity.length; ++i) {
            double r = elasticity[i][0];
            if (r <= rateRatio && r > rateLowerBound) {
                rateLowerBound = r;
                lowerBoundCapacityFactor = elasticity[i][1];
            }
            if (!(r >= rateRatio) || !(r < rateUpperBound)) continue;
            rateUpperBound = r;
            upperBoundCapacityFactor = elasticity[i][1];
        }
        return rateRatio < 1.0 ? upperBoundCapacityFactor : lowerBoundCapacityFactor;
    }

    @Override
    public String getCapacityName() {
        return this.capacityStructure.capacityName;
    }

    @Override
    public CapacityBundle getParentBundle() {
        return this.parentBundle;
    }

    protected double truncateTo2Decimals(double x) {
        double fract;
        double whole;
        if (x > 0.0) {
            whole = Math.floor(x);
            fract = Math.floor((x - whole) * 100.0) / 100.0;
        } else {
            whole = Math.ceil(x);
            fract = Math.ceil((x - whole) * 100.0) / 100.0;
        }
        return whole + fract;
    }

    protected void logCapacityDetails(String msg) {
        if (this.service.getCapacityDetailsLogging()) {
            this.log.info((Object)msg);
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.logIdentifier;
    }

    private class Weather {
        final double temperature;
        final double windSpeed;
        final double windDirection;
        final double cloudCover;

        Weather(WeatherReport report) {
            this.temperature = report.getTemperature();
            this.windSpeed = report.getWindSpeed();
            this.windDirection = report.getWindDirection();
            this.cloudCover = report.getCloudCover();
        }

        Weather(WeatherForecastPrediction prediction) {
            this.temperature = prediction.getTemperature();
            this.windSpeed = prediction.getWindSpeed();
            this.windDirection = prediction.getWindDirection();
            this.cloudCover = prediction.getCloudCover();
        }

        double getTemperature() {
            return this.temperature;
        }

        double getWindSpeed() {
            return this.windSpeed;
        }

        double getWindDirection() {
            return this.windDirection;
        }

        double getCloudCover() {
            return this.cloudCover;
        }
    }
}

