/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.powertac.common.state.Domain;

@Domain
public final class CapacityProfile {
    static final int NUM_TIMESLOTS = 24;
    private static final int MAX_BALANCING_SHIFTS = 24;
    private static final double BALANCING_SHIFTS_EPSILON = 0.1;
    private List<Double> values;

    public CapacityProfile(Double uniformValue) {
        this.values = new ArrayList<Double>(24);
        for (int i = 0; i < 24; ++i) {
            this.values.add(uniformValue);
        }
    }

    public CapacityProfile(List<Double> list) {
        this.values = new ArrayList<Double>(24);
        this.values.addAll(list);
    }

    public CapacityProfile(double[] array) {
        if (array.length != 24) {
            throw new Error("Number of elements in array does not match expected length: 24");
        }
        this.values = new ArrayList<Double>(24);
        for (int i = 0; i < 24; ++i) {
            this.values.add(array[i]);
        }
    }

    public double distanceTo(CapacityProfile other) {
        double distance = 0.0;
        for (int i = 0; i < 24; ++i) {
            distance += Math.pow(Math.abs(this.getCapacity(i) - other.getCapacity(i)), 2.0);
        }
        return distance;
    }

    double getCapacity(int index) {
        return this.values.get(index);
    }

    public List<CapacityProfile> getPermutations(PermutationRule rule) {
        List<CapacityProfile> perms;
        switch (rule) {
            case TEMPORAL_SHIFTS: {
                perms = this.getTimeShiftedPermutations();
                break;
            }
            case BALANCING_SHIFTS: {
                perms = this.getPeakShiftedPermutations();
                break;
            }
            case ALL_SHIFTS: {
                perms = new ArrayList<CapacityProfile>();
                perms.addAll(this.getTimeShiftedPermutations());
                perms.addAll(this.getPeakShiftedPermutations());
                break;
            }
            default: {
                throw new Error("Unexpected value for permutation rule: " + (Object)((Object)rule));
            }
        }
        return perms;
    }

    private List<CapacityProfile> getTimeShiftedPermutations() {
        ArrayList<CapacityProfile> perms = new ArrayList<CapacityProfile>();
        for (int i = 0; i < 24; ++i) {
            ArrayList<Double> perm = new ArrayList<Double>(24);
            for (int j = i; j < i + 24; ++j) {
                perm.add(this.values.get(j % 24));
            }
            this.validatePermutation(perm);
            perms.add(new CapacityProfile(perm));
        }
        return perms;
    }

    private List<CapacityProfile> getPeakShiftedPermutations() {
        ArrayList<CapacityProfile> perms = new ArrayList<CapacityProfile>();
        this.recursivePeakShift(this.values, perms);
        return perms;
    }

    private void recursivePeakShift(List<Double> curr, List<CapacityProfile> perms) {
        int peakIndex = 0;
        int valleyIndex = 0;
        for (int i = 0; i < 24; ++i) {
            Double val = curr.get(i);
            if (val > curr.get(peakIndex)) {
                peakIndex = i;
            }
            if (!(val < curr.get(valleyIndex))) continue;
            valleyIndex = i;
        }
        Double max = curr.get(peakIndex);
        Double min = curr.get(valleyIndex);
        Double mid = 0.5 * (max + min);
        if (peakIndex != valleyIndex) {
            double newRange;
            ArrayList<Double> newList = new ArrayList<Double>();
            for (int j = 0; j < 24; ++j) {
                if (j == peakIndex) {
                    newList.add(mid);
                    continue;
                }
                if (j == valleyIndex) {
                    newList.add(min + (max - mid));
                    continue;
                }
                newList.add(curr.get(j));
            }
            this.validatePermutation(newList);
            CapacityProfile newProfile = new CapacityProfile(newList);
            perms.add(newProfile);
            if (perms.size() < 24 && (newRange = Collections.max(newList) - Collections.min(newList)) > 0.1 * max) {
                this.recursivePeakShift(newList, perms);
            }
        }
    }

    private void validatePermutation(List<Double> perm) {
        Double origTotal = 0.0;
        Double permTotal = 0.0;
        for (int i = 0; i < 24; ++i) {
            origTotal = origTotal + this.values.get(i);
            permTotal = permTotal + perm.get(i);
        }
        if (Math.abs(permTotal - origTotal) > 0.01) {
            throw new Error("Total permutation capacity " + permTotal + " not approximately equal to original capacity " + origTotal);
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.values.toString();
    }

    static enum PermutationRule {
        TEMPORAL_SHIFTS,
        BALANCING_SHIFTS,
        ALL_SHIFTS;

    }
}

