/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.List;
import java.util.Map;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ParserFunctions;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.powertac.factoredcustomer.interfaces.StructureInstance;

public final class CapacityStructure
implements StructureInstance {
    private String name;
    @ConfigurableValue(valueType="String")
    private String baseCapacityType;
    private ProbabilityDistribution basePopulationCapacity;
    private ProbabilityDistribution baseIndividualCapacity;
    @ConfigurableValue(valueType="List")
    private List<String> dailySkew;
    @ConfigurableValue(valueType="List")
    private List<String> hourlySkew;
    @ConfigurableValue(valueType="String")
    private String temperatureInfluence;
    @ConfigurableValue(valueType="List")
    private List<String> temperatureMap;
    @ConfigurableValue(valueType="Double")
    private double temperatureReference = Double.NaN;
    @ConfigurableValue(valueType="String")
    private String windSpeedInfluence;
    @ConfigurableValue(valueType="List")
    private List<String> windSpeedMap;
    @ConfigurableValue(valueType="String")
    private String windDirectionInfluence;
    @ConfigurableValue(valueType="List")
    private List<String> windDirectionMap;
    @ConfigurableValue(valueType="String")
    private String cloudCoverInfluence;
    @ConfigurableValue(valueType="List")
    private List<String> cloudCoverMap;
    @ConfigurableValue(valueType="List")
    private List<String> benchmarkRates;
    @ConfigurableValue(valueType="String")
    private String elasticityModelType;
    @ConfigurableValue(valueType="Double")
    private double elasticityRatio;
    @ConfigurableValue(valueType="String")
    private String elasticityRange;
    @ConfigurableValue(valueType="List")
    private List<String> elasticityMap;
    @ConfigurableValue(valueType="List")
    private List<String> curtailmentShifts;

    public CapacityStructure(String name) {
        this.name = name;
    }

    public void initialize(FactoredCustomerService service) {
        Map<String, StructureInstance> map = Config.getInstance().getStructures().get("ProbabilityDistribution");
        switch (BaseCapacityType.valueOf(this.baseCapacityType)) {
            case POPULATION: {
                this.basePopulationCapacity = (ProbabilityDistribution)map.get(this.name + "Population");
                if (this.basePopulationCapacity == null) break;
                this.basePopulationCapacity.initialize(service);
                break;
            }
            case INDIVIDUAL: {
                this.baseIndividualCapacity = (ProbabilityDistribution)map.get(this.name + "Population");
                if (this.baseIndividualCapacity == null) break;
                this.baseIndividualCapacity.initialize(service);
                break;
            }
            case TIMESERIES: {
                break;
            }
            default: {
                throw new Error("Unexpected base capacity type: " + this.baseCapacityType);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BaseCapacityType getBaseCapacityType() {
        return BaseCapacityType.valueOf(this.baseCapacityType);
    }

    public ProbabilityDistribution getBasePopulationCapacity() {
        return this.basePopulationCapacity;
    }

    public ProbabilityDistribution getBaseIndividualCapacity() {
        return this.baseIndividualCapacity;
    }

    public double getPeriodicSkew(int day, int hour) {
        return Double.parseDouble(this.dailySkew.get(day - 1)) * Double.parseDouble(this.hourlySkew.get(hour));
    }

    public InfluenceKind getTemperatureInfluence() {
        return InfluenceKind.valueOf(this.temperatureInfluence);
    }

    public double getTemperatureFactor(int temperature) {
        String tmp = ("" + this.temperatureMap).replace("[", "").replace("]", "");
        return ParserFunctions.parseRangeMap(tmp).get(temperature);
    }

    public double getTemperatureReference() {
        return this.temperatureReference;
    }

    public InfluenceKind getWindSpeedInfluence() {
        return InfluenceKind.valueOf(this.windSpeedInfluence);
    }

    public double getWindspeedFactor(int windspeed) {
        String tmp = ("" + this.windSpeedMap).replace("[", "").replace("]", "");
        return ParserFunctions.parseRangeMap(tmp).get(windspeed);
    }

    public InfluenceKind getWindDirectionInfluence() {
        return InfluenceKind.valueOf(this.windDirectionInfluence);
    }

    public double getWindDirectionFactor(int windDirection) {
        String tmp = ("" + this.windDirectionMap).replace("[", "").replace("]", "");
        return ParserFunctions.parseRangeMap(tmp).get(windDirection);
    }

    public InfluenceKind getCloudCoverInfluence() {
        return InfluenceKind.valueOf(this.cloudCoverInfluence);
    }

    public double getCloudCoverFactor(int cloudCover) {
        String tmp = ("" + this.cloudCoverMap).replace("[", "").replace("]", "");
        return ParserFunctions.parseRangeMap(tmp).get(cloudCover);
    }

    public double getBenchmarkRate(int hour) {
        String tmp = ("" + this.benchmarkRates).replace("[", "").replace("]", "");
        return ParserFunctions.parseRangeMap(tmp).get(hour);
    }

    public ElasticityModelType getElasticityModelType() {
        return ElasticityModelType.valueOf(this.elasticityModelType);
    }

    public double determineContinuousElasticityFactor(double rateRatio) {
        double percentChange = rateRatio - 1.0;
        String[] minMax = this.elasticityRange.split("~");
        double low = Double.parseDouble(minMax[0]);
        double high = Double.parseDouble(minMax[1]);
        return Math.max(low, Math.min(high, 1.0 + percentChange * this.elasticityRatio));
    }

    public double[][] getElasticity() {
        String tmp = ("" + this.elasticityMap).replace("[", "").replace("]", "");
        return ParserFunctions.parseMapToDoubleArray(tmp);
    }

    public List<String> getCurtailmentShifts() {
        return this.curtailmentShifts;
    }

    public static enum ElasticityModelType {
        CONTINUOUS,
        STEPWISE;

    }

    public static enum BaseCapacityType {
        POPULATION,
        INDIVIDUAL,
        TIMESERIES;

    }

    public static enum InfluenceKind {
        DIRECT,
        DEVIATION,
        NONE;

    }
}

