/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.powertac.common.CustomerInfo;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.AdaptiveCapacityOriginator;
import org.powertac.factoredcustomer.CapacityStructure;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultCapacityOriginator;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ProfileOptimizerStructure;
import org.powertac.factoredcustomer.TariffSubscriberStructure;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.powertac.factoredcustomer.interfaces.StructureInstance;

@Domain
public class DefaultCapacityBundle
implements CapacityBundle,
StructureInstance {
    protected FactoredCustomerService service;
    private CustomerStructure customerStructure;
    protected String name;
    @ConfigurableValue(valueType="Integer")
    protected int count;
    @ConfigurableValue(valueType="Integer")
    protected int population;
    @ConfigurableValue(valueType="String")
    protected String type;
    @ConfigurableValue(valueType="Boolean")
    protected boolean multiContracting;
    @ConfigurableValue(valueType="Boolean")
    protected boolean canNegotiate;
    @ConfigurableValue(valueType="Boolean")
    protected boolean isAdaptive;
    private CustomerInfo customerInfo;
    private TariffSubscriberStructure subscriberStructure;
    private ProfileOptimizerStructure optimizerStructure;
    protected List<CapacityOriginator> capacityOriginators = new ArrayList<CapacityOriginator>();

    public DefaultCapacityBundle(String name) {
        this.name = name;
    }

    @Override
    public void initialize(FactoredCustomerService service, CustomerStructure customerStructure) {
        this.service = service;
        this.customerStructure = customerStructure;
        this.customerInfo = new CustomerInfo(this.name, this.population).withPowerType(PowerType.valueOf((String)this.type)).withMultiContracting(this.multiContracting).withCanNegotiate(this.canNegotiate);
        Config config = Config.getInstance();
        Map<String, StructureInstance> subscribers = config.getStructures().get("TariffSubscriberStructure");
        Map<String, StructureInstance> optimizers = config.getStructures().get("ProfileOptimizerStructure");
        Map<String, StructureInstance> capacities = config.getStructures().get("CapacityStructure");
        this.subscriberStructure = (TariffSubscriberStructure)subscribers.get(this.name);
        if (this.subscriberStructure == null) {
            throw new Error("No TariffSubscriberStructure for : " + this.name);
        }
        this.subscriberStructure.initialize(service);
        this.optimizerStructure = (ProfileOptimizerStructure)optimizers.get(this.name);
        if (this.optimizerStructure == null) {
            this.optimizerStructure = new ProfileOptimizerStructure(this.name);
        }
        if (this.count > 1) {
            for (int j = 0; j < this.count; ++j) {
                CapacityStructure capacityStructure = (CapacityStructure)capacities.get(this.name + (j + 1));
                if (capacityStructure == null) {
                    throw new Error("No CapacityStructure for " + this.name + (j + 1));
                }
                capacityStructure.initialize(service);
                this.capacityOriginators.add(this.createCapacityOriginator(capacityStructure));
            }
        } else {
            CapacityStructure capacityStructure = (CapacityStructure)capacities.get(this.name);
            if (capacityStructure == null) {
                throw new Error("No CapacityStructure for " + this.name);
            }
            capacityStructure.initialize(service);
            this.capacityOriginators.add(this.createCapacityOriginator(capacityStructure));
        }
    }

    protected CapacityOriginator createCapacityOriginator(CapacityStructure capacityStructure) {
        if (this.isAdaptive) {
            return new AdaptiveCapacityOriginator(this.service, capacityStructure, this);
        }
        return new DefaultCapacityOriginator(this.service, capacityStructure, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPopulation() {
        return this.customerInfo.getPopulation();
    }

    @Override
    public PowerType getPowerType() {
        return this.customerInfo.getPowerType();
    }

    @Override
    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    @Override
    public TariffSubscriberStructure getSubscriberStructure() {
        return this.subscriberStructure;
    }

    @Override
    public ProfileOptimizerStructure getOptimizerStructure() {
        return this.optimizerStructure;
    }

    @Override
    public List<CapacityOriginator> getCapacityOriginators() {
        return this.capacityOriginators;
    }
}

