/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.TariffSubscription;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultUtilityOptimizer;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ProfileOptimizerStructure;
import org.powertac.factoredcustomer.ProfileRecommendation;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.powertac.factoredcustomer.utils.SeedIdGenerator;

@Domain
class LearningUtilityOptimizer
extends DefaultUtilityOptimizer {
    private static Logger log = LogManager.getLogger(LearningUtilityOptimizer.class);

    public LearningUtilityOptimizer(CustomerStructure customerStructure, List<CapacityBundle> bundles) {
        super(customerStructure, bundles);
    }

    @Override
    public void initialize(FactoredCustomerService service) {
        this.service = service;
        this.inertiaSampler = this.getRandomSeedRepo().getRandomSeed("factoredcustomer.LearningUtilityOptimizer", (long)SeedIdGenerator.getId(), "InertiaSampler");
        this.tariffSelector = this.getRandomSeedRepo().getRandomSeed("factoredcustomer.LearningUtilityOptimizer", (long)SeedIdGenerator.getId(), "TariffSelector");
        this.subscribeDefault();
    }

    @Override
    public void evaluateTariffs() {
        super.evaluateTariffs();
    }

    @Override
    public void updatedSubscriptionRepo() {
        this.recommendProfilesToBundles();
    }

    private void recommendProfilesToBundles() {
        for (CapacityBundle bundle : this.capacityBundles) {
            List<TariffSubscription> subscriptions = this.getBundleSubscriptions(bundle);
            if (!bundle.getOptimizerStructure().isReceiveRecommendations()) continue;
            this.recommendProfilesToBundle(bundle, subscriptions);
        }
    }

    private void recommendProfilesToBundle(CapacityBundle bundle, List<TariffSubscription> subscriptions) {
        HashMap<CapacityOriginator, Map<TariffSubscription, List<CapacityProfile>>> permsPerSub = new HashMap<CapacityOriginator, Map<TariffSubscription, List<CapacityProfile>>>();
        HashMap<CapacityOriginator, Map<TariffSubscription, ProfileRecommendation>> recsPerSub = new HashMap<CapacityOriginator, Map<TariffSubscription, ProfileRecommendation>>();
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            CapacityProfile.PermutationRule permutationRule = bundle.getOptimizerStructure().getPermutationRule();
            if (permutationRule == null) {
                permutationRule = CapacityProfile.PermutationRule.ALL_SHIFTS;
            }
            permsPerSub.put(capacityOriginator, new HashMap());
            for (TariffSubscription sub : subscriptions) {
                CapacityProfile forecastPerSub = capacityOriginator.getCurrentForecastPerSub(sub);
                double charge = this.computeProfileUsageChargePerSub(forecastPerSub, sub, capacityOriginator);
                ForecastRecord forecastRecordPerSub = new ForecastRecord(forecastPerSub, charge);
                ((Map)permsPerSub.get(capacityOriginator)).put(sub, forecastPerSub.getPermutations(permutationRule));
                this.insertToRecsMap(recsPerSub, capacityOriginator, sub, this.getProfileRecommendationPerSub(capacityOriginator, bundle, forecastRecordPerSub, permsPerSub, sub));
            }
        }
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            if (!(capacityOriginator instanceof ProfileRecommendation.Listener)) continue;
            for (TariffSubscription sub : subscriptions) {
                ProfileRecommendation rec = (ProfileRecommendation)((Map)recsPerSub.get(capacityOriginator)).get(sub);
                if (!rec.isEmpty()) {
                    log.info(bundle.getName() + ": Submitting " + rec.getOpinions().size() + " profile suggestions to " + bundle.getCustomerInfo().getPowerType() + " capacity originator: " + capacityOriginator.getCapacityName());
                    ((ProfileRecommendation.Listener)((Object)capacityOriginator)).handleProfileRecommendationPerSub(rec, sub, capacityOriginator.getCurrentForecast());
                    continue;
                }
                log.info(bundle.getName() + ": No beneficial profile permutations for " + bundle.getCustomerInfo().getPowerType() + " capacity originator: " + capacityOriginator.getCapacityName());
            }
        }
    }

    private void insertToRecsMap(Map<CapacityOriginator, Map<TariffSubscription, ProfileRecommendation>> recs, CapacityOriginator capacityOriginator, TariffSubscription sub, ProfileRecommendation profileRecommendation) {
        Map<TariffSubscription, ProfileRecommendation> sub2rec = recs.get(capacityOriginator);
        if (null == sub2rec) {
            sub2rec = new HashMap<TariffSubscription, ProfileRecommendation>();
            recs.put(capacityOriginator, sub2rec);
        }
        sub2rec.put(sub, profileRecommendation);
    }

    @Override
    public double[] adjustForecastPerTariff(HashMap<CapacityOriginator, double[]> originator2usage, TariffSubscription dummySubscription, CapacityBundle bundle) {
        ArrayList<TariffSubscription> subscriptions = new ArrayList<TariffSubscription>();
        subscriptions.add(dummySubscription);
        this.recommendProfilesToBundle(bundle, subscriptions);
        int nextTimeslot = this.service.getTimeslotRepo().currentSerialNumber() + 1;
        HashMap<CapacityOriginator, double[]> originator2shiftedUsage = new HashMap<CapacityOriginator, double[]>();
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            if (!(capacityOriginator instanceof ProfileRecommendation.Listener)) continue;
            for (TariffSubscription sub : subscriptions) {
                CapacityProfile chosenProfile = capacityOriginator.getForecastPerSubStartingAt(nextTimeslot, sub);
                double[] usage = new double[24];
                for (int i = 0; i < 24; ++i) {
                    usage[i] = chosenProfile.getCapacity(i);
                }
                originator2shiftedUsage.put(capacityOriginator, usage);
            }
        }
        return super.adjustForecastPerTariff(originator2shiftedUsage, dummySubscription, bundle);
    }

    private List<TariffSubscription> getBundleSubscriptions(CapacityBundle bundle) {
        return this.getTariffSubscriptionRepo().findSubscriptionsForCustomer(bundle.getCustomerInfo());
    }

    private ProfileRecommendation getProfileRecommendationPerSub(CapacityOriginator capacityOriginator, CapacityBundle bundle, ForecastRecord forecastRecord, Map<CapacityOriginator, Map<TariffSubscription, List<CapacityProfile>>> permsPerSub, TariffSubscription sub) {
        this.logRecommendationDetails("getProfileRecommendationPerSub(" + sub.getCustomer().getName() + ", " + sub.getTariff().getId() + ") Forecast " + forecastRecord.capacityProfile + " usage charge = " + forecastRecord.usageCharge);
        ProfileRecommendation rec = new ProfileRecommendation();
        for (CapacityProfile perm : permsPerSub.get(capacityOriginator).get(sub)) {
            double usageCharge = this.computeProfileUsageChargePerSub(perm, sub, capacityOriginator);
            if (!this.isPermutationAcceptable(capacityOriginator, bundle.getOptimizerStructure(), usageCharge, forecastRecord.usageCharge)) continue;
            ProfileRecommendation.Opinion opinion = new ProfileRecommendation.Opinion(rec);
            opinion.usageCharge = usageCharge;
            opinion.profileChange = forecastRecord.capacityProfile.distanceTo(perm);
            rec.setOpinion(perm, opinion);
        }
        if (!rec.isEmpty()) {
            this.computeDerivedValues(rec, bundle.getOptimizerStructure());
        }
        return rec;
    }

    private void computeDerivedValues(ProfileRecommendation rec, ProfileOptimizerStructure optimizerStructure) {
        rec.normalizeOpinions();
        rec.computeScores(optimizerStructure.getProfileChangeWeight(), optimizerStructure.getBundleValueWeight());
        rec.computeUtilities();
        rec.computeProbabilities(optimizerStructure.getRationalityFactor());
    }

    private double computeProfileUsageChargePerSub(CapacityProfile profile, TariffSubscription subscription, CapacityOriginator capacityOriginator) {
        int timeslot = this.getTimeslotRepo().currentSerialNumber();
        double totalCharge = 0.0;
        for (int i = 0; i < 24; ++i) {
            double totalTimeslotUsage = profile.getCapacity(i);
            double timeslotCharge = 0.0;
            double subTimeslotUsage = capacityOriginator.adjustCapacityForSubscription(timeslot, totalTimeslotUsage, subscription);
            totalCharge += (timeslotCharge += subscription.getTariff().getUsageCharge(this.getTimeslotRepo().getTimeForIndex(timeslot), subTimeslotUsage, 0.0));
            ++timeslot;
        }
        return totalCharge;
    }

    private boolean isPermutationAcceptable(CapacityOriginator capacityOriginator, ProfileOptimizerStructure optimizerStructure, double permCharge, double forecastCharge) {
        Double threshold = null;
        switch (optimizerStructure.getUsageChargeStance()) {
            case NEUTRAL: {
                return true;
            }
            case BENEFIT: {
                threshold = capacityOriginator.getParentBundle().getCustomerInfo().getPowerType().isConsumption() ? Double.valueOf((1.0 - optimizerStructure.getUsageChargePercentBenefit()) * forecastCharge) : Double.valueOf((1.0 + optimizerStructure.getUsageChargePercentBenefit()) * forecastCharge);
            }
            case THRESHOLD: {
                if (threshold == null) {
                    threshold = optimizerStructure.getUsageChargeThreshold();
                }
                return permCharge > threshold;
            }
        }
        throw new Error("Unexpected case in usage charge stance: " + (Object)((Object)optimizerStructure.getUsageChargeStance()));
    }

    private void logRecommendationDetails(String msg) {
        log.debug(msg);
    }

    private class ForecastRecord {
        CapacityProfile capacityProfile;
        double usageCharge;

        ForecastRecord(CapacityProfile p, double c) {
            this.capacityProfile = p;
            this.usageCharge = c;
        }
    }
}

