/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.Map;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.powertac.factoredcustomer.interfaces.StructureInstance;

public final class TariffSubscriberStructure
implements StructureInstance {
    private String name;
    private double inconvenienceWeight = 0.2;
    private double touFactor = 0.05;
    @ConfigurableValue(valueType="Double")
    private double interruptibilityFactor = 0.5;
    private double variablePricingFactor = 0.7;
    private double tieredRateFactor = 0.1;
    private double tariffSwitchFactor = 0.1;
    private double brokerSwitchFactor = 0.02;
    private int expectedDuration = 14;
    @ConfigurableValue(valueType="Double")
    private Double expMeanPriceWeight;
    @ConfigurableValue(valueType="Double")
    private Double maxValuePriceWeight;
    @ConfigurableValue(valueType="Double")
    private Double realizedPriceWeight;
    @ConfigurableValue(valueType="Double")
    private Double tariffVolumeThreshold = 20000.0;
    @ConfigurableValue(valueType="String")
    private String allocationMethod;
    @ConfigurableValue(valueType="Double")
    private double logitChoiceRationality;
    private ProbabilityDistribution inertiaDistribution;

    public TariffSubscriberStructure(String name) {
        this.name = name;
    }

    public void initialize(FactoredCustomerService service) {
        double divisor = this.touFactor + this.interruptibilityFactor + this.variablePricingFactor + this.tieredRateFactor + this.tariffSwitchFactor + this.brokerSwitchFactor;
        if (divisor != 0.0) {
            this.touFactor /= divisor;
            this.interruptibilityFactor /= divisor;
            this.variablePricingFactor /= divisor;
            this.tieredRateFactor /= divisor;
            this.tariffSwitchFactor /= divisor;
            this.brokerSwitchFactor /= divisor;
        }
        if (this.allocationMethod.equals(AllocationMethod.TOTAL_ORDER.toString())) {
            this.logitChoiceRationality = 1.0;
        }
        Map<String, StructureInstance> map = Config.getInstance().getStructures().get("ProbabilityDistribution");
        this.inertiaDistribution = (ProbabilityDistribution)map.get(this.name + "Inertia");
        if (this.inertiaDistribution != null) {
            this.inertiaDistribution.initialize(service);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double getInconvenienceWeight() {
        return this.inconvenienceWeight;
    }

    public double getTouFactor() {
        return this.touFactor;
    }

    public double getInterruptibilityFactor() {
        return this.interruptibilityFactor;
    }

    public double getVariablePricingFactor() {
        return this.variablePricingFactor;
    }

    public double getTieredRateFactor() {
        return this.tieredRateFactor;
    }

    public double getTariffSwitchFactor() {
        return this.tariffSwitchFactor;
    }

    public double getBrokerSwitchFactor() {
        return this.brokerSwitchFactor;
    }

    public int getExpectedDuration() {
        return this.expectedDuration;
    }

    public Double getExpMeanPriceWeight() {
        return this.expMeanPriceWeight;
    }

    public Double getMaxValuePriceWeight() {
        return this.maxValuePriceWeight;
    }

    public Double getRealizedPriceWeight() {
        return this.realizedPriceWeight;
    }

    public Double getTariffVolumeThreshold() {
        return this.tariffVolumeThreshold;
    }

    public double getLogitChoiceRationality() {
        return this.logitChoiceRationality;
    }

    public ProbabilityDistribution getInertiaDistribution() {
        return this.inertiaDistribution;
    }

    private static enum AllocationMethod {
        TOTAL_ORDER,
        LOGIT_CHOICE;

    }
}

