/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.factoredcustomer.interfaces.StructureInstance;

public final class Config {
    private static Logger log = LogManager.getLogger((String)Config.class.getName());
    private static Config instance = null;
    private ServerConfiguration serverConfiguration;
    @ConfigurableValue(valueType="Boolean", dump=false, description="Toggle logging of tariff allocation details")
    private boolean allocationDetailsLogging = true;
    @ConfigurableValue(valueType="Boolean", dump=false, description="Toogle logging of capacity adjustment details")
    private boolean capacityDetailsLogging = false;
    @ConfigurableValue(valueType="Boolean", dump=false, description="Toggle logging of expected usage charges")
    private boolean usageChargesLogging = false;
    @ConfigurableValue(valueType="List", dump=false, description="classnames of bean types to be configured")
    private List<String> structureTypes = new ArrayList<String>();
    private Map<String, Map<String, StructureInstance>> structures;

    private Config(ServerConfiguration source) {
        this.serverConfiguration = source;
    }

    public boolean isAllocationDetailsLogging() {
        return this.allocationDetailsLogging;
    }

    public boolean isCapacityDetailsLogging() {
        return this.capacityDetailsLogging;
    }

    public boolean isUsageChargesLogging() {
        return this.usageChargesLogging;
    }

    public List<String> getStructureTypes() {
        return this.structureTypes;
    }

    public void configure() {
        if (null == this.serverConfiguration) {
            log.error("Config not initialized");
            return;
        }
        this.serverConfiguration.configureMe((Object)this);
        this.structures = new HashMap<String, Map<String, StructureInstance>>();
        for (String classname : this.structureTypes) {
            try {
                Class<?> clazz = Class.forName("org.powertac.factoredcustomer." + classname);
                Collection list = this.serverConfiguration.configureInstances(clazz);
                if (list == null) {
                    this.structures.put(classname, new HashMap());
                    log.info("No instances of " + classname);
                    continue;
                }
                LinkedHashMap<String, StructureInstance> instanceMap = new LinkedHashMap<String, StructureInstance>();
                for (Object thing : list) {
                    StructureInstance instance = (StructureInstance)thing;
                    instanceMap.put(instance.getName(), instance);
                }
                this.structures.put(classname, instanceMap);
                log.info("Loaded " + list.size() + " instances of " + classname);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                log.error("Cannot find class " + classname);
            }
        }
    }

    public Map<String, Map<String, StructureInstance>> getStructures() {
        if (null == this.structures) {
            log.error("Call to getStructures() before initialization");
            return null;
        }
        return this.structures;
    }

    public static synchronized Config getInstance() {
        if (null == instance) {
            log.error("Unconfigured instance requested");
        }
        return instance;
    }

    public static synchronized void initializeInstance(ServerConfiguration configSource) {
        instance = new Config(configSource);
    }
}

