/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.Map;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.interfaces.FactoredCustomer;

final class CustomerFactory {
    private CustomerCreator defaultCreator;
    private Map<String, CustomerCreator> customerCreators = new HashMap<String, CustomerCreator>();

    CustomerFactory() {
    }

    void registerDefaultCreator(CustomerCreator creator) {
        this.defaultCreator = creator;
    }

    void registerCreator(CustomerCreator creator) {
        this.registerCreator(creator.getKey(), creator);
    }

    private void registerCreator(String key, CustomerCreator creator) {
        this.customerCreators.put(key, creator);
    }

    FactoredCustomer processStructure(CustomerStructure customerStructure) {
        if (customerStructure.getCreatorKey() == null || customerStructure.getCreatorKey().trim().isEmpty()) {
            return this.defaultCreator.createModel(customerStructure);
        }
        CustomerCreator creator = this.customerCreators.get(customerStructure.getCreatorKey());
        if (creator != null) {
            return creator.createModel(customerStructure);
        }
        throw new Error("CustomerFactory does not have a registered creator for key: " + customerStructure.getCreatorKey());
    }

    public static interface CustomerCreator {
        public String getKey();

        public FactoredCustomer createModel(CustomerStructure var1);
    }
}

