/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.factoredcustomer.CapacityAccumulator;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.TariffSubscriberStructure;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.powertac.factoredcustomer.interfaces.UtilityOptimizer;
import org.powertac.factoredcustomer.utils.SeedIdGenerator;

class DefaultUtilityOptimizer
implements UtilityOptimizer {
    private static Logger log = LogManager.getLogger((String)DefaultUtilityOptimizer.class.getName());
    protected FactoredCustomerService service;
    private final CustomerStructure customerStructure;
    protected final List<CapacityBundle> capacityBundles;
    protected RandomSeed inertiaSampler;
    protected RandomSeed tariffSelector;
    private HashMap<CapacityBundle, TariffEvaluator> evaluatorMap;

    DefaultUtilityOptimizer(CustomerStructure customerStructure, List<CapacityBundle> bundles) {
        this.customerStructure = customerStructure;
        this.capacityBundles = bundles;
        this.evaluatorMap = new HashMap();
        for (CapacityBundle bundle : bundles) {
            TariffSubscriberStructure subStructure = bundle.getSubscriberStructure();
            TariffEvaluator evaluator = new TariffEvaluator((CustomerModelAccessor)new TariffEvaluationWrapper(bundle)).withChunkSize(Math.max(1, bundle.getPopulation() / 1000)).withTariffSwitchFactor(subStructure.getTariffSwitchFactor()).withPreferredContractDuration((double)subStructure.getExpectedDuration()).withInconvenienceWeight(subStructure.getInconvenienceWeight()).withRationality(subStructure.getLogitChoiceRationality()).withEvaluateAllTariffs(true);
            evaluator.initializeCostFactors(subStructure.getExpMeanPriceWeight().doubleValue(), subStructure.getMaxValuePriceWeight().doubleValue(), subStructure.getRealizedPriceWeight().doubleValue(), subStructure.getTariffVolumeThreshold().doubleValue());
            evaluator.initializeInconvenienceFactors(subStructure.getTouFactor(), subStructure.getTieredRateFactor(), subStructure.getVariablePricingFactor(), subStructure.getInterruptibilityFactor());
            evaluator.initializeRegulationFactors(subStructure.getExpUpRegulation(), 0.0, subStructure.getExpDownRegulation());
            this.evaluatorMap.put(bundle, evaluator);
        }
    }

    @Override
    public void initialize(FactoredCustomerService service) {
        this.service = service;
        this.inertiaSampler = this.getRandomSeedRepo().getRandomSeed("factoredcustomer.DefaultUtilityOptimizer", (long)SeedIdGenerator.getId(), "InertiaSampler");
        this.tariffSelector = this.getRandomSeedRepo().getRandomSeed("factoredcustomer.DefaultUtilityOptimizer", (long)SeedIdGenerator.getId(), "TariffSelector");
        this.subscribeDefault();
    }

    protected RandomSeedRepo getRandomSeedRepo() {
        return this.service.getRandomSeedRepo();
    }

    protected TariffMarket getTariffMarket() {
        return this.service.getTariffMarket();
    }

    protected TariffSubscriptionRepo getTariffSubscriptionRepo() {
        return this.service.getTariffSubscriptionRepo();
    }

    protected TariffRepo getTariffRepo() {
        return this.service.getTariffRepo();
    }

    protected TimeslotRepo getTimeslotRepo() {
        return this.service.getTimeslotRepo();
    }

    private void subscribe(Tariff tariff, CapacityBundle bundle, int customerCount, boolean verbose) {
        this.getTariffMarket().subscribeToTariff(tariff, bundle.getCustomerInfo(), customerCount);
        if (verbose) {
            log.info(bundle.getName() + ": Subscribed " + customerCount + " customers to tariff " + tariff.getId() + " successfully");
        }
    }

    protected void subscribeDefault() {
        for (CapacityBundle bundle : this.capacityBundles) {
            PowerType powerType = bundle.getPowerType();
            if (this.getTariffMarket().getDefaultTariff(powerType) != null) {
                log.info(bundle.getName() + ": Subscribing " + bundle.getPopulation() + " customers to default " + powerType + " tariff");
                this.subscribe(this.getTariffMarket().getDefaultTariff(powerType), bundle, bundle.getPopulation(), false);
                continue;
            }
            log.info(bundle.getName() + ": No default tariff for power type " + powerType + "; trying generic type");
            PowerType genericType = powerType.getGenericType();
            if (this.getTariffMarket().getDefaultTariff(genericType) == null) {
                log.error(bundle.getName() + ": No default tariff for generic power type " + genericType + " either!");
                continue;
            }
            log.info(bundle.getName() + ": Subscribing " + bundle.getPopulation() + " customers to default " + genericType + " tariff");
            this.subscribe(this.getTariffMarket().getDefaultTariff(genericType), bundle, bundle.getPopulation(), false);
        }
    }

    @Override
    public void evaluateTariffs() {
        for (CapacityBundle bundle : this.capacityBundles) {
            TariffEvaluator evaluator = this.evaluatorMap.get(bundle);
            if (bundle.getSubscriberStructure().getInertiaDistribution() != null) {
                evaluator.withInertia(bundle.getSubscriberStructure().getInertiaDistribution().drawSample());
            } else {
                log.warn("no inertia distro, using default value 0.7");
                evaluator.withInertia(0.7);
            }
            evaluator.evaluateTariffs();
        }
    }

    @Override
    public void updatedSubscriptionRepo() {
    }

    @Override
    public void handleNewTimeslot(Timeslot timeslot) {
        this.usePower(timeslot);
    }

    private void usePower(Timeslot timeslot) {
        for (CapacityBundle bundle : this.capacityBundles) {
            List subscriptions = this.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(bundle.getCustomerInfo());
            double totalCapacity = 0.0;
            double totalUsageCharge = 0.0;
            ArrayList<CapacityOriginator> allOriginators = new ArrayList<CapacityOriginator>(bundle.getCapacityOriginators());
            int lastOriginator = 0;
            for (TariffSubscription subscription : subscriptions) {
                double usageSign = bundle.getPowerType().isConsumption() ? 1.0 : -1.0;
                List<CapacityOriginator> originators = allOriginators;
                if (bundle.isAllIndividual()) {
                    originators = allOriginators.subList(lastOriginator, lastOriginator + subscription.getCustomersCommitted());
                    lastOriginator += subscription.getCustomersCommitted();
                }
                CapacityAccumulator ca = this.useCapacity(bundle, subscription, originators);
                double currCapacity = usageSign * ca.getCapacity();
                if (Config.getInstance().isUsageChargesLogging()) {
                    double charge = subscription.getTariff().getUsageCharge(currCapacity, subscription.getTotalUsage(), false);
                    totalUsageCharge += charge;
                }
                subscription.usePower(currCapacity);
                subscription.setRegulationCapacity(new RegulationCapacity(subscription, ca.getUpRegulationCapacity(), ca.getDownRegulationCapacity()));
                totalCapacity += currCapacity;
            }
            log.info(bundle.getName() + ": Total " + bundle.getPowerType() + " capacity for timeslot " + timeslot.getSerialNumber() + " = " + totalCapacity);
            this.logUsageCharges(bundle.getName() + ": Total " + bundle.getPowerType() + " usage charge for timeslot " + timeslot.getSerialNumber() + " = " + totalUsageCharge);
        }
    }

    private CapacityAccumulator useCapacity(CapacityBundle bundle, TariffSubscription subscription, List<CapacityOriginator> originators) {
        CapacityAccumulator capacity = new CapacityAccumulator();
        for (CapacityOriginator capacityOriginator : originators) {
            capacity.add(capacityOriginator.useCapacity(subscription));
        }
        if (bundle.isAllIndividual()) {
            capacity.scale((double)subscription.getCustomersCommitted() / (double)originators.size());
        }
        return capacity;
    }

    private String getCustomerName() {
        return this.customerStructure.getName();
    }

    private void logUsageCharges(String msg) {
        if (Config.getInstance().isUsageChargesLogging()) {
            log.info(msg);
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.getCustomerName();
    }

    public double[] adjustForecastPerTariff(HashMap<CapacityOriginator, double[]> originator2usage, TariffSubscription dummySubscription, CapacityBundle bundle) {
        double[] result = new double[originator2usage.values().iterator().next().length];
        for (double[] usage : originator2usage.values()) {
            for (int i = 0; i < result.length; ++i) {
                int n = i;
                result[n] = result[n] + usage[i] / (double)bundle.getPopulation();
            }
        }
        return result;
    }

    private class DummyTariffSubscription
    extends TariffSubscription {
        public DummyTariffSubscription(CustomerInfo customer, Tariff tariff) {
            super(customer, tariff);
        }

        public int getCustomersCommitted() {
            return 1;
        }
    }

    private class TariffEvaluationWrapper
    implements CustomerModelAccessor {
        private CapacityBundle bundle;
        private TariffSubscriberStructure subStructure;

        TariffEvaluationWrapper(CapacityBundle bundle) {
            this.bundle = bundle;
            this.subStructure = bundle.getSubscriberStructure();
        }

        public CustomerInfo getCustomerInfo() {
            return this.bundle.getCustomerInfo();
        }

        public org.powertac.common.CapacityProfile getCapacityProfile(Tariff tariff) {
            double[] newForecast;
            double usageSign = this.bundle.getPowerType().isConsumption() ? 1.0 : -1.0;
            HashMap<CapacityOriginator, double[]> originator2usage = new HashMap<CapacityOriginator, double[]>();
            for (CapacityOriginator capacityOriginator : this.bundle.getCapacityOriginators()) {
                double[] usageForecast = new double[24];
                CapacityProfile forecast = capacityOriginator.getForecastForNextTimeslot();
                for (int i = 0; i < 24; ++i) {
                    double hourlyUsage;
                    usageForecast[i] = hourlyUsage = usageSign * forecast.getCapacity(i);
                }
                originator2usage.put(capacityOriginator, usageForecast);
            }
            DummyTariffSubscription dummySubscription = new DummyTariffSubscription(this.getCustomerInfo(), tariff);
            double[] result = newForecast = DefaultUtilityOptimizer.this.adjustForecastPerTariff(originator2usage, dummySubscription, this.bundle);
            Instant start = DefaultUtilityOptimizer.this.service.getTimeService().getCurrentTime().plus(3600000L);
            return new org.powertac.common.CapacityProfile(result, start);
        }

        public double getBrokerSwitchFactor(boolean isSuperseding) {
            double result = this.subStructure.getBrokerSwitchFactor();
            if (isSuperseding) {
                return result * 5.0;
            }
            return result;
        }

        public double getTariffChoiceSample() {
            return DefaultUtilityOptimizer.this.tariffSelector.nextDouble();
        }

        public double getInertiaSample() {
            return DefaultUtilityOptimizer.this.inertiaSampler.nextDouble();
        }

        public double getShiftingInconvenienceFactor(Tariff tariff) {
            double inconv = 0.0;
            for (CapacityOriginator capacityOriginator : this.bundle.getCapacityOriginators()) {
                inconv += capacityOriginator.getShiftingInconvenienceFactor(tariff);
            }
            return inconv;
        }
    }
}

