/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.interfaces.StructureInstance;
import org.powertac.factoredcustomer.utils.SeedIdGenerator;

public final class TimeseriesGenerator
implements StructureInstance {
    private static Logger log = LogManager.getLogger(TimeseriesGenerator.class);
    private TimeslotRepo timeslotRepo;
    private final int FORECAST_HORIZON = 48;
    private String name;
    @ConfigurableValue(valueType="Double", dump=false)
    private double y0;
    @ConfigurableValue(valueType="List", dump=false)
    private List<String> yh;
    @ConfigurableValue(valueType="List", dump=false)
    private List<String> yd;
    @ConfigurableValue(valueType="Double", dump=false)
    private double phi1;
    @ConfigurableValue(valueType="Double", dump=false)
    private double Phi1;
    @ConfigurableValue(valueType="Double", dump=false)
    private double theta1;
    @ConfigurableValue(valueType="Double", dump=false)
    private double Theta1;
    @ConfigurableValue(valueType="Double", dump=false)
    private double sigma;
    @ConfigurableValue(valueType="Double", dump=false)
    private double lambda;
    @ConfigurableValue(valueType="Double", dump=false)
    private double gamma;
    @ConfigurableValue(valueType="List", dump=false)
    private List<String> refSeries;
    private final Map<Integer, Double> genSeries = new HashMap<Integer, Double>();
    private Random arimaNoise;

    public TimeseriesGenerator(String name) {
        this.name = name;
    }

    public void initialize(FactoredCustomerService service) {
        this.timeslotRepo = service.getTimeslotRepo();
        this.arimaNoise = new Random(service.getRandomSeedRepo().getRandomSeed("factoredcustomer.TimeseriesGenerator", (long)SeedIdGenerator.getId(), "ArimaNoise").getValue());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double generateNext(int timeslot) {
        Double next;
        if (this.genSeries.isEmpty()) {
            this.initArima101x101GenSeries(timeslot);
        }
        if ((next = this.genSeries.get(timeslot)) == null) {
            next = this.generateNextArima101x101(timeslot);
            this.genSeries.put(timeslot, next);
        }
        return next;
    }

    private void initArima101x101GenSeries(int timeslot) {
        for (int i = 0; i < this.refSeries.size(); ++i) {
            this.genSeries.put(timeslot + i, Double.parseDouble(this.refSeries.get(i)));
        }
    }

    private double generateNextArima101x101(int timeslot) {
        DateTime now = this.timeslotRepo.getDateTimeForIndex(timeslot);
        int day = now.getDayOfWeek();
        int hour = now.getHourOfDay();
        double yh_hour = Double.parseDouble(this.yh.get(hour));
        double yd_day = Double.parseDouble(this.yd.get(day - 1));
        double logNext = this.y0 + yd_day + yh_hour + this.phi1 * this.getLog(timeslot - 1) + this.Phi1 * this.getLog(timeslot - 24) + this.theta1 * (this.getLog(timeslot - 1) - this.getLog(timeslot - 2)) + this.Theta1 * (this.getLog(timeslot - 24) - this.getLog(timeslot - 25)) + this.theta1 * this.Theta1 * (this.getLog(timeslot - 25) - this.getLog(timeslot - 26));
        double nom = Math.pow(Math.log(timeslot - 26), 2.0);
        double denom = Math.pow(Math.log(22.0), 2.0);
        double fact = (1.0 - this.gamma) * yh_hour + this.gamma * yd_day;
        logNext += this.lambda * (nom / denom) * fact;
        double next = Math.exp(logNext += Math.pow(this.sigma, 2.0) * this.arimaNoise.nextGaussian());
        if (Double.isNaN(next)) {
            throw new Error("Generated NaN as next time series element!");
        }
        return next;
    }

    private double getLog(int timeslot) {
        Double val = this.genSeries.get(timeslot);
        if (null == val) {
            log.error("Null value in genSeries for ts " + timeslot);
            return 1.0;
        }
        return Math.log(val);
    }
}

