/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TimeService;
import org.powertac.common.WeatherForecast;
import org.powertac.common.WeatherForecastPrediction;
import org.powertac.common.WeatherReport;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherForecastRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.factoredcustomer.CapacityAccumulator;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CapacityStructure;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.TimeseriesGenerator;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.powertac.factoredcustomer.interfaces.StructureInstance;

class DefaultCapacityOriginator
implements CapacityOriginator {
    private static Logger log = LogManager.getLogger(DefaultCapacityOriginator.class);
    private TimeService timeService;
    private TimeslotRepo timeslotRepo;
    private WeatherReportRepo weatherReportRepo;
    private WeatherForecastRepo weatherForecastRepo;
    private final double SMOOTHING_WEIGHT = 0.4;
    private final TimeseriesGenerator tsGenerator;
    private final CapacityStructure capacityStructure;
    private final CapacityBundle parentBundle;
    protected final String logIdentifier;
    protected final Map<Integer, Double> baseCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> forecastCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> actualCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> curtailedCapacities = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> shiftedCurtailments = new HashMap<Integer, Double>();
    protected RegulationCapacity currentRegCapacity = null;

    public DefaultCapacityOriginator(FactoredCustomerService service, CapacityStructure capacityStructure, CapacityBundle bundle) {
        this.timeService = service.getTimeService();
        this.timeslotRepo = service.getTimeslotRepo();
        this.weatherReportRepo = service.getWeatherReportRepo();
        this.weatherForecastRepo = service.getWeatherForecastRepo();
        this.capacityStructure = capacityStructure;
        this.parentBundle = bundle;
        String string = this.logIdentifier = this.capacityStructure.getName().isEmpty() ? bundle.getName() : bundle.getName() + "#" + this.capacityStructure.getName();
        if (capacityStructure.getBaseCapacityType() == CapacityStructure.BaseCapacityType.TIMESERIES) {
            Map<String, StructureInstance> map = Config.getInstance().getStructures().get("TimeseriesGenerator");
            this.tsGenerator = (TimeseriesGenerator)map.get(capacityStructure.getName() + "Population");
            if (this.tsGenerator != null) {
                this.tsGenerator.initialize(service);
            }
        } else {
            this.tsGenerator = null;
        }
    }

    @Override
    public CapacityProfile getCurrentForecast() {
        int timeslot = this.timeslotRepo.currentSerialNumber();
        return this.getForecastForTimeslot(timeslot);
    }

    @Override
    public CapacityProfile getForecastForNextTimeslot() {
        int timeslot = this.timeslotRepo.currentSerialNumber();
        return this.getForecastForTimeslot(timeslot + 1);
    }

    private CapacityProfile getForecastForTimeslot(int timeslot) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < 24; ++i) {
            Double forecastCapacity = this.forecastCapacities.get(timeslot);
            if (forecastCapacity != null) {
                values.add(forecastCapacity);
            } else {
                values.add(this.getForecastCapacity(timeslot));
            }
            ++timeslot;
        }
        return new CapacityProfile(values);
    }

    @Override
    public CapacityProfile getCurrentForecastPerSub(TariffSubscription sub) {
        return this.getCurrentForecast();
    }

    @Override
    public CapacityProfile getForecastPerSubStartingAt(int startingTimeslot, TariffSubscription subscription) {
        return this.getForecastForTimeslot(startingTimeslot);
    }

    protected double getForecastCapacity(int timeslot) {
        Double ret = this.forecastCapacities.get(timeslot);
        if (ret == null) {
            ret = this.computeForecastCapacity(timeslot);
        }
        return ret;
    }

    private double computeForecastCapacity(int future) {
        int now = this.timeslotRepo.currentSerialNumber();
        int timeToFuture = future - now;
        Weather weather = null;
        if (timeToFuture == 0) {
            weather = new Weather(this.weatherReportRepo.currentWeatherReport());
        } else {
            WeatherForecast forecast = this.weatherForecastRepo.currentWeatherForecast();
            List predictions = forecast.getPredictions();
            for (WeatherForecastPrediction prediction : predictions) {
                if (prediction.getForecastTime() != timeToFuture) continue;
                weather = new Weather(prediction);
            }
        }
        if (weather == null) {
            throw new Error("Could not find weather forecast for timeslot " + future);
        }
        double baseCapacity = this.getBaseCapacity(future);
        if (Double.isNaN(baseCapacity)) {
            throw new Error("Base capacity is NaN!");
        }
        double forecastCapacity = baseCapacity;
        forecastCapacity = this.adjustCapacityForPeriodicSkew(forecastCapacity, this.timeslotRepo.getDateTimeForIndex(future), false);
        if (Double.isNaN(forecastCapacity = this.adjustCapacityForWeather(forecastCapacity, weather, false))) {
            throw new Error("Adjusted capacity is NaN for base capacity = " + baseCapacity);
        }
        forecastCapacity = this.truncateTo2Decimals(forecastCapacity);
        this.forecastCapacities.put(future, forecastCapacity);
        log.debug(this.logIdentifier + ": Daniel Forecast capacity for timeslot " + future + " = " + forecastCapacity);
        return forecastCapacity;
    }

    private double getBaseCapacity(int future) {
        Double ret = this.baseCapacities.get(future);
        if (ret == null) {
            ret = this.drawBaseCapacitySample(future);
        }
        return ret;
    }

    private double drawBaseCapacitySample(int timeslot) {
        double baseCapacity = 0.0;
        switch (this.capacityStructure.getBaseCapacityType()) {
            case POPULATION: {
                baseCapacity = this.capacityStructure.getBasePopulationCapacity().drawSample();
                break;
            }
            case INDIVIDUAL: {
                baseCapacity += this.capacityStructure.getBaseIndividualCapacity().drawSample();
                break;
            }
            case TIMESERIES: {
                baseCapacity = this.getBaseCapacityFromTimeseries(timeslot);
                break;
            }
            default: {
                throw new Error(this.logIdentifier + ": Unexpected base capacity type: " + (Object)((Object)this.capacityStructure.getBaseCapacityType()));
            }
        }
        Double prevCapacity = this.baseCapacities.get(timeslot - 1);
        if (prevCapacity != null) {
            baseCapacity = 0.4 * prevCapacity + 0.6 * baseCapacity;
        }
        baseCapacity = this.truncateTo2Decimals(baseCapacity);
        this.baseCapacities.put(timeslot, baseCapacity);
        return baseCapacity;
    }

    private double getBaseCapacityFromTimeseries(int timeslot) {
        try {
            return this.tsGenerator.generateNext(timeslot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error(this.logIdentifier + ": Tried to get base capacity from time series at index beyond maximum!");
            throw e;
        }
    }

    @Override
    public double getShiftingInconvenienceFactor(Tariff tariff) {
        return 0.0;
    }

    @Override
    public CapacityAccumulator useCapacity(TariffSubscription subscription) {
        int timeslot = this.timeslotRepo.currentSerialNumber();
        double baseCapacity = this.getBaseCapacity(timeslot);
        if (Double.isNaN(baseCapacity)) {
            throw new Error("Base capacity is NaN!");
        }
        this.logCapacityDetails(this.logIdentifier + ": Base capacity for timeslot " + timeslot + " = " + baseCapacity);
        double adjustedCapacity = baseCapacity;
        adjustedCapacity = this.adjustCapacityForPeriodicSkew(adjustedCapacity, this.timeService.getCurrentDateTime(), true);
        adjustedCapacity = this.adjustCapacityForCurrentWeather(adjustedCapacity, true);
        if (!this.parentBundle.isAllIndividual()) {
            adjustedCapacity = this.adjustCapacityForSubscription(timeslot, adjustedCapacity, subscription);
        }
        CapacityAccumulator result = this.addRegCapacityMaybe(subscription, timeslot, adjustedCapacity);
        this.actualCapacities.put(timeslot, result.getCapacity());
        log.info(this.logIdentifier + ": Adjusted capacity for tariff " + subscription.getTariff().getId() + " = " + result.getCapacity());
        return result;
    }

    protected CapacityAccumulator addRegCapacityMaybe(TariffSubscription subscription, int timeslot, double adjustedCapacity) {
        double upReg = 0.0;
        double downReg = 0.0;
        if (this.parentBundle.getPowerType().isInterruptible()) {
            upReg = Math.max(0.0, adjustedCapacity - this.capacityStructure.getUpRegulationLimit());
            downReg = Math.min(0.0, adjustedCapacity - this.capacityStructure.getDownRegulationLimit());
            log.info("{} regulation = {}:{}", (Object)this.parentBundle.getName(), (Object)upReg, (Object)downReg);
            adjustedCapacity = this.adjustCapacityForCurtailments(timeslot, adjustedCapacity, subscription);
        }
        return new CapacityAccumulator(this.truncateTo2Decimals(adjustedCapacity), upReg, downReg);
    }

    private double adjustCapacityForCurtailments(int timeslot, double capacity, TariffSubscription subscription) {
        Double currentShift;
        double lastCurtailment = subscription.getCurtailment();
        if (Math.abs(lastCurtailment) > 0.01) {
            this.curtailedCapacities.put(timeslot - 1, lastCurtailment);
            List<String> shifts = this.capacityStructure.getCurtailmentShifts();
            for (int i = 0; i < shifts.size(); ++i) {
                Double previousShifts;
                double shiftingFactor = Double.parseDouble(shifts.get(i));
                double shiftedCapacity = lastCurtailment * shiftingFactor;
                this.shiftedCurtailments.put(timeslot + i, shiftedCapacity += (previousShifts = this.shiftedCurtailments.get(timeslot + i)) != null ? previousShifts : 0.0);
            }
        }
        return (currentShift = this.shiftedCurtailments.get(timeslot)) == null ? capacity : capacity + currentShift;
    }

    private double adjustCapacityForPeriodicSkew(double capacity, DateTime when, boolean verbose) {
        int day = when.getDayOfWeek();
        int hour = when.getHourOfDay();
        double periodicSkew = this.capacityStructure.getPeriodicSkew(day, hour);
        if (verbose) {
            this.logCapacityDetails(this.logIdentifier + ": periodic skew = " + periodicSkew);
        }
        return capacity * periodicSkew;
    }

    private double adjustCapacityForCurrentWeather(double capacity, boolean verbose) {
        WeatherReport weatherReport = this.weatherReportRepo.currentWeatherReport();
        return this.adjustCapacityForWeather(capacity, new Weather(weatherReport), verbose);
    }

    private double adjustCapacityForWeather(double capacity, Weather weather, boolean verbose) {
        if (verbose) {
            this.logCapacityDetails(this.logIdentifier + ": weather = (" + weather.getTemperature() + ", " + weather.getWindSpeed() + ", " + weather.getWindDirection() + ", " + weather.getCloudCover() + ")");
        }
        double weatherFactor = 1.0;
        if (this.capacityStructure.getTemperatureInfluence() == CapacityStructure.InfluenceKind.DIRECT) {
            int temperature = (int)Math.round(weather.getTemperature());
            weatherFactor *= this.capacityStructure.getTemperatureFactor(temperature);
        } else if (this.capacityStructure.getTemperatureInfluence() == CapacityStructure.InfluenceKind.DEVIATION) {
            int curr = (int)Math.round(weather.getTemperature());
            int ref = (int)Math.round(this.capacityStructure.getTemperatureReference());
            double deviationFactor = 1.0;
            if (curr > ref) {
                for (int t = ref + 1; t <= curr; ++t) {
                    deviationFactor += this.capacityStructure.getTemperatureFactor(t);
                }
            } else if (curr < ref) {
                for (int t = curr; t < ref; ++t) {
                    deviationFactor += this.capacityStructure.getTemperatureFactor(t);
                }
            }
            weatherFactor *= deviationFactor;
        }
        if (this.capacityStructure.getWindSpeedInfluence() == CapacityStructure.InfluenceKind.DIRECT) {
            int windSpeed = (int)Math.round(weather.getWindSpeed());
            weatherFactor *= this.capacityStructure.getWindspeedFactor(windSpeed);
            if ((double)windSpeed > 0.0 && this.capacityStructure.getWindDirectionInfluence() == CapacityStructure.InfluenceKind.DIRECT) {
                int windDirection = (int)Math.round(weather.getWindDirection());
                weatherFactor *= this.capacityStructure.getWindDirectionFactor(windDirection);
            }
        }
        if (this.capacityStructure.getCloudCoverInfluence() == CapacityStructure.InfluenceKind.DIRECT) {
            int cloudCover = (int)Math.round(100.0 * weather.getCloudCover());
            weatherFactor *= this.capacityStructure.getCloudCoverFactor(cloudCover);
        }
        if (verbose) {
            this.logCapacityDetails(this.logIdentifier + ": weather factor = " + weatherFactor);
        }
        return capacity * weatherFactor;
    }

    @Override
    public double adjustCapacityForSubscription(int timeslot, double totalCapacity, TariffSubscription subscription) {
        double subCapacity = this.adjustCapacityForPopulationRatio(totalCapacity, subscription);
        return this.adjustCapacityForTariffRates(timeslot, subCapacity, subscription);
    }

    private double adjustCapacityForPopulationRatio(double capacity, TariffSubscription subscription) {
        double popRatio = this.getPopulationRatio(subscription.getCustomersCommitted(), this.parentBundle.getPopulation());
        this.logCapacityDetails(this.logIdentifier + ": population ratio = " + popRatio);
        return capacity * popRatio;
    }

    private double getPopulationRatio(int customerCount, int population) {
        return (double)customerCount / (double)population;
    }

    private double adjustCapacityForTariffRates(int timeslot, double baseCapacity, TariffSubscription subscription) {
        if (baseCapacity - 0.0 < 0.01) {
            return baseCapacity;
        }
        double chargeForBase = subscription.getTariff().getUsageCharge(this.timeslotRepo.getTimeForIndex(timeslot), baseCapacity, subscription.getTotalUsage());
        double rateForBase = chargeForBase / baseCapacity;
        double benchmarkRate = this.capacityStructure.getBenchmarkRate(this.timeService.getHourOfDay());
        double rateRatio = rateForBase / benchmarkRate;
        double tariffRatesFactor = this.determineTariffRatesFactor(rateRatio);
        this.logCapacityDetails(this.logIdentifier + ": tariff rates factor = " + tariffRatesFactor);
        return baseCapacity * tariffRatesFactor;
    }

    private double determineTariffRatesFactor(double rateRatio) {
        switch (this.capacityStructure.getElasticityModelType()) {
            case CONTINUOUS: {
                return this.capacityStructure.determineContinuousElasticityFactor(rateRatio);
            }
            case STEPWISE: {
                return this.determineStepwiseElasticityFactor(rateRatio);
            }
        }
        throw new Error("Unexpected elasticity model type: " + (Object)((Object)this.capacityStructure.getElasticityModelType()));
    }

    private double determineStepwiseElasticityFactor(double rateRatio) {
        double[][] elasticity = this.capacityStructure.getElasticity();
        if (Math.abs(rateRatio - 1.0) < 0.01 || elasticity.length == 0) {
            return 1.0;
        }
        PowerType powerType = this.parentBundle.getPowerType();
        if (powerType.isConsumption() && rateRatio < 1.0) {
            return 1.0;
        }
        if (powerType.isProduction() && rateRatio > 1.0) {
            return 1.0;
        }
        boolean RATE_RATIO_INDEX = false;
        boolean CAPACITY_FACTOR_INDEX = true;
        double rateLowerBound = Double.NEGATIVE_INFINITY;
        double rateUpperBound = Double.POSITIVE_INFINITY;
        double lowerBoundCapacityFactor = 1.0;
        double upperBoundCapacityFactor = 1.0;
        for (double[] anElasticity : elasticity) {
            double r = anElasticity[0];
            if (r <= rateRatio && r > rateLowerBound) {
                rateLowerBound = r;
                lowerBoundCapacityFactor = anElasticity[1];
            }
            if (!(r >= rateRatio) || !(r < rateUpperBound)) continue;
            rateUpperBound = r;
            upperBoundCapacityFactor = anElasticity[1];
        }
        return rateRatio < 1.0 ? upperBoundCapacityFactor : lowerBoundCapacityFactor;
    }

    @Override
    public String getCapacityName() {
        return this.capacityStructure.getName();
    }

    @Override
    public CapacityBundle getParentBundle() {
        return this.parentBundle;
    }

    protected double truncateTo2Decimals(double x) {
        double fract;
        double whole;
        if (x > 0.0) {
            whole = Math.floor(x);
            fract = Math.floor((x - whole) * 100.0) / 100.0;
        } else {
            whole = Math.ceil(x);
            fract = Math.ceil((x - whole) * 100.0) / 100.0;
        }
        return whole + fract;
    }

    private void logCapacityDetails(String msg) {
        if (Config.getInstance().isCapacityDetailsLogging()) {
            log.info(msg);
        }
    }

    @Override
    public boolean isIndividual() {
        return this.capacityStructure.isIndividual();
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.logIdentifier;
    }

    private class Weather {
        final double temperature;
        final double windSpeed;
        final double windDirection;
        final double cloudCover;

        Weather(WeatherReport report) {
            this.temperature = report.getTemperature();
            this.windSpeed = report.getWindSpeed();
            this.windDirection = report.getWindDirection();
            this.cloudCover = report.getCloudCover();
        }

        Weather(WeatherForecastPrediction prediction) {
            this.temperature = prediction.getTemperature();
            this.windSpeed = prediction.getWindSpeed();
            this.windDirection = prediction.getWindDirection();
            this.cloudCover = prediction.getCloudCover();
        }

        double getTemperature() {
            return this.temperature;
        }

        double getWindSpeed() {
            return this.windSpeed;
        }

        double getWindDirection() {
            return this.windDirection;
        }

        double getCloudCover() {
            return this.cloudCover;
        }
    }
}

