/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.Tariff;
import org.powertac.common.TimeService;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherForecastRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultFactoredCustomer;
import org.powertac.factoredcustomer.interfaces.FactoredCustomer;
import org.powertac.factoredcustomer.interfaces.StructureInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FactoredCustomerService
extends TimeslotPhaseProcessor
implements InitializationService,
NewTariffListener {
    private static Logger log = LogManager.getLogger((String)FactoredCustomerService.class.getName());
    @Autowired
    private TimeService timeService;
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private WeatherForecastRepo weatherForecastRepo;
    @Autowired
    private ServerConfiguration serverConfiguration;
    private List<FactoredCustomer> customers;
    private CustomerFactory customerFactory;
    private boolean newTariffs = false;

    public String initialize(Competition competition, List<String> completedInits) {
        if (!completedInits.contains("DefaultBroker") || !completedInits.contains("TariffMarket")) {
            log.debug("Waiting for DefaultBroker and TariffMarket to initialize");
            return null;
        }
        super.init();
        this.customers = new ArrayList<FactoredCustomer>();
        this.customerFactory = new CustomerFactory();
        this.newTariffs = false;
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.registerAvailableCustomerCreators();
        Config.initializeInstance(this.serverConfiguration);
        Config config = Config.getInstance();
        config.configure();
        Map<String, StructureInstance> customerStructures = config.getStructures().get("CustomerStructure");
        log.info("Creating factored customers from configuration structures...");
        for (StructureInstance instance : customerStructures.values()) {
            CustomerStructure customerStructure = (CustomerStructure)instance;
            FactoredCustomer customer = this.customerFactory.processStructure(customerStructure);
            if (customer != null) {
                customer.initialize(this);
                this.customers.add(customer);
                continue;
            }
            throw new Error("Could not create factored customer for structure: " + customerStructure.getName());
        }
        log.info("Successfully initialized " + this.customers.size() + " factored customers from " + customerStructures.size() + " structures");
        return "FactoredCustomer";
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    CustomerRepo getCustomerRepo() {
        return this.customerRepo;
    }

    TariffRepo getTariffRepo() {
        return this.tariffRepo;
    }

    TimeslotRepo getTimeslotRepo() {
        return this.timeslotRepo;
    }

    RandomSeedRepo getRandomSeedRepo() {
        return this.randomSeedRepo;
    }

    TariffSubscriptionRepo getTariffSubscriptionRepo() {
        return this.tariffSubscriptionRepo;
    }

    TariffMarket getTariffMarket() {
        return this.tariffMarketService;
    }

    WeatherReportRepo getWeatherReportRepo() {
        return this.weatherReportRepo;
    }

    WeatherForecastRepo getWeatherForecastRepo() {
        return this.weatherForecastRepo;
    }

    private void registerAvailableCustomerCreators() {
        this.customerFactory.registerDefaultCreator(DefaultFactoredCustomer.getCreator());
        log.info("Registered default factored customer creator");
        ArrayList<String> creatorNames = new ArrayList<String>();
        creatorNames.add("org.powertac.factoredcustomer.LearningCustomerCreator");
        for (String name : creatorNames) {
            try {
                CustomerFactory.CustomerCreator creator = (CustomerFactory.CustomerCreator)Class.forName(name).newInstance();
                this.customerFactory.registerCreator(creator);
                log.info("Registered creator: " + name);
            }
            catch (ClassNotFoundException creator) {
            }
            catch (Exception e) {
                throw new Error("Could not register creator for name: " + name + "; caught exception: " + e);
            }
        }
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        for (FactoredCustomer customer : this.customers) {
            customer.evaluateTariffs();
        }
        this.newTariffs = true;
    }

    private void updatedSubscriptionRepo() {
        log.info("Time to handle new subscriptions");
        for (FactoredCustomer customer : this.customers) {
            customer.updatedSubscriptionRepo();
        }
    }

    public void activate(Instant now, int phase) {
        if (this.newTariffs) {
            this.newTariffs = false;
            this.updatedSubscriptionRepo();
        }
        for (FactoredCustomer customer : this.customers) {
            customer.handleNewTimeslot();
        }
    }

    List<FactoredCustomer> getCustomers() {
        return this.customers;
    }
}

