/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import org.powertac.common.config.ConfigurableValue;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.interfaces.StructureInstance;

public final class ProfileOptimizerStructure
implements StructureInstance {
    private String name;
    @ConfigurableValue(valueType="Boolean", dump=false)
    private boolean receiveRecommendations = false;
    @ConfigurableValue(valueType="String", dump=false)
    private String permutationRule = null;
    @ConfigurableValue(valueType="String", dump=false)
    private String profileSelectionMethod = ProfileSelectionMethod.BEST_UTILITY.toString();
    @ConfigurableValue(valueType="Double", dump=false)
    private double reactivityFactor = 1.0;
    @ConfigurableValue(valueType="Double", dump=false)
    private double receptivityFactor = 1.0;
    @ConfigurableValue(valueType="Double", dump=false)
    private double rationalityFactor = 1.0;
    @ConfigurableValue(valueType="String", dump=false)
    private String usageChargeStance = UsageChargeStance.BENEFIT.toString();
    @ConfigurableValue(valueType="Double", dump=false)
    private double usageChargePercentBenefit = 0.01;
    @ConfigurableValue(valueType="Double", dump=false)
    private double usageChargeThreshold = Double.NaN;
    @ConfigurableValue(valueType="Double", dump=false)
    private double profileChangeWeight = -1.0;
    @ConfigurableValue(valueType="Double", dump=false)
    private double bundleValueWeight = 10.0;

    public ProfileOptimizerStructure(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isReceiveRecommendations() {
        return this.receiveRecommendations;
    }

    public CapacityProfile.PermutationRule getPermutationRule() {
        return CapacityProfile.PermutationRule.valueOf(this.permutationRule);
    }

    public ProfileSelectionMethod getProfileSelectionMethod() {
        return ProfileSelectionMethod.valueOf(this.profileSelectionMethod);
    }

    public double getReactivityFactor() {
        return this.reactivityFactor;
    }

    public double getReceptivityFactor() {
        return this.receptivityFactor;
    }

    public double getRationalityFactor() {
        return this.rationalityFactor;
    }

    public UsageChargeStance getUsageChargeStance() {
        return UsageChargeStance.valueOf(this.usageChargeStance);
    }

    public double getUsageChargePercentBenefit() {
        return this.usageChargePercentBenefit;
    }

    public double getUsageChargeThreshold() {
        return this.usageChargeThreshold;
    }

    public double getProfileChangeWeight() {
        return this.profileChangeWeight;
    }

    public double getBundleValueWeight() {
        return this.bundleValueWeight;
    }

    public static enum ProfileSelectionMethod {
        BEST_UTILITY,
        LOGIT_CHOICE;

    }

    public static enum UsageChargeStance {
        NEUTRAL,
        BENEFIT,
        THRESHOLD;

    }
}

