/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.factoredcustomer.AdaptiveCapacityOriginator;
import org.powertac.factoredcustomer.CapacityStructure;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultCapacityOriginator;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ProfileOptimizerStructure;
import org.powertac.factoredcustomer.TariffSubscriberStructure;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.powertac.factoredcustomer.interfaces.StructureInstance;

public class DefaultCapacityBundle
implements CapacityBundle,
StructureInstance {
    private static Logger log = LogManager.getLogger((String)DefaultCapacityBundle.class.getName());
    protected FactoredCustomerService service;
    private CustomerStructure customerStructure;
    protected String name;
    @ConfigurableValue(description="Number of capacity structures expected", valueType="Integer", dump=false)
    protected int count;
    @ConfigurableValue(valueType="Integer")
    protected int population;
    @ConfigurableValue(description="PowerType for this bundle", valueType="String", dump=false)
    protected String type;
    @ConfigurableValue(valueType="String", dump=false)
    protected String customerSize = "SMALL";
    @ConfigurableValue(description="If true, then this bundle can divide itself among multiple tariffs", valueType="Boolean", dump=false)
    protected boolean multiContracting = false;
    @ConfigurableValue(description="Unsupported, value ignored", valueType="Boolean", dump=false)
    protected boolean canNegotiate = false;
    @ConfigurableValue(description="Maximum curtailment per timeslot", valueType="Double", dump=false)
    protected double controllableKW = 0.0;
    @ConfigurableValue(description="Maximum storage discharge per timeslot", valueType="Double", dump=false)
    protected double upRegulationKW = 0.0;
    @ConfigurableValue(description="Maximum down-regulation (energy absorbed) per timeslot", valueType="Double", dump=false)
    protected double downRegulationKW = 0.0;
    @ConfigurableValue(description="", valueType="Double", dump=false)
    protected double storageCapacity = 0.0;
    @ConfigurableValue(valueType="Boolean", dump=false)
    protected boolean isAdaptive = false;
    private CustomerInfo customerInfo;
    private TariffSubscriberStructure subscriberStructure;
    private ProfileOptimizerStructure optimizerStructure;
    protected List<CapacityOriginator> capacityOriginators = new ArrayList<CapacityOriginator>();
    private boolean allIndividual;

    public DefaultCapacityBundle(String name) {
        this.name = name;
    }

    @Override
    public void initialize(FactoredCustomerService service, CustomerStructure customerStructure) {
        this.service = service;
        this.customerStructure = customerStructure;
        this.allIndividual = true;
        PowerType pt = PowerType.valueOf((String)this.type);
        if (null == pt) {
            throw new Error("Invalid PowerType for " + this.name);
        }
        CustomerInfo.CustomerClass cc = CustomerInfo.CustomerClass.valueOf((String)this.customerSize);
        if (null == cc) {
            throw new Error("Invalid CustomerClass for " + this.name);
        }
        this.customerInfo = new CustomerInfo(this.name, this.population).withPowerType(pt).withCustomerClass(cc).withMultiContracting(this.multiContracting).withCanNegotiate(this.canNegotiate).withControllableKW(this.controllableKW).withUpRegulationKW(this.upRegulationKW).withDownRegulationKW(this.downRegulationKW).withStorageCapacity(this.storageCapacity);
        Config config = Config.getInstance();
        Map<String, StructureInstance> subscribers = config.getStructures().get("TariffSubscriberStructure");
        Map<String, StructureInstance> optimizers = config.getStructures().get("ProfileOptimizerStructure");
        Map<String, StructureInstance> capacities = config.getStructures().get("CapacityStructure");
        this.subscriberStructure = (TariffSubscriberStructure)subscribers.get(this.name);
        if (this.subscriberStructure == null) {
            throw new Error("No TariffSubscriberStructure for : " + this.name);
        }
        this.subscriberStructure.initialize(service);
        this.optimizerStructure = (ProfileOptimizerStructure)optimizers.get(this.name);
        if (this.optimizerStructure == null) {
            this.optimizerStructure = new ProfileOptimizerStructure(this.name);
        }
        Object capName = this.name;
        for (int j = 0; j < this.count; ++j) {
            CapacityStructure capacityStructure;
            if (this.count > 1) {
                capName = this.name + (j + 1);
            }
            if ((capacityStructure = (CapacityStructure)capacities.get(capName)) == null) {
                throw new Error("No CapacityStructure for " + (String)capName + (j + 1));
            }
            capacityStructure.initialize(service);
            this.capacityOriginators.add(this.createCapacityOriginator(capacityStructure));
            if (capacityStructure.isIndividual()) continue;
            this.allIndividual = false;
        }
        if (this.allIndividual && this.population > this.count) {
            CapacityStructure capacityStructure;
            if (this.count > 1) {
                log.error("Fault config, count {} > 1 and population {} > count", (Object)this.count, (Object)this.population);
            }
            if (this.population % this.count != 0) {
                log.error("Population {} not integer multiple of count {}", (Object)this.population, (Object)this.count);
            }
            if ((capacityStructure = (CapacityStructure)capacities.get(capName)) == null) {
                throw new Error("No CapacityStructure for " + (String)capName);
            }
            for (int i = 1; i < this.population; ++i) {
                this.capacityOriginators.add(this.createCapacityOriginator(capacityStructure));
            }
        }
    }

    protected CapacityOriginator createCapacityOriginator(CapacityStructure capacityStructure) {
        if (this.isAdaptive) {
            return new AdaptiveCapacityOriginator(this.service, capacityStructure, this);
        }
        return new DefaultCapacityOriginator(this.service, capacityStructure, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getPopulation() {
        return this.customerInfo.getPopulation();
    }

    @Override
    public PowerType getPowerType() {
        return this.customerInfo.getPowerType();
    }

    @Override
    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    @Override
    public TariffSubscriberStructure getSubscriberStructure() {
        return this.subscriberStructure;
    }

    @Override
    public ProfileOptimizerStructure getOptimizerStructure() {
        return this.optimizerStructure;
    }

    @Override
    public List<CapacityOriginator> getCapacityOriginators() {
        return this.capacityOriginators;
    }

    @Override
    public boolean isAllIndividual() {
        return this.allIndividual;
    }
}

