/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.factoredcustomer.Config;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultUtilityOptimizer;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.FactoredCustomer;
import org.powertac.factoredcustomer.interfaces.StructureInstance;
import org.powertac.factoredcustomer.interfaces.UtilityOptimizer;

class DefaultFactoredCustomer
implements FactoredCustomer {
    private static Logger log = LogManager.getLogger(DefaultFactoredCustomer.class);
    private CustomerStructure customerStructure;
    private UtilityOptimizer utilityOptimizer;
    private final List<CapacityBundle> capacityBundles = new ArrayList<CapacityBundle>();
    protected FactoredCustomerService service;
    private static Creator creator = new Creator();

    public DefaultFactoredCustomer(CustomerStructure customerStructure) {
        this.customerStructure = customerStructure;
    }

    @Override
    public void initialize(FactoredCustomerService service) {
        this.service = service;
        Config config = Config.getInstance();
        Map<String, StructureInstance> bundles = config.getStructures().get("DefaultCapacityBundle");
        log.info("Initializing customer " + this.customerStructure.getName());
        for (int i = 0; i < this.customerStructure.getBundleCount(); ++i) {
            Object name = this.customerStructure.getName();
            if (this.customerStructure.getBundleCount() > 1) {
                name = (String)name + "-" + (i + 1);
            }
            this.createCapacityBundle(bundles, this.customerStructure, (String)name);
        }
        this.utilityOptimizer = this.createUtilityOptimizer(this.customerStructure, this.capacityBundles);
        this.utilityOptimizer.initialize(service);
        log.info("Successfully initialized customer " + this.customerStructure.getName());
    }

    private void createCapacityBundle(Map<String, StructureInstance> bundles, CustomerStructure customerStructure, String name) {
        CapacityBundle capacityBundle = (CapacityBundle)((Object)bundles.get(name));
        if (capacityBundle == null) {
            throw new Error("No CapacityBundle for " + name);
        }
        capacityBundle.initialize(this.service, customerStructure);
        this.capacityBundles.add(capacityBundle);
        this.getCustomerRepo().add(capacityBundle.getCustomerInfo());
    }

    private CustomerRepo getCustomerRepo() {
        return this.service.getCustomerRepo();
    }

    private TimeslotRepo getTimeslotRepo() {
        return this.service.getTimeslotRepo();
    }

    protected UtilityOptimizer createUtilityOptimizer(CustomerStructure customerStructure, List<CapacityBundle> capacityBundles) {
        return new DefaultUtilityOptimizer(customerStructure, capacityBundles);
    }

    @Override
    public void evaluateTariffs() {
        Timeslot timeslot = this.getTimeslotRepo().currentTimeslot();
        log.info("Customer " + this.getName() + " evaluating tariffs at timeslot " + timeslot.getSerialNumber());
        this.utilityOptimizer.evaluateTariffs();
    }

    @Override
    public void updatedSubscriptionRepo() {
        this.utilityOptimizer.updatedSubscriptionRepo();
    }

    @Override
    public void handleNewTimeslot() {
        Timeslot timeslot = this.getTimeslotRepo().currentTimeslot();
        log.info("Customer " + this.getName() + " activated for timeslot " + timeslot.getSerialNumber());
        this.utilityOptimizer.step();
    }

    String getName() {
        return this.customerStructure.getName();
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.getName();
    }

    public static CustomerFactory.CustomerCreator getCreator() {
        return creator;
    }

    CustomerStructure getCustomerStructure() {
        return this.customerStructure;
    }

    List<CapacityBundle> getCapacityBundles() {
        return this.capacityBundles;
    }

    UtilityOptimizer getUtilityOptimizer() {
        return this.utilityOptimizer;
    }

    public static class Creator
    implements CustomerFactory.CustomerCreator {
        @Override
        public String getKey() {
            return null;
        }

        @Override
        public FactoredCustomer createModel(CustomerStructure customerStructure) {
            return new DefaultFactoredCustomer(customerStructure);
        }
    }
}

