/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.Random;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.CauchyDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.interfaces.StructureInstance;
import org.powertac.factoredcustomer.utils.SeedIdGenerator;

public class ProbabilityDistribution
implements StructureInstance {
    private String name;
    @ConfigurableValue(valueType="String", dump=false)
    private String distribution;
    @ConfigurableValue(valueType="Double", dump=false)
    private double value;
    @ConfigurableValue(valueType="Double", dump=false)
    private double low;
    @ConfigurableValue(valueType="Double", dump=false)
    private double high;
    @ConfigurableValue(valueType="Double", dump=false)
    private double mean;
    @ConfigurableValue(valueType="Double", dump=false)
    private double stdDev;
    @ConfigurableValue(valueType="Double", dump=false)
    private double expMean;
    @ConfigurableValue(valueType="Double", dump=false)
    private double expStdDev;
    @ConfigurableValue(valueType="Double", dump=false)
    private double median;
    @ConfigurableValue(valueType="Double", dump=false)
    private double scale;
    @ConfigurableValue(valueType="Double", dump=false)
    private double alpha;
    @ConfigurableValue(valueType="Double", dump=false)
    private double beta;
    @ConfigurableValue(valueType="Double", dump=false)
    private double trials;
    @ConfigurableValue(valueType="Double", dump=false)
    private double success;
    @ConfigurableValue(valueType="Double", dump=false)
    private double lambda;
    @ConfigurableValue(valueType="Double", dump=false)
    private double dof;
    @ConfigurableValue(valueType="Double", dump=false)
    private double d1;
    @ConfigurableValue(valueType="Double", dump=false)
    private double d2;
    private Sampler sampler;
    private double param1;
    private double param2;
    private double param3;
    private double param4;

    public ProbabilityDistribution(String name) {
        this.name = name;
    }

    public void initialize(FactoredCustomerService service) {
        switch (DistributionType.valueOf(this.distribution)) {
            case POINTMASS: 
            case DEGENERATE: {
                this.param1 = this.value;
                this.sampler = new DegenerateSampler(this.value);
                break;
            }
            case UNIFORM: {
                this.param1 = this.low;
                this.param2 = this.high;
                this.sampler = new UniformSampler(this.low, this.high);
                break;
            }
            case INTERVAL: {
                this.param1 = this.mean;
                this.param2 = this.stdDev;
                this.param3 = this.low;
                this.param4 = this.high;
                this.sampler = new IntervalSampler(this.mean, this.stdDev, this.low, this.high);
                break;
            }
            case NORMAL: 
            case GAUSSIAN: {
                this.param1 = this.mean;
                this.param2 = this.stdDev;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new NormalDistribution(this.mean, this.stdDev));
                break;
            }
            case STDNORMAL: {
                this.param1 = 0.0;
                this.param2 = 1.0;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new NormalDistribution(0.0, 1.0));
                break;
            }
            case LOGNORMAL: {
                this.param1 = this.expMean;
                this.param2 = this.expStdDev;
                this.sampler = new LogNormalSampler(this.expMean, this.expStdDev);
                break;
            }
            case CAUCHY: {
                this.param1 = this.median;
                this.param2 = this.scale;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new CauchyDistribution(this.median, this.scale));
                break;
            }
            case BETA: {
                this.param1 = this.alpha;
                this.param2 = this.beta;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new BetaDistribution(this.alpha, this.beta));
                break;
            }
            case BINOMIAL: {
                this.param1 = this.trials;
                this.param2 = this.success;
                this.sampler = new DiscreteSampler((AbstractIntegerDistribution)new BinomialDistribution((int)this.trials, this.success));
                break;
            }
            case POISSON: {
                this.param1 = this.lambda;
                this.sampler = new DiscreteSampler((AbstractIntegerDistribution)new PoissonDistribution(this.lambda));
                break;
            }
            case CHISQUARED: {
                this.param1 = this.dof;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new ChiSquaredDistribution(this.dof));
                break;
            }
            case EXPONENTIAL: {
                this.param1 = this.mean;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new ExponentialDistribution(this.mean));
                break;
            }
            case GAMMA: {
                this.param1 = this.alpha;
                this.param2 = this.beta;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new GammaDistribution(this.alpha, this.beta));
                break;
            }
            case WEIBULL: {
                this.param1 = this.alpha;
                this.param2 = this.beta;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new WeibullDistribution(this.alpha, this.beta));
                break;
            }
            case STUDENT: {
                this.param1 = this.dof;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new TDistribution(this.dof));
                break;
            }
            case SNEDECOR: {
                this.param1 = this.d1;
                this.param2 = this.d2;
                this.sampler = new ContinuousSampler((AbstractRealDistribution)new FDistribution(this.d1, this.d2));
                break;
            }
            default: {
                throw new Error("Invalid probability distribution type!");
            }
        }
        this.sampler.reseedRandomGenerator(service.getRandomSeedRepo().getRandomSeed("factoredcustomer.ProbabilityDistribution", (long)SeedIdGenerator.getId(), "Sampler").getValue());
    }

    public double drawSample() {
        return this.sampler.sample();
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.distribution + ":(" + this.param1 + ", " + this.param2 + ", " + this.param3 + ", " + this.param4 + ")";
    }

    @Override
    public String getName() {
        return this.name;
    }

    private final class ContinuousSampler
    implements Sampler {
        final AbstractRealDistribution impl;

        ContinuousSampler(AbstractRealDistribution i) {
            this.impl = i;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.impl.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() {
            return this.impl.sample();
        }
    }

    private final class DiscreteSampler
    implements Sampler {
        final AbstractIntegerDistribution impl;

        DiscreteSampler(AbstractIntegerDistribution i) {
            this.impl = i;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.impl.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() {
            return this.impl.sample();
        }
    }

    private final class LogNormalSampler
    implements Sampler {
        final NormalDistribution normalSampler;

        LogNormalSampler(double m, double s) {
            this.normalSampler = new NormalDistribution(Math.log(m), Math.log(s));
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.normalSampler.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() {
            return Math.exp(this.normalSampler.sample());
        }
    }

    private final class IntervalSampler
    implements Sampler {
        final double low;
        final double high;
        final NormalDistribution normalSampler;

        IntervalSampler(double m, double s, double l, double h) {
            this.normalSampler = new NormalDistribution(m, s);
            this.low = l;
            this.high = h;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.normalSampler.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() {
            return Math.min(this.high, Math.max(this.low, this.normalSampler.sample()));
        }
    }

    private final class UniformSampler
    implements Sampler {
        final Random random;
        final double low;
        final int range;

        UniformSampler(double l, double h) {
            this.low = l;
            this.range = this.safeLongToInt(Math.round(h - this.low));
            this.random = new Random();
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.random.setSeed(seed);
        }

        @Override
        public double sample() {
            return this.low + (double)this.random.nextInt(this.range);
        }

        protected int safeLongToInt(long x) {
            if (x < Integer.MIN_VALUE || x > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(x + " cannot be cast to int without changing its value.");
            }
            return (int)x;
        }
    }

    private final class DegenerateSampler
    implements Sampler {
        final double value;

        DegenerateSampler(double v) {
            this.value = v;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
        }

        @Override
        public double sample() {
            return this.value;
        }
    }

    private static interface Sampler {
        public void reseedRandomGenerator(long var1);

        public double sample();
    }

    private static enum DistributionType {
        DEGENERATE,
        POINTMASS,
        UNIFORM,
        INTERVAL,
        NORMAL,
        GAUSSIAN,
        STDNORMAL,
        LOGNORMAL,
        CAUCHY,
        BETA,
        BINOMIAL,
        POISSON,
        CHISQUARED,
        EXPONENTIAL,
        GAMMA,
        WEIBULL,
        STUDENT,
        SNEDECOR;

    }
}

