/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.householdcustomer.configurations.VillageConstants;
import org.powertac.householdcustomer.customers.Village;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HouseholdCustomerService
extends TimeslotPhaseProcessor
implements NewTariffListener,
InitializationService {
    private static Logger log = Logger.getLogger((String)HouseholdCustomerService.class.getName());
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private ServerConfiguration serverPropertiesService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    private RandomSeed rs1;
    private String configFile1 = null;
    private int daysOfCompetition = 0;
    Properties configuration = new Properties();
    ArrayList<Village> villageList = new ArrayList();
    int seedId = 1;

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("DefaultBroker");
        if (index == -1) {
            return null;
        }
        this.serverPropertiesService.configureMe((Object)this);
        this.villageList.clear();
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.rs1 = this.randomSeedRepo.getRandomSeed("HouseholdCustomerService", (long)this.seedId++, "Household Customer Models");
        if (this.configFile1 == null) {
            log.info((Object)"No Config File for VillageType1 Taken");
            this.configFile1 = "VillageDefault.properties";
        }
        super.init();
        this.daysOfCompetition = Competition.currentCompetition().getExpectedTimeslotCount() / 24;
        VillageConstants.setDaysOfCompetition(this.daysOfCompetition);
        VillageConstants.setDaysOfWeek();
        this.daysOfCompetition = VillageConstants.DAYS_OF_COMPETITION;
        if (this.daysOfCompetition == 0) {
            log.info((Object)"No Days Of Competition Taken");
            this.daysOfCompetition = 63;
        }
        this.addVillages(this.configFile1, "1");
        return "HouseholdCustomer";
    }

    private void addVillages(String configFile, String type) {
        InputStream cfgFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFile);
        try {
            this.configuration.load(cfgFile);
            cfgFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String[] types = new String[]{"NS", "RaS", "ReS", "SS"};
        String[] shifts = new String[]{"Base", "Controllable"};
        TreeMap<String, Integer> houses = new TreeMap<String, Integer>();
        int numberOfVillages = Integer.parseInt(this.configuration.getProperty("NumberOfVillages"));
        int nshouses = Integer.parseInt(this.configuration.getProperty("NotShiftingCustomers"));
        houses.put("NS", nshouses);
        int rashouses = Integer.parseInt(this.configuration.getProperty("RandomlyShiftingCustomers"));
        houses.put("RaS", rashouses);
        int reshouses = Integer.parseInt(this.configuration.getProperty("RegularlyShiftingCustomers"));
        houses.put("ReS", reshouses);
        int sshouses = Integer.parseInt(this.configuration.getProperty("SmartShiftingCustomers"));
        houses.put("SS", sshouses);
        Comparator<CustomerInfo> comp = new Comparator<CustomerInfo>(){

            @Override
            public int compare(CustomerInfo customer1, CustomerInfo customer2) {
                return customer1.getName().compareToIgnoreCase(customer2.getName());
            }
        };
        for (int i = 1; i < numberOfVillages + 1; ++i) {
            Village village = new Village("Village " + i);
            TreeMap<CustomerInfo, String> map = new TreeMap<CustomerInfo, String>(comp);
            for (String houseType : types) {
                for (String shifting : shifts) {
                    CustomerInfo villageInfo = new CustomerInfo("Village " + i + " " + houseType + " " + shifting, ((Integer)houses.get(houseType)).intValue());
                    if (shifting.equalsIgnoreCase("Base")) {
                        villageInfo.withPowerType(PowerType.CONSUMPTION);
                    } else {
                        villageInfo.withPowerType(PowerType.INTERRUPTIBLE_CONSUMPTION);
                    }
                    map.put(villageInfo, houseType + " " + shifting);
                    village.addCustomerInfo(villageInfo);
                }
            }
            village.initialize(this.configuration, this.seedId++, map);
            this.villageList.add(village);
            village.subscribeDefault();
        }
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        for (Village village : this.villageList) {
            village.evaluateNewTariffs();
        }
    }

    public int getDaysOfCompetition() {
        return this.daysOfCompetition;
    }

    @ConfigurableValue(valueType="Integer", description="The competition duration in days")
    public void setDaysOfCompetition(int days) {
        this.daysOfCompetition = days;
    }

    public String getConfigFile1() {
        return this.configFile1;
    }

    @ConfigurableValue(valueType="String", description="first configuration file of the household customers")
    public void setConfigFile1(String config) {
        this.configFile1 = config;
    }

    public List<Village> getVillageList() {
        return this.villageList;
    }

    public void clearConfiguration() {
        this.configFile1 = null;
    }

    public List<CustomerInfo> generateCustomerInfoList() {
        ArrayList<CustomerInfo> result = new ArrayList<CustomerInfo>();
        for (Village village : this.villageList) {
            for (CustomerInfo customer : village.getCustomerInfo()) {
                result.add(customer);
            }
        }
        return result;
    }

    public void activate(Instant time, int phaseNumber) {
        log.info((Object)"Activate");
        if (this.villageList.size() > 0) {
            for (Village village : this.villageList) {
                village.step();
            }
        }
    }

    public void setDefaults() {
    }
}

