/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.NotShiftingAppliance;

public class CirculationPump
extends NotShiftingAppliance {
    double operationPercentage;

    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " CirculationPump";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = Double.parseDouble(conf.getProperty("CirculationPumpSaturation"));
        this.operationPercentage = Double.parseDouble(conf.getProperty("CirculationPumpPercentage"));
        this.power = (int)(15.0 * this.gen.nextGaussian() + 90.0);
        this.cycleDuration = 1;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            double tempPercentage;
            this.dailyOperation.add(false);
            this.loadVector.add(0);
            if (this.applianceOf.isEmpty(weekday, i) || !((tempPercentage = this.operationPercentage + 0.05 * (double)this.applianceOf.tenantsNumber(weekday, i)) > this.gen.nextDouble())) continue;
            this.dailyOperation.set(i, true);
            this.loadVector.set(i, this.power);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

