/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.Appliance;
import org.powertac.householdcustomer.appliances.SemiShiftingAppliance;
import org.powertac.householdcustomer.appliances.WashingMachine;
import org.powertac.householdcustomer.configurations.VillageConstants;

public class Dryer
extends SemiShiftingAppliance {
    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " Dryer";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = Double.parseDouble(conf.getProperty("DryerSaturation"));
        this.power = (int)(235.0 * this.gen.nextGaussian() + 1410.0);
        this.cycleDuration = 7;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        for (Appliance appliance : this.applianceOf.getAppliances()) {
            if (!(appliance instanceof WashingMachine)) continue;
            WashingMachine wm = (WashingMachine)appliance;
            this.times = wm.getTimes();
            this.days = wm.getDays();
            wm.dryerFlag = true;
            wm.dryerPower = this.power;
            break;
        }
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int l = 0; l < 96; ++l) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        int start = this.washingEnds(weekday);
        if (start > 0) {
            for (int i = start; i < 95; ++i) {
                if (this.applianceOf.isEmpty(weekday, i)) continue;
                for (int j = i; j < i + 3; ++j) {
                    this.loadVector.set(j, this.power);
                    this.dailyOperation.set(j, true);
                    if (j == 95) break;
                }
                for (int k = i + 3; k < i + 6 && k < 96; ++k) {
                    this.loadVector.set(k, (Integer)this.loadVector.get(k - 1) - 250);
                    this.dailyOperation.set(k, true);
                }
                i = 96;
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (!this.applianceOf.isEmpty(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    int washingEnds(int weekday) {
        Vector<Object> v = new Vector();
        int start = 0;
        for (Appliance appliance : this.applianceOf.getAppliances()) {
            if (!(appliance instanceof WashingMachine)) continue;
            v = appliance.getWeeklyOperation().get(this.applianceOf.getWeek() * 7 + weekday);
        }
        for (int i = 95; i > 0; --i) {
            if (!((Boolean)v.get(i)).booleanValue()) continue;
            start = i + 1;
            i = 0;
        }
        return start;
    }

    @Override
    public void showStatus() {
        log.debug((Object)("Name = " + this.name));
        log.debug((Object)("Saturation = " + this.saturation));
        log.debug((Object)("Power = " + this.power));
        log.debug((Object)("Cycle Duration = " + this.cycleDuration));
        ListIterator iter = this.days.listIterator();
        log.debug((Object)"Days Vector = ");
        while (iter.hasNext()) {
            log.debug((Object)("Day  " + iter.next()));
        }
        log.debug((Object)"Weekly Operation Vector and Load = ");
        for (int i = 0; i < VillageConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.debug((Object)("Day " + i));
            ListIterator iter3 = ((Vector)this.weeklyOperation.get(i)).listIterator();
            ListIterator iter4 = ((Vector)this.weeklyLoadVector.get(i)).listIterator();
            for (int j = 0; j < 96; ++j) {
                log.debug((Object)("Quarter " + j + " = " + iter3.next() + "  Load = " + iter4.next()));
            }
        }
    }

    @Override
    public double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, TariffEvaluationHelper tariffEvalHelper, int day) {
        double[] newControllableLoad = new double[24];
        return newControllableLoad;
    }

    @Override
    public void calculateOverallPower() {
        this.overallPower = 0;
        for (int j = 0; j < 3; ++j) {
            this.overallPower += this.power;
        }
        for (int k = 0; k < 3; ++k) {
            this.overallPower += this.power - (k + 1) * 250;
        }
    }

    @Override
    public void refresh() {
        for (Appliance appliance : this.applianceOf.getAppliances()) {
            if (!(appliance instanceof WashingMachine)) continue;
            WashingMachine wm = (WashingMachine)appliance;
            this.days = wm.getDays();
            break;
        }
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

