/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.FullyShiftingAppliance;

public class Freezer
extends FullyShiftingAppliance {
    public void fillWeeklyFunction() {
        for (int i = 0; i < 7; ++i) {
            this.fillDailyOperation(i);
        }
    }

    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " Freezer";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = Double.parseDouble(conf.getProperty("FreezerSaturation"));
        this.power = (int)(18.0 * this.gen.nextGaussian() + 106.0);
        this.cycleDuration = 2;
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            possibilityDailyOperation.add(true);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        int k = this.gen.nextInt(this.cycleDuration);
        for (int i = 0; i < 96; ++i) {
            if (i % this.cycleDuration == k) {
                this.loadVector.add(this.power);
                this.dailyOperation.add(true);
                continue;
            }
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, TariffEvaluationHelper tariffEvalHelper, int day) {
        double[] newControllableLoad = new double[24];
        return newControllableLoad;
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

