/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.NotShiftingAppliance;
import org.powertac.householdcustomer.configurations.Gaussian;

public class Lights
extends NotShiftingAppliance {
    double luminance;

    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " Lights";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = 1.0;
        this.power = (int)(58.0 * this.gen.nextGaussian() + 350.0);
        this.cycleDuration = 1;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            this.dailyOperation.add(false);
            this.loadVector.add(0);
            if (this.applianceOf.isEmpty(weekday, i)) continue;
            this.luminance = 40.0 * Gaussian.phi(i, 48.0, 16.0);
            if (!(this.luminance < this.gen.nextDouble())) continue;
            this.dailyOperation.set(i, true);
            this.loadVector.set(i, this.power * this.applianceOf.tenantsNumber(weekday, i));
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

