/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.NotShiftingAppliance;

public class Others
extends NotShiftingAppliance {
    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " Others";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = 1.0;
        this.power = (int)(83.0 * this.gen.nextGaussian() + 500.0);
        this.cycleDuration = 1;
        this.times = Integer.parseInt(conf.getProperty("OthersDailyTimes")) + this.applianceOf.getMembers().size();
    }

    @Override
    public void fillDailyOperation(int weekday) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i2 = 0; i2 < 96; ++i2) {
            this.dailyOperation.add(false);
            this.loadVector.add(0);
        }
        Vector<Integer> temp = new Vector<Integer>();
        for (i = 0; i < 96; ++i) {
            int count = this.applianceOf.tenantsNumber(weekday, i);
            for (int j = 0; j < count; ++j) {
                temp.add(i);
            }
        }
        if (temp.size() > 0) {
            for (i = 0; i < this.times; ++i) {
                int rand = this.gen.nextInt(temp.size());
                int quarter = (Integer)temp.get(rand);
                this.dailyOperation.set(quarter, true);
                this.loadVector.set(quarter, (Integer)this.loadVector.get(quarter) + this.power);
                temp.remove(rand);
                if (temp.size() == 0) break;
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

