/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.WeatherSensitiveAppliance;

public class SpaceHeater
extends WeatherSensitiveAppliance {
    double operationPercentage;
    int temperatureThreshold;

    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " SpaceHeater";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = Double.parseDouble(conf.getProperty("SpaceHeaterSaturation"));
        this.operationPercentage = Double.parseDouble(conf.getProperty("SpaceHeaterPercentage"));
        this.temperatureThreshold = (int)(3.0 * this.gen.nextGaussian() + 13.0);
        this.power = (int)(300.0 * this.gen.nextGaussian() + 7000.0);
        this.cycleDuration = 14;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void weatherDailyOperation(int day, int hour, double temp) {
        double perc = this.gen.nextDouble();
        if (!(this.applianceOf.isOnVacation(day) || temp > (double)this.temperatureThreshold || perc > this.operationPercentage)) {
            int i;
            for (i = 0; i < 96; ++i) {
                this.loadVector.add(0);
                this.dailyOperation.add(true);
            }
            for (i = 0; i < 9; ++i) {
                this.loadVector.set(i, this.power);
            }
            for (i = 9; i < 16; ++i) {
                this.loadVector.set(i, (Integer)this.loadVector.get(i - 1) - 750);
            }
            for (i = 16; i < 86; ++i) {
                this.loadVector.set(i, this.loadVector.get(i - 1));
            }
            for (i = 86; i < 90; ++i) {
                this.loadVector.set(i, (Integer)this.loadVector.get(i - 1) + 1500);
            }
            for (i = 90; i < 96; ++i) {
                this.loadVector.set(i, this.power);
            }
            this.weeklyLoadVector.set(day, this.loadVector);
            this.weeklyOperation.set(day, this.dailyOperation);
            log.debug((Object)"Changed");
        }
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        if (this.applianceOf.isOnVacation(day)) {
            for (int j = 0; j < 96; ++j) {
                possibilityDailyOperation.add(false);
            }
        } else {
            for (int j = 0; j < 96; ++j) {
                possibilityDailyOperation.add(true);
            }
        }
        return possibilityDailyOperation;
    }

    @Override
    public void showStatus() {
        super.showStatus();
        log.debug((Object)("Percentage: " + this.operationPercentage));
        log.debug((Object)("Temperature Threshold: " + this.temperatureThreshold));
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

