/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.SemiShiftingAppliance;

public class Stove
extends SemiShiftingAppliance {
    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " Stove";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = Double.parseDouble(conf.getProperty("StoveSaturation"));
        this.power = (int)(307.0 * this.gen.nextGaussian() + 1840.0);
        this.cycleDuration = 2;
        this.times = Integer.parseInt(conf.getProperty("StoveDailyTimes"));
    }

    @Override
    public void fillDailyOperation(int weekday) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int l = 0; l < 96; ++l) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        Vector<Integer> temp = new Vector<Integer>();
        for (i = 0; i < 96 - this.cycleDuration; ++i) {
            if (this.applianceOf.isEmpty(weekday, i) || this.applianceOf.isEmpty(weekday, i + 1)) continue;
            int count = this.applianceOf.tenantsNumber(weekday, i);
            for (int j = 0; j < count; ++j) {
                temp.add(i);
            }
        }
        if (temp.size() > 0) {
            for (i = 0; i < this.times; ++i) {
                int rand = this.gen.nextInt(temp.size());
                int quarter = (Integer)temp.get(rand);
                for (int j = 0; j < this.cycleDuration; ++j) {
                    this.dailyOperation.set(quarter + j, true);
                    this.loadVector.set(quarter + j, this.power);
                }
                temp.remove(rand);
                if (temp.size() == 0) break;
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 95; ++j) {
            if (!this.applianceOf.isEmpty(day, j) && !this.applianceOf.isEmpty(day, j + 1)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        possibilityDailyOperation.add(false);
        return possibilityDailyOperation;
    }

    @Override
    public double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, TariffEvaluationHelper tariffEvalHelper, int day) {
        int i;
        double[] newControllableLoad = new double[24];
        double[] newTemp = new double[24];
        boolean[] functionMatrix = this.createShiftingOperationMatrix(day);
        Vector<Integer> possibleHours = new Vector<Integer>();
        for (i = 0; i < 24; ++i) {
            if (!functionMatrix[i]) continue;
            possibleHours.add(i);
        }
        log.debug((Object)("Possible Hours: " + possibleHours.toString()));
        if (possibleHours.size() == 0) {
            log.debug((Object)"Not possible to shifting due to absence.");
            return newControllableLoad;
        }
        for (i = 0; i < this.times; ++i) {
            int minIndex = -1;
            int counter = 1;
            double minCost = Double.POSITIVE_INFINITY;
            for (int j = 0; j < possibleHours.size(); ++j) {
                newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                int n = (Integer)possibleHours.get(j);
                newTemp[n] = newTemp[n] + (double)(4 * this.power);
                double cost = Math.abs(tariffEvalHelper.estimateCost(tariff, newTemp));
                if (minCost == cost) {
                    ++counter;
                }
                if (!(minCost > cost) && (minCost != cost || !((double)this.gen.nextFloat() > 0.6))) continue;
                minCost = cost;
                minIndex = j;
            }
            if (counter == possibleHours.size()) {
                minIndex = (int)(this.gen.nextDouble() * (double)possibleHours.size());
            }
            log.debug((Object)("Less costly hour: " + possibleHours.get(minIndex)));
            int n = (Integer)possibleHours.get(minIndex);
            newControllableLoad[n] = newControllableLoad[n] + (double)(4 * this.power);
            newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
            int n2 = (Integer)possibleHours.get(minIndex);
            newTemp[n2] = newTemp[n2] + (double)(4 * this.power);
            nonDominantUsage = Arrays.copyOf(newTemp, newTemp.length);
        }
        return newControllableLoad;
    }

    @Override
    public void calculateOverallPower() {
        this.overallPower = 0;
        for (int j = 0; j < this.cycleDuration; ++j) {
            this.overallPower += this.power;
        }
        this.overallPower *= this.times;
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

