/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.Appliance;
import org.powertac.householdcustomer.appliances.Dryer;
import org.powertac.householdcustomer.appliances.SemiShiftingAppliance;
import org.powertac.householdcustomer.configurations.VillageConstants;

public class WashingMachine
extends SemiShiftingAppliance {
    protected boolean dryerFlag = false;
    protected int dryerPower = 0;
    protected int dryerIndex = -1;

    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " Washing Machine";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = Double.parseDouble(conf.getProperty("WashingMachineSaturation"));
        this.power = (int)(88.0 * this.gen.nextGaussian() + 530.0);
        this.cycleDuration = 8;
        this.times = Integer.parseInt(conf.getProperty("WashingMachineWeeklyTimes")) + this.applianceOf.getMembers().size() / 2;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int l = 0; l < 96; ++l) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        if (this.lastWeek[weekday] > 0) {
            int i;
            Vector<Integer> temp = new Vector<Integer>();
            for (i = 0; i < 96 - this.cycleDuration; ++i) {
                if (this.checkHouse(weekday, i)) continue;
                int count = this.applianceOf.tenantsNumber(weekday, i + this.cycleDuration);
                for (int j = 0; j < count; ++j) {
                    temp.add(i);
                }
            }
            if (temp.size() > 0) {
                for (i = 0; i < this.lastWeek[weekday]; ++i) {
                    int rand = this.gen.nextInt(temp.size());
                    int quarter = (Integer)temp.get(rand);
                    for (int j = 0; j < this.cycleDuration; ++j) {
                        this.dailyOperation.set(quarter + j, true);
                        this.loadVector.set(quarter + j, this.power);
                    }
                    temp.remove(rand);
                    if (temp.size() == 0) break;
                }
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.checkHouse(day, j)) {
                possibilityDailyOperation.add(false);
                continue;
            }
            possibilityDailyOperation.add(true);
        }
        return possibilityDailyOperation;
    }

    boolean checkHouse(int weekday, int quarter) {
        if (quarter + 8 >= 96) {
            return true;
        }
        return this.applianceOf.isEmpty(weekday, quarter + 8);
    }

    @Override
    public double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, TariffEvaluationHelper tariffEvalHelper, int day) {
        double[] newControllableLoad = new double[24];
        if ((Integer)this.days.get(day) > 0) {
            int i;
            double[] newTemp = new double[24];
            boolean[] functionMatrix = this.createShiftingOperationMatrix(day);
            Vector<Integer> possibleHours = new Vector<Integer>();
            for (i = 0; i < 24; ++i) {
                if (!functionMatrix[i] || !functionMatrix[i + 1]) continue;
                possibleHours.add(i);
            }
            log.debug((Object)("Possible Hours: " + possibleHours.toString()));
            if (possibleHours.size() == 0) {
                log.debug((Object)"Not possible to shifting due to absence.");
                return newControllableLoad;
            }
            for (i = 0; i < (Integer)this.days.get(day); ++i) {
                int minIndex = -1;
                int counter = 1;
                double minCost = Double.POSITIVE_INFINITY;
                for (int j = 0; j < possibleHours.size(); ++j) {
                    double cost;
                    newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                    int n = (Integer)possibleHours.get(j);
                    newTemp[n] = newTemp[n] + (double)(4 * this.power);
                    int n2 = (Integer)possibleHours.get(j) + 1;
                    newTemp[n2] = newTemp[n2] + (double)(4 * this.power);
                    if (this.dryerFlag) {
                        newTemp[((Integer)possibleHours.get((int)j)).intValue() + 2] = 4 * this.dryerPower - 250;
                        newTemp[((Integer)possibleHours.get((int)j)).intValue() + 3] = 2 * this.dryerPower - 1250;
                    }
                    if (minCost == (cost = Math.abs(tariffEvalHelper.estimateCost(tariff, newTemp)))) {
                        ++counter;
                    }
                    if (!(minCost > cost) && (minCost != cost || !((double)this.gen.nextFloat() > 0.6))) continue;
                    minCost = cost;
                    minIndex = j;
                }
                if (counter == possibleHours.size()) {
                    minIndex = (int)(this.gen.nextDouble() * (double)possibleHours.size());
                }
                log.debug((Object)("Less costly hour: " + possibleHours.get(minIndex)));
                int n = (Integer)possibleHours.get(minIndex);
                newControllableLoad[n] = newControllableLoad[n] + (double)(4 * this.power);
                int n3 = (Integer)possibleHours.get(minIndex) + 1;
                newControllableLoad[n3] = newControllableLoad[n3] + (double)(4 * this.power);
                if (this.dryerFlag) {
                    newControllableLoad[((Integer)possibleHours.get((int)minIndex)).intValue() + 2] = 4 * this.dryerPower - 250;
                    newControllableLoad[((Integer)possibleHours.get((int)minIndex)).intValue() + 3] = 2 * this.dryerPower - 1250;
                }
                newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                int n4 = (Integer)possibleHours.get(minIndex);
                newTemp[n4] = newTemp[n4] + (double)(4 * this.power);
                int n5 = (Integer)possibleHours.get(minIndex) + 1;
                newTemp[n5] = newTemp[n5] + (double)(4 * this.power);
                if (this.dryerFlag) {
                    newTemp[((Integer)possibleHours.get((int)minIndex)).intValue() + 2] = 4 * this.dryerPower - 250;
                    newTemp[((Integer)possibleHours.get((int)minIndex)).intValue() + 3] = 2 * this.dryerPower - 1250;
                }
                nonDominantUsage = Arrays.copyOf(newTemp, newTemp.length);
            }
        } else {
            log.debug((Object)"Not operating today");
        }
        return newControllableLoad;
    }

    public boolean getDryerFlag() {
        return this.dryerFlag;
    }

    public int getDryerIndex() {
        return this.dryerIndex;
    }

    @Override
    public void showStatus() {
        log.debug((Object)("Name = " + this.name));
        log.debug((Object)("Saturation = " + this.saturation));
        log.debug((Object)("Power = " + this.power));
        log.debug((Object)("Cycle Duration = " + this.cycleDuration));
        ListIterator iter = this.days.listIterator();
        log.debug((Object)"Days Vector = ");
        while (iter.hasNext()) {
            log.debug((Object)("Day  " + iter.next()));
        }
        log.debug((Object)"Weekly Operation Vector and Load = ");
        for (int i = 0; i < VillageConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.debug((Object)("Day " + i));
            ListIterator iter3 = ((Vector)this.weeklyOperation.get(i)).listIterator();
            ListIterator iter4 = ((Vector)this.weeklyLoadVector.get(i)).listIterator();
            for (int j = 0; j < 96; ++j) {
                log.debug((Object)("Quarter " + j + " = " + iter3.next() + "   Load = " + iter4.next()));
            }
        }
    }

    @Override
    public void calculateOverallPower() {
        this.overallPower = 0;
        for (int j = 0; j < this.cycleDuration; ++j) {
            this.overallPower += this.power;
        }
        if (this.dryerFlag) {
            this.overallPower += this.getDryerOverallPower();
        }
    }

    public int getDryerOverallPower() {
        int power = 0;
        Vector<Appliance> applianceList = this.applianceOf.getAppliances();
        for (Appliance appliance : applianceList) {
            if (!(appliance instanceof Dryer)) continue;
            power = appliance.getOverallPower();
        }
        return power;
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
        if (this.dryerFlag) {
            Vector<Appliance> applianceList = this.applianceOf.getAppliances();
            for (int i = 0; i < applianceList.size(); ++i) {
                if (!(applianceList.get(i) instanceof Dryer)) continue;
                this.dryerIndex = i;
                applianceList.get(i).refresh();
                break;
            }
        }
    }
}

