/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.appliances;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.FullyShiftingAppliance;
import org.powertac.householdcustomer.configurations.VillageConstants;
import org.powertac.householdcustomer.enumerations.HeaterType;

public class WaterHeater
extends FullyShiftingAppliance {
    HeaterType type;

    @Override
    public void initialize(String household, Properties conf, int seed) {
        int limit;
        this.name = household + " WaterHeater";
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.saturation = Double.parseDouble(conf.getProperty("WaterHeaterSaturation"));
        int x = 1 + this.gen.nextInt(100);
        if (x < (limit = Integer.parseInt(conf.getProperty("InstantHeater")))) {
            this.power = (int)(2000.0 * this.gen.nextGaussian() + 12000.0);
            this.cycleDuration = 1;
            this.type = HeaterType.InstantHeater;
            this.times = Integer.parseInt(conf.getProperty("InstantHeaterDailyTimes")) + this.applianceOf.getMembers().size() / 2;
            if (this.times == 0) {
                this.times = 1;
            }
        } else {
            this.power = (int)(500.0 * this.gen.nextGaussian() + 3000.0);
            this.cycleDuration = 8;
            this.type = HeaterType.StorageHeater;
        }
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        if (this.type == HeaterType.InstantHeater) {
            int i;
            for (int i2 = 0; i2 < 96; ++i2) {
                this.dailyOperation.add(false);
                this.loadVector.add(0);
            }
            Vector<Integer> temp = new Vector<Integer>();
            for (i = 0; i < 96; ++i) {
                int count = this.applianceOf.tenantsNumber(weekday, i);
                for (int j = 0; j < count; ++j) {
                    temp.add(i);
                }
            }
            if (temp.size() > 0) {
                for (i = 0; i < this.times; ++i) {
                    int rand = this.gen.nextInt(temp.size());
                    int quarter = (Integer)temp.get(rand);
                    this.dailyOperation.set(quarter, true);
                    this.loadVector.set(quarter, (Integer)this.loadVector.get(quarter) + this.power);
                    temp.remove(rand);
                    if (temp.size() == 0) break;
                }
            }
            this.weeklyLoadVector.add(this.loadVector);
            this.weeklyOperation.add(this.dailyOperation);
        } else {
            int i;
            int start = 0;
            int temp = 0;
            for (i = 0; i < 96; ++i) {
                this.dailyOperation.add(false);
                this.loadVector.add(0);
            }
            start = (double)this.gen.nextFloat() > 0.8 ? 21 + this.gen.nextInt(19) : 1 + this.gen.nextInt(20);
            for (i = start; i < start + 20; ++i) {
                this.dailyOperation.set(i, true);
                this.loadVector.set(i, this.power);
            }
            temp = start + 20;
            for (int j = 1; j < 4; ++j) {
                this.dailyOperation.set(temp + 4 * j, true);
                this.loadVector.set(temp + 4 * j, this.power);
            }
            this.weeklyLoadVector.add(this.loadVector);
            this.weeklyOperation.add(this.dailyOperation);
        }
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        if (this.type == HeaterType.InstantHeater) {
            for (int j = 0; j < 96; ++j) {
                if (!this.applianceOf.isEmpty(day, j)) {
                    possibilityDailyOperation.add(true);
                    continue;
                }
                possibilityDailyOperation.add(false);
            }
        } else {
            for (int j = 0; j < 96; ++j) {
                possibilityDailyOperation.add(true);
            }
        }
        return possibilityDailyOperation;
    }

    @Override
    public void showStatus() {
        log.debug((Object)("Name = " + this.name));
        log.debug((Object)("Saturation = " + this.saturation));
        log.debug((Object)("Power = " + this.power));
        log.debug((Object)("Heater Type = " + (Object)((Object)this.type)));
        log.debug((Object)("Cycle Duration = " + this.cycleDuration));
        log.debug((Object)"Weekly Operation Vector and Load = ");
        for (int i = 0; i < VillageConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.debug((Object)("Day " + i));
            ListIterator iter3 = ((Vector)this.weeklyOperation.get(i)).listIterator();
            ListIterator iter4 = ((Vector)this.weeklyLoadVector.get(i)).listIterator();
            for (int j = 0; j < 96; ++j) {
                log.debug((Object)("Quarter " + j + " = " + iter3.next() + "   Load = " + iter4.next()));
            }
        }
    }

    @Override
    public double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, TariffEvaluationHelper tariffEvalHelper, int day) {
        double[] newControllableLoad;
        block13: {
            newControllableLoad = new double[24];
            if (!((Boolean)this.operationDaysVector.get(day)).booleanValue()) break block13;
            double[] newTemp = new double[24];
            if (this.type == HeaterType.InstantHeater) {
                int i;
                boolean[] functionMatrix = this.createShiftingOperationMatrix(day);
                Vector<Integer> possibleHours = new Vector<Integer>();
                for (i = 0; i < 24; ++i) {
                    if (!functionMatrix[i]) continue;
                    possibleHours.add(i);
                }
                log.debug((Object)("Possible Hours: " + possibleHours.toString()));
                if (possibleHours.size() == 0) {
                    log.debug((Object)"Not possible to shifting due to absence.");
                    return newControllableLoad;
                }
                for (i = 0; i < this.times; ++i) {
                    int minIndex = -1;
                    int counter = 1;
                    double minCost = Double.POSITIVE_INFINITY;
                    for (int j = 0; j < possibleHours.size(); ++j) {
                        newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                        int n = (Integer)possibleHours.get(j);
                        newTemp[n] = newTemp[n] + (double)(4 * this.power);
                        double cost = Math.abs(tariffEvalHelper.estimateCost(tariff, newTemp));
                        if (minCost == cost) {
                            ++counter;
                        }
                        if (!(minCost > cost) && (minCost != cost || !((double)this.gen.nextFloat() > 0.6))) continue;
                        minCost = cost;
                        minIndex = j;
                    }
                    if (counter == possibleHours.size()) {
                        minIndex = (int)(this.gen.nextDouble() * (double)possibleHours.size());
                    }
                    log.debug((Object)("Less costly hour: " + possibleHours.get(minIndex)));
                    int n = (Integer)possibleHours.get(minIndex);
                    newControllableLoad[n] = newControllableLoad[n] + (double)(4 * this.power);
                    newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                    int n2 = (Integer)possibleHours.get(minIndex);
                    newTemp[n2] = newTemp[n2] + (double)(4 * this.power);
                    nonDominantUsage = Arrays.copyOf(newTemp, newTemp.length);
                }
            } else {
                int i;
                int minIndex = -1;
                int counter = 1;
                double minCost = Double.POSITIVE_INFINITY;
                for (i = 0; i < 17; ++i) {
                    newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                    int n = i;
                    newTemp[n] = newTemp[n] + (double)(4 * this.power);
                    double cost = Math.abs(tariffEvalHelper.estimateCost(tariff, newTemp));
                    log.debug((Object)("Overall Cost for hour " + i + " : " + cost));
                    if (minCost == cost) {
                        ++counter;
                    }
                    if (!(minCost > cost) && (minCost != cost || !((double)this.gen.nextFloat() > 0.6))) continue;
                    minCost = cost;
                    minIndex = i;
                }
                if (counter == 17) {
                    minIndex = (int)(this.gen.nextDouble() * 17.0);
                    log.debug((Object)("All the same, I choose: " + minIndex));
                }
                log.debug((Object)("Less costly hour: " + minIndex));
                for (i = 0; i <= 4; ++i) {
                    newControllableLoad[minIndex + i] = 4 * this.power;
                }
                for (i = 1; i < 4; ++i) {
                    newControllableLoad[4 + minIndex + i] = this.power;
                }
            }
        }
        return newControllableLoad;
    }

    @Override
    public void calculateOverallPower() {
        boolean flag = true;
        int day = -1;
        while (flag) {
            day = (int)(Math.random() * (double)this.operationDaysVector.size());
            flag = false;
            Vector consumption = (Vector)this.weeklyLoadVector.get(day);
            for (int i = 0; i < consumption.size(); ++i) {
                this.overallPower += ((Integer)consumption.get(i)).intValue();
            }
        }
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

