/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.customers;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.appliances.AirCondition;
import org.powertac.householdcustomer.appliances.Appliance;
import org.powertac.householdcustomer.appliances.CirculationPump;
import org.powertac.householdcustomer.appliances.ConsumerElectronics;
import org.powertac.householdcustomer.appliances.Dishwasher;
import org.powertac.householdcustomer.appliances.Dryer;
import org.powertac.householdcustomer.appliances.Freezer;
import org.powertac.householdcustomer.appliances.ICT;
import org.powertac.householdcustomer.appliances.Lights;
import org.powertac.householdcustomer.appliances.NotShiftingAppliance;
import org.powertac.householdcustomer.appliances.Others;
import org.powertac.householdcustomer.appliances.Refrigerator;
import org.powertac.householdcustomer.appliances.SpaceHeater;
import org.powertac.householdcustomer.appliances.Stove;
import org.powertac.householdcustomer.appliances.WashingMachine;
import org.powertac.householdcustomer.appliances.WaterHeater;
import org.powertac.householdcustomer.appliances.WeatherSensitiveAppliance;
import org.powertac.householdcustomer.configurations.VillageConstants;
import org.powertac.householdcustomer.customers.Village;
import org.powertac.householdcustomer.enumerations.Status;
import org.powertac.householdcustomer.persons.MostlyPresentPerson;
import org.powertac.householdcustomer.persons.PeriodicPresentPerson;
import org.powertac.householdcustomer.persons.Person;
import org.powertac.householdcustomer.persons.RandomlyAbsentPerson;
import org.springframework.beans.factory.annotation.Autowired;

public class Household {
    protected static Logger log = Logger.getLogger((String)Household.class.getName());
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    int seedId = 1;
    String name;
    Vector<Integer> dailyBaseLoad = new Vector();
    Vector<Integer> dailyControllableLoad = new Vector();
    Vector<Integer> dailyWeatherSensitiveLoad = new Vector();
    Vector<Integer> dailyNonDominantLoad = new Vector();
    Vector<Integer> dailyDominantLoad = new Vector();
    Vector<Vector<Integer>> weeklyBaseLoad = new Vector();
    Vector<Vector<Integer>> weeklyControllableLoad = new Vector();
    Vector<Vector<Integer>> weeklyWeatherSensitiveLoad = new Vector();
    Vector<Vector<Integer>> weeklyNonDominantLoad = new Vector();
    Vector<Vector<Integer>> weeklyDominantLoad = new Vector();
    Vector<Integer> dailyBaseLoadInHours = new Vector();
    Vector<Integer> dailyControllableLoadInHours = new Vector();
    Vector<Integer> dailyWeatherSensitiveLoadInHours = new Vector();
    Vector<Integer> dailyNonDominantLoadInHours = new Vector();
    Vector<Integer> dailyDominantLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyBaseLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyControllableLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyWeatherSensitiveLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyNonDominantLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyDominantLoadInHours = new Vector();
    int week = 0;
    Vector<Person> members = new Vector();
    Vector<Appliance> appliances = new Vector();
    int dominantAppliance;
    int daysDominant = 0;
    int daysNonDominant = 0;
    double[] dominantConsumption = new double[24];
    double[] nonDominantConsumption = new double[24];
    public Village householdOf;
    RandomSeed gen;

    public void initialize(String HouseName, Properties conf, Vector<Integer> publicVacationVector, int seed) {
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        double va = Double.parseDouble(conf.getProperty("VacationAbsence"));
        this.name = HouseName;
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Household Model" + seed);
        int persons = this.memberRandomizer(conf);
        for (int i = 0; i < persons; ++i) {
            this.addPerson(i + 1, conf, publicVacationVector);
        }
        for (Person member : this.members) {
            for (int i = 0; i < 7; ++i) {
                member.fillDailyRoutine(i, va);
                member.getWeeklyRoutine().add(member.getDailyRoutine());
                member.setMemberOf(this);
            }
        }
        this.fillAppliances(conf);
        for (int i = 0; i < 7; ++i) {
            this.dailyBaseLoad = this.fillDailyBaseLoad(this.week * 7 + i);
            this.dailyControllableLoad = this.fillDailyControllableLoad(this.week * 7 + i);
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(this.week * 7 + i);
            this.weeklyBaseLoad.add(this.dailyBaseLoad);
            this.weeklyControllableLoad.add(this.dailyControllableLoad);
            this.weeklyWeatherSensitiveLoad.add(this.dailyWeatherSensitiveLoad);
            this.dailyBaseLoadInHours = this.fillDailyBaseLoadInHours();
            this.dailyControllableLoadInHours = this.fillDailyControllableLoadInHours();
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyBaseLoadInHours.add(this.dailyBaseLoadInHours);
            this.weeklyControllableLoadInHours.add(this.dailyControllableLoadInHours);
            this.weeklyWeatherSensitiveLoadInHours.add(this.dailyWeatherSensitiveLoadInHours);
        }
        this.week = 1;
        while (this.week < VillageConstants.WEEKS_OF_COMPETITION + 2) {
            this.refresh(conf);
            ++this.week;
        }
        for (Appliance appliance : this.appliances) {
            if (!(appliance instanceof Dryer)) continue;
            appliance.setOperationDays();
            appliance.calculateOverallPower();
        }
        for (Appliance appliance : this.appliances) {
            if (appliance instanceof Dryer) continue;
            appliance.setOperationDays();
            appliance.calculateOverallPower();
        }
        this.findDominantAppliance();
        if (this.getDominantAppliance().getOverallPower() != 1) {
            this.createDominantOperationVectors();
        }
        int overallDays = (VillageConstants.WEEKS_OF_COMPETITION + 2) * 7;
        for (int i = 0; i < overallDays; ++i) {
            this.dailyNonDominantLoad = this.fillDailyNonDominantLoad(i);
            this.weeklyNonDominantLoad.add(this.dailyNonDominantLoad);
            this.dailyNonDominantLoadInHours = this.fillDailyNonDominantLoadInHours();
            this.weeklyNonDominantLoadInHours.add(this.dailyNonDominantLoadInHours);
            this.dailyDominantLoad = this.fillDailyDominantLoad(i);
            this.weeklyDominantLoad.add(this.dailyDominantLoad);
            this.dailyDominantLoadInHours = this.fillDailyDominantLoadInHours();
            this.weeklyDominantLoadInHours.add(this.dailyDominantLoadInHours);
        }
    }

    void addPerson(int counter, Properties conf, Vector<Integer> publicVacationVector) {
        int pp = Integer.parseInt(conf.getProperty("PeriodicPresent"));
        int mp = Integer.parseInt(conf.getProperty("MostlyPresent"));
        int x = this.gen.nextInt(100);
        if (x < pp) {
            PeriodicPresentPerson ppp = new PeriodicPresentPerson();
            ppp.initialize(this.toString() + "PPP" + counter, conf, publicVacationVector, this.seedId++);
            this.members.add(ppp);
        } else if (x >= pp & x < pp + mp) {
            MostlyPresentPerson mpp = new MostlyPresentPerson();
            mpp.initialize(this.toString() + "MPP" + counter, conf, publicVacationVector, this.seedId++);
            this.members.add(mpp);
        } else {
            RandomlyAbsentPerson rap = new RandomlyAbsentPerson();
            rap.initialize(this.toString() + "RAP" + counter, conf, publicVacationVector, this.seedId++);
            this.members.add(rap);
        }
    }

    private void createDominantOperationVectors() {
        Appliance app = this.appliances.get(this.dominantAppliance);
        Vector<Boolean> op = app.getOperationDaysVector();
        for (int i = 0; i < op.size(); ++i) {
            if (op.get(i).booleanValue()) {
                ++this.daysDominant;
            } else {
                ++this.daysNonDominant;
            }
            for (int j = 0; j < 24; ++j) {
                if (op.get(i).booleanValue()) {
                    int n = j;
                    this.dominantConsumption[n] = this.dominantConsumption[n] + (double)(this.weeklyBaseLoadInHours.get(i).get(j) + this.weeklyControllableLoadInHours.get(i).get(j) + this.weeklyWeatherSensitiveLoadInHours.get(i).get(j));
                    continue;
                }
                int n = j;
                this.nonDominantConsumption[n] = this.nonDominantConsumption[n] + (double)(this.weeklyBaseLoadInHours.get(i).get(j) + this.weeklyControllableLoadInHours.get(i).get(j) + this.weeklyWeatherSensitiveLoadInHours.get(i).get(j));
            }
        }
        for (int j = 0; j < 24; ++j) {
            if (this.daysDominant != 0) {
                int n = j;
                this.dominantConsumption[n] = this.dominantConsumption[n] / (double)this.daysDominant;
            }
            if (this.daysNonDominant == 0) continue;
            int n = j;
            this.nonDominantConsumption[n] = this.nonDominantConsumption[n] / (double)this.daysNonDominant;
        }
    }

    public int getWeek() {
        return this.week;
    }

    public Vector<Appliance> getAppliances() {
        return this.appliances;
    }

    public Vector<Person> getMembers() {
        return this.members;
    }

    public double getDominantConsumption(int hour) {
        return this.dominantConsumption[hour];
    }

    public double getNonDominantConsumption(int hour) {
        return this.nonDominantConsumption[hour];
    }

    public void findDominantAppliance() {
        double maxConsumption = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.appliances.size(); ++i) {
            if (!(maxConsumption < (double)this.appliances.get(i).getOverallPower())) continue;
            maxConsumption = this.appliances.get(i).getOverallPower();
            this.dominantAppliance = i;
        }
    }

    public Appliance getDominantAppliance() {
        return this.appliances.get(this.dominantAppliance);
    }

    int memberRandomizer(Properties conf) {
        int one = Integer.parseInt(conf.getProperty("OnePerson"));
        int two = Integer.parseInt(conf.getProperty("TwoPersons"));
        int three = Integer.parseInt(conf.getProperty("ThreePersons"));
        int four = Integer.parseInt(conf.getProperty("FourPersons"));
        int x = this.gen.nextInt(100);
        int returnValue = x < one ? 1 : (x >= one & x < one + two ? 2 : (x >= one + two & x < one + two + three ? 3 : (x >= one + two + three & x < one + two + three + four ? 4 : 5)));
        return returnValue;
    }

    void checkProbability(Appliance app) {
        int threshold;
        int x = this.gen.nextInt(100);
        if (x < (threshold = (int)(app.getSaturation() * 100.0))) {
            app.fillWeeklyOperation();
            app.createWeeklyPossibilityOperationVector();
        } else {
            this.appliances.remove(app);
        }
    }

    void fillAppliances(Properties conf) {
        AirCondition ac = new AirCondition();
        this.appliances.add(ac);
        ac.setApplianceOf(this);
        ac.initialize(this.name, conf, this.seedId++);
        this.checkProbability(ac);
        ConsumerElectronics ce = new ConsumerElectronics();
        this.appliances.add(ce);
        ce.setApplianceOf(this);
        ce.initialize(this.name, conf, this.seedId++);
        ce.fillWeeklyOperation();
        ce.createWeeklyPossibilityOperationVector();
        ICT ict = new ICT();
        this.appliances.add(ict);
        ict.setApplianceOf(this);
        ict.initialize(this.name, conf, this.seedId++);
        ict.fillWeeklyOperation();
        ict.createWeeklyPossibilityOperationVector();
        Lights lights = new Lights();
        this.appliances.add(lights);
        lights.setApplianceOf(this);
        lights.initialize(this.name, conf, this.seedId++);
        lights.fillWeeklyOperation();
        lights.createWeeklyPossibilityOperationVector();
        Others others = new Others();
        this.appliances.add(others);
        others.setApplianceOf(this);
        others.initialize(this.name, conf, this.seedId++);
        others.fillWeeklyOperation();
        others.createWeeklyPossibilityOperationVector();
        CirculationPump cp = new CirculationPump();
        cp.setApplianceOf(this);
        this.appliances.add(cp);
        cp.initialize(this.name, conf, this.seedId++);
        this.checkProbability(cp);
        Refrigerator ref = new Refrigerator();
        this.appliances.add(ref);
        ref.setApplianceOf(this);
        ref.initialize(this.name, conf, this.seedId++);
        ref.fillWeeklyOperation();
        ref.createWeeklyPossibilityOperationVector();
        Freezer fr = new Freezer();
        this.appliances.add(fr);
        fr.setApplianceOf(this);
        fr.initialize(this.name, conf, this.seedId++);
        this.checkProbability(fr);
        SpaceHeater sh = new SpaceHeater();
        this.appliances.add(sh);
        sh.setApplianceOf(this);
        sh.initialize(this.name, conf, this.seedId++);
        this.checkProbability(sh);
        WaterHeater wh = new WaterHeater();
        this.appliances.add(wh);
        wh.setApplianceOf(this);
        wh.initialize(this.name, conf, this.seedId++);
        this.checkProbability(wh);
        Dishwasher dw = new Dishwasher();
        this.appliances.add(dw);
        dw.setApplianceOf(this);
        dw.initialize(this.name, conf, this.seedId++);
        this.checkProbability(dw);
        Stove st = new Stove();
        this.appliances.add(st);
        st.setApplianceOf(this);
        st.initialize(this.name, conf, this.seedId++);
        this.checkProbability(st);
        WashingMachine wm = new WashingMachine();
        this.appliances.add(wm);
        wm.setApplianceOf(this);
        wm.initialize(this.name, conf, this.seedId++);
        wm.fillWeeklyOperation();
        wm.createWeeklyPossibilityOperationVector();
        Dryer dr = new Dryer();
        this.appliances.add(dr);
        dr.setApplianceOf(this);
        dr.initialize(this.name, conf, this.seedId++);
        this.checkProbability(dr);
    }

    public boolean isEmpty(int weekday, int quarter) {
        boolean x = true;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Normal && member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Sick) continue;
            x = false;
        }
        return x;
    }

    public int tenantsNumber(int weekday, int quarter) {
        int counter = 0;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Normal && member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Sick) continue;
            ++counter;
        }
        return counter;
    }

    void showStatus() {
        int j;
        ListIterator<Integer> iter4;
        ListIterator<Integer> iter3;
        ListIterator<Integer> iter2;
        int i;
        log.info((Object)("HouseHold Name : " + this.name));
        log.info((Object)("Number of Persons : " + this.members.size()));
        log.info((Object)" Daily Load = ");
        for (i = 0; i < VillageConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.info((Object)("Day " + i));
            iter2 = this.weeklyBaseLoad.get(i).listIterator();
            iter3 = this.weeklyControllableLoad.get(i).listIterator();
            iter4 = this.weeklyWeatherSensitiveLoad.get(i).listIterator();
            for (j = 0; j < 96; ++j) {
                log.info((Object)("Quarter : " + j + " Base Load : " + iter2.next() + " Controllable Load: " + iter3.next() + " WeatherSensitive Load: " + iter4.next()));
            }
        }
        log.info((Object)" Load In Hours = ");
        for (i = 0; i < VillageConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.info((Object)("Day " + i));
            iter2 = this.weeklyBaseLoadInHours.get(i).listIterator();
            iter3 = this.weeklyControllableLoadInHours.get(i).listIterator();
            iter4 = this.weeklyWeatherSensitiveLoadInHours.get(i).listIterator();
            for (j = 0; j < 24; ++j) {
                log.info((Object)("Hours : " + j + " Base Load : " + iter2.next() + " Controllable Load: " + iter3.next() + " WeatherSensitive Load: " + iter4.next()));
            }
        }
    }

    Vector<Integer> fillDailyBaseLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (!(appliance instanceof NotShiftingAppliance)) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyControllableLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (appliance instanceof NotShiftingAppliance) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyWeatherSensitiveLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (!(appliance instanceof WeatherSensitiveAppliance)) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyDominantLoad(int day) {
        WashingMachine wm;
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        int helpIndex = -1;
        Appliance app = this.appliances.get(this.dominantAppliance);
        if (app instanceof WashingMachine && (wm = (WashingMachine)app).getDryerFlag()) {
            helpIndex = wm.getDryerIndex();
        }
        for (int i = 0; i < 96; ++i) {
            if (this.appliances.get(this.dominantAppliance).getOverallPower() != -1) {
                sum = this.appliances.get(this.dominantAppliance).getWeeklyLoadVector().get(day).get(i);
                if (helpIndex != -1) {
                    sum += this.appliances.get(helpIndex).getWeeklyLoadVector().get(day).get(i).intValue();
                }
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyNonDominantLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (int j = 0; j < this.appliances.size(); ++j) {
                if (j == this.dominantAppliance) continue;
                sum += this.appliances.get(j).getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    public boolean isOnVacation(int day) {
        boolean x = true;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(day).get(0) == Status.Vacation) continue;
            x = false;
        }
        return x;
    }

    Vector<Integer> fillDailyBaseLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyBaseLoad.get(i * 4) + this.dailyBaseLoad.get(i * 4 + 1) + this.dailyBaseLoad.get(i * 4 + 2) + this.dailyBaseLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyControllableLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyControllableLoad.get(i * 4) + this.dailyControllableLoad.get(i * 4 + 1) + this.dailyControllableLoad.get(i * 4 + 2) + this.dailyControllableLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyWeatherSensitiveLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyWeatherSensitiveLoad.get(i * 4) + this.dailyWeatherSensitiveLoad.get(i * 4 + 1) + this.dailyWeatherSensitiveLoad.get(i * 4 + 2) + this.dailyWeatherSensitiveLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyDominantLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyDominantLoad.get(i * 4) + this.dailyDominantLoad.get(i * 4 + 1) + this.dailyDominantLoad.get(i * 4 + 2) + this.dailyDominantLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyNonDominantLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyNonDominantLoad.get(i * 4) + this.dailyNonDominantLoad.get(i * 4 + 1) + this.dailyNonDominantLoad.get(i * 4 + 2) + this.dailyNonDominantLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    void refresh(Properties conf) {
        for (Person member : this.members) {
            member.refresh(conf);
        }
        for (Appliance appliance : this.appliances) {
            if (appliance instanceof Dryer) continue;
            appliance.refresh();
        }
        for (int i = 0; i < 7; ++i) {
            this.dailyBaseLoad = this.fillDailyBaseLoad(this.week * 7 + i);
            this.dailyControllableLoad = this.fillDailyControllableLoad(this.week * 7 + i);
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(this.week * 7 + i);
            this.weeklyBaseLoad.add(this.dailyBaseLoad);
            this.weeklyControllableLoad.add(this.dailyControllableLoad);
            this.weeklyWeatherSensitiveLoad.add(this.dailyWeatherSensitiveLoad);
            this.dailyBaseLoadInHours = this.fillDailyBaseLoadInHours();
            this.dailyControllableLoadInHours = this.fillDailyControllableLoadInHours();
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyBaseLoadInHours.add(this.dailyBaseLoadInHours);
            this.weeklyControllableLoadInHours.add(this.dailyControllableLoadInHours);
            this.weeklyWeatherSensitiveLoadInHours.add(this.dailyWeatherSensitiveLoadInHours);
        }
    }

    public void weatherCheck(int day, int hour, Instant now, double temperature) {
        boolean flag = false;
        for (Appliance appliance : this.appliances) {
            if (appliance instanceof SpaceHeater && hour == 23 && day + 1 < VillageConstants.DAYS_OF_COMPETITION) {
                appliance.weatherDailyOperation(day + 1, 0, temperature);
                if (appliance.getWeeklyLoadVector().get(day + 1).get(0) > 0) {
                    this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(day + 1);
                    this.weeklyWeatherSensitiveLoad.set(day + 1, this.dailyWeatherSensitiveLoad);
                    this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
                    this.weeklyWeatherSensitiveLoadInHours.set(day + 1, this.dailyWeatherSensitiveLoadInHours);
                    flag = true;
                }
            }
            if (!(appliance instanceof AirCondition) || flag) continue;
            appliance.weatherDailyOperation(day, hour, temperature);
            if (appliance.getWeeklyLoadVector().get(day).get(hour * 4) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 1) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 2) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 3) <= 0) continue;
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(day);
            this.weeklyWeatherSensitiveLoad.set(day, this.dailyWeatherSensitiveLoad);
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyWeatherSensitiveLoadInHours.set(day, this.dailyWeatherSensitiveLoadInHours);
        }
    }

    double[] dailyShifting(Tariff tariff, double[] nonDominantLoad, TariffEvaluationHelper tariffEvalHelper, int day, RandomSeed gen) {
        double[] dominantLoad = new double[24];
        Appliance appliance = this.appliances.get(this.dominantAppliance);
        if (appliance.getOverallPower() != -1) {
            dominantLoad = appliance.dailyShifting(tariff, nonDominantLoad, tariffEvalHelper, day);
        }
        log.debug((Object)("Dominant Appliance " + appliance.toString() + " Overall Power: " + appliance.getOverallPower()));
        log.debug((Object)("New Dominant Load: " + Arrays.toString(dominantLoad)));
        return dominantLoad;
    }

    public String toString() {
        return this.name;
    }
}

