/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.persons;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.configurations.VillageConstants;
import org.powertac.householdcustomer.enumerations.Status;
import org.powertac.householdcustomer.persons.Person;

public class MostlyPresentPerson
extends Person {
    @Override
    public void initialize(String AgentName, Properties conf, Vector<Integer> publicVacationVector, int seed) {
        double sicknessMean = Double.parseDouble(conf.getProperty("SicknessMean"));
        double sicknessDev = Double.parseDouble(conf.getProperty("SicknessDev"));
        double leisureDurationMean = Double.parseDouble(conf.getProperty("LeisureDurationMean"));
        double leisureDurationDev = Double.parseDouble(conf.getProperty("LeisureDurationDev"));
        double MPLeisure = Double.parseDouble(conf.getProperty("MPLeisure"));
        this.name = AgentName;
        this.status = Status.Normal;
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Person Model" + seed);
        this.sicknessVector = this.createSicknessVector(sicknessMean, sicknessDev);
        this.publicVacationVector = publicVacationVector;
        int x = (int)(this.gen.nextGaussian() + MPLeisure);
        this.leisureVector = this.createLeisureVector(x);
        this.leisureDuration = (int)(leisureDurationDev * this.gen.nextGaussian() + leisureDurationMean);
    }

    @Override
    public void showInfo() {
        log.debug((Object)("Name = " + this.name));
        log.debug((Object)("Member Of = " + this.memberOf.toString()));
        log.debug((Object)"Sickness Days = ");
        ListIterator iter = this.sicknessVector.listIterator();
        while (iter.hasNext()) {
            log.debug(iter.next());
        }
        log.info((Object)"Leisure Days of Week = ");
        iter = this.leisureVector.listIterator();
        while (iter.hasNext()) {
            log.debug(iter.next());
        }
        log.info((Object)("Leisure Duration = " + this.leisureDuration));
        log.debug((Object)"Public Vacation of Year = ");
        iter = this.publicVacationVector.listIterator();
        while (iter.hasNext()) {
            log.debug(iter.next());
        }
        log.debug((Object)("Weekly Routine Length : " + this.weeklyRoutine.size()));
        log.debug((Object)"Weekly Routine : ");
        for (int i = 0; i < VillageConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.debug((Object)("Day " + i));
            ListIterator iter2 = ((Vector)this.weeklyRoutine.get(i)).listIterator();
            for (int j = 0; j < 96; ++j) {
                log.debug((Object)("Quarter : " + (j + 1) + " Status : " + iter2.next()));
            }
        }
    }

    @Override
    public void refresh(Properties conf) {
        double leisureDurationMean = Double.parseDouble(conf.getProperty("LeisureDurationMean"));
        double leisureDurationDev = Double.parseDouble(conf.getProperty("LeisureDurationDev"));
        double MPLeisure = Double.parseDouble(conf.getProperty("MPLeisure"));
        double vacationAbsence = Double.parseDouble(conf.getProperty("VacationAbsence"));
        int x = (int)(this.gen.nextGaussian() + MPLeisure);
        this.leisureDuration = (int)(leisureDurationDev * this.gen.nextGaussian() + leisureDurationMean);
        this.leisureVector = this.createLeisureVector(x);
        for (int i = 0; i < 7; ++i) {
            this.fillDailyRoutine(i, vacationAbsence);
            this.weeklyRoutine.add(this.dailyRoutine);
        }
    }
}

