/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.persons;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.enumerations.Status;
import org.powertac.householdcustomer.persons.WorkingPerson;

public class PeriodicPresentPerson
extends WorkingPerson {
    @Override
    public void initialize(String AgentName, Properties conf, Vector<Integer> publicVacationVector, int seed) {
        double sicknessMean = Double.parseDouble(conf.getProperty("SicknessMean"));
        double sicknessDev = Double.parseDouble(conf.getProperty("SicknessDev"));
        double leisureDurationMean = Double.parseDouble(conf.getProperty("LeisureDurationMean"));
        double leisureDurationDev = Double.parseDouble(conf.getProperty("LeisureDurationDev"));
        double PPLeisure = Double.parseDouble(conf.getProperty("PPLeisure"));
        double workingDurationMean = Double.parseDouble(conf.getProperty("WorkingDurationMean"));
        double workingDurationDev = Double.parseDouble(conf.getProperty("WorkingDurationDev"));
        double vacationDurationMean = Double.parseDouble(conf.getProperty("VacationDurationMean"));
        double vacationDurationDev = Double.parseDouble(conf.getProperty("VacationDurationDev"));
        this.name = AgentName;
        this.status = Status.Normal;
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Person Model" + seed);
        this.sicknessVector = this.createSicknessVector(sicknessMean, sicknessDev);
        this.publicVacationVector = publicVacationVector;
        int x = (int)(this.gen.nextGaussian() + PPLeisure);
        this.leisureVector = this.createLeisureVector(x);
        this.leisureDuration = (int)(leisureDurationDev * this.gen.nextGaussian() + leisureDurationMean);
        this.workingStartHour = 28;
        int work = this.workingDaysRandomizer(conf);
        this.workingDays = this.createWorkingDaysVector(work);
        this.workingDuration = (int)(workingDurationDev * this.gen.nextGaussian() + workingDurationMean);
        this.vacationDuration = (int)(vacationDurationDev * this.gen.nextGaussian() + vacationDurationMean);
        this.vacationVector = this.createVacationVector(Math.max(0, this.vacationDuration));
    }

    @Override
    void addLeisureWorking(int weekday) {
        ListIterator iter = this.leisureVector.listIterator();
        block0: while (iter.hasNext()) {
            int startq;
            if ((Integer)iter.next() != weekday) continue;
            int start = this.workingStartHour + this.workingDuration;
            for (int i = startq = this.gen.nextInt(Math.max(1, 75 - start)) + start; i < startq + this.leisureDuration; ++i) {
                Status st = Status.Leisure;
                this.dailyRoutine.set(i, st);
                if (i == 95) continue block0;
            }
        }
    }

    @Override
    void fillWork() {
        for (int i = this.workingStartHour; i < this.workingStartHour + this.workingDuration; ++i) {
            Status st = Status.Working;
            this.dailyRoutine.set(i, st);
        }
    }

    @Override
    public void refresh(Properties conf) {
        double leisureDurationMean = Double.parseDouble(conf.getProperty("LeisureDurationMean"));
        double leisureDurationDev = Double.parseDouble(conf.getProperty("LeisureDurationDev"));
        double PPLeisure = Double.parseDouble(conf.getProperty("PPLeisure"));
        double vacationAbsence = Double.parseDouble(conf.getProperty("VacationAbsence"));
        int x = (int)(this.gen.nextGaussian() + PPLeisure);
        this.leisureDuration = (int)(leisureDurationDev * this.gen.nextGaussian() + leisureDurationMean);
        this.leisureVector = this.createLeisureVector(x);
        for (int i = 0; i < 7; ++i) {
            this.fillDailyRoutine(i, vacationAbsence);
            this.weeklyRoutine.add(this.dailyRoutine);
        }
    }
}

