/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.persons;

import java.util.Collections;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.powertac.common.RandomSeed;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.householdcustomer.configurations.VillageConstants;
import org.powertac.householdcustomer.customers.Household;
import org.powertac.householdcustomer.enumerations.Status;
import org.powertac.householdcustomer.persons.WorkingPerson;
import org.springframework.beans.factory.annotation.Autowired;

public class Person {
    protected static Logger log = Logger.getLogger((String)Person.class.getName());
    @Autowired
    protected RandomSeedRepo randomSeedRepo;
    String name;
    Status status;
    Household memberOf;
    Vector<Integer> workingDays = new Vector();
    Vector<Integer> vacationVector = new Vector();
    Vector<Integer> publicVacationVector = new Vector();
    Vector<Integer> sicknessVector = new Vector();
    int leisureDuration = 0;
    Vector<Integer> leisureVector = new Vector();
    Vector<Status> dailyRoutine = new Vector();
    Vector<Vector<Status>> weeklyRoutine = new Vector();
    RandomSeed gen;

    public void initialize(String AgentName, Properties conf, Vector<Integer> publicVacationVector, int seed) {
    }

    boolean isSleeping() {
        return this.status == Status.Sleeping;
    }

    boolean isAtWork() {
        return this.status == Status.Working;
    }

    boolean isLeisure() {
        return this.status == Status.Leisure;
    }

    boolean isVacation() {
        return this.status == Status.Vacation;
    }

    boolean isSick() {
        return this.status == Status.Sick;
    }

    public Vector<Vector<Status>> getWeeklyRoutine() {
        return this.weeklyRoutine;
    }

    public Vector<Status> getDailyRoutine() {
        return this.dailyRoutine;
    }

    Vector<Integer> createLeisureVector(int counter) {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < counter; ++i) {
            int day = this.gen.nextInt(7);
            v.add(day);
        }
        Collections.sort(v);
        return v;
    }

    Vector<Integer> createSicknessVector(double mean, double dev) {
        int days = (int)(dev * this.gen.nextGaussian() + mean);
        Vector<Integer> v = new Vector<Integer>(days);
        for (int i = 0; i < days; ++i) {
            int x = this.gen.nextInt(VillageConstants.DAYS_OF_COMPETITION + 14) + 1;
            ListIterator<Integer> iter = v.listIterator();
            while (iter.hasNext()) {
                int temp = iter.next();
                if (x != temp) continue;
                ++x;
                iter = v.listIterator();
            }
            v.add(x);
        }
        Collections.sort(v);
        return v;
    }

    public void setMemberOf(Household house) {
        this.memberOf = house;
    }

    public void fillDailyRoutine(int day, double vacationAbsence) {
        int weekday = day % 7;
        this.dailyRoutine = new Vector();
        if (this.sicknessVector.contains(day)) {
            this.fillSick();
        } else if (this.publicVacationVector.contains(day) || this instanceof WorkingPerson && this.vacationVector.contains(day)) {
            if (this.gen.nextDouble() < vacationAbsence) {
                for (int i = 0; i < 96; ++i) {
                    Status st = Status.Vacation;
                    this.dailyRoutine.add(st);
                }
            } else {
                this.normalFill();
                this.addLeisure(weekday);
            }
        } else {
            this.normalFill();
            if (this instanceof WorkingPerson) {
                int index = this.workingDays.indexOf(weekday);
                if (index > -1) {
                    this.fillWork();
                    this.addLeisureWorking(weekday);
                } else {
                    this.addLeisure(weekday);
                }
            } else {
                this.addLeisure(weekday);
            }
        }
    }

    void addLeisure(int weekday) {
        ListIterator<Integer> iter = this.leisureVector.listIterator();
        block0: while (iter.hasNext()) {
            int start;
            if (iter.next() != weekday) continue;
            for (int i = start = 28 + this.gen.nextInt(46); i < start + this.leisureDuration; ++i) {
                Status st = Status.Leisure;
                this.dailyRoutine.set(i, st);
                if (i == 95) continue block0;
            }
        }
    }

    void addLeisureWorking(int weekday) {
    }

    void normalFill() {
        Status st;
        int i;
        for (i = 0; i < 25; ++i) {
            st = Status.Sleeping;
            this.dailyRoutine.add(st);
        }
        for (i = 25; i < 91; ++i) {
            st = Status.Normal;
            this.dailyRoutine.add(st);
        }
        for (i = 91; i < 96; ++i) {
            st = Status.Sleeping;
            this.dailyRoutine.add(st);
        }
    }

    void fillSick() {
        Status st;
        int i;
        for (i = 0; i < 25; ++i) {
            st = Status.Sleeping;
            this.dailyRoutine.add(st);
        }
        for (i = 25; i < 91; ++i) {
            st = Status.Sick;
            this.dailyRoutine.add(st);
        }
        for (i = 91; i < 96; ++i) {
            st = Status.Sleeping;
            this.dailyRoutine.add(st);
        }
    }

    void fillWork() {
    }

    public void showInfo() {
    }

    public void refresh(Properties config) {
    }

    public void test() {
        System.out.println(this.toString() + " " + this.gen.nextDouble());
    }

    public String toString() {
        return this.name;
    }
}

