/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.householdcustomer.persons;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.householdcustomer.enumerations.Status;
import org.powertac.householdcustomer.persons.WorkingPerson;

public class RandomlyAbsentPerson
extends WorkingPerson {
    @Override
    public void initialize(String AgentName, Properties conf, Vector<Integer> publicVacationVector, int seed) {
        double sicknessMean = Double.parseDouble(conf.getProperty("SicknessMean"));
        double sicknessDev = Double.parseDouble(conf.getProperty("SicknessDev"));
        double leisureDurationMean = Double.parseDouble(conf.getProperty("LeisureDurationMean"));
        double leisureDurationDev = Double.parseDouble(conf.getProperty("LeisureDurationDev"));
        double RALeisure = Double.parseDouble(conf.getProperty("RALeisure"));
        double workingDurationMean = Double.parseDouble(conf.getProperty("WorkingDurationMean"));
        double workingDurationDev = Double.parseDouble(conf.getProperty("WorkingDurationDev"));
        double vacationDurationMean = Double.parseDouble(conf.getProperty("VacationDurationMean"));
        double vacationDurationDev = Double.parseDouble(conf.getProperty("VacationDurationDev"));
        this.name = AgentName;
        this.status = Status.Normal;
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Person Model" + seed);
        this.sicknessVector = this.createSicknessVector(sicknessMean, sicknessDev);
        this.publicVacationVector = publicVacationVector;
        int x = (int)(this.gen.nextGaussian() + RALeisure);
        this.leisureVector = this.createLeisureVector(x);
        this.leisureDuration = (int)(leisureDurationDev * this.gen.nextGaussian() + leisureDurationMean);
        int work = this.workingDaysRandomizer(conf);
        this.workingDays = this.createWorkingDaysVector(work);
        this.workingStartHour = this.createWorkingStartHour();
        this.workingDuration = (int)(workingDurationDev * this.gen.nextGaussian() + workingDurationMean);
        this.vacationDuration = (int)(vacationDurationDev * this.gen.nextGaussian() + vacationDurationMean);
        this.vacationVector = this.createVacationVector(this.vacationDuration);
    }

    int createWorkingStartHour() {
        int x = this.gen.nextInt(3);
        return x * 8 * 4;
    }

    @Override
    void addLeisureWorking(int weekday) {
        ListIterator iter = this.leisureVector.listIterator();
        block0: while (iter.hasNext()) {
            Status st;
            int startq;
            int i;
            if ((Integer)iter.next() != weekday) continue;
            int start = this.workingStartHour + this.workingDuration;
            if (this.workingStartHour == 0 && 47 - start > 0) {
                for (i = startq = this.gen.nextInt(47 - start) + (start + 33); i < startq + this.leisureDuration; ++i) {
                    st = Status.Leisure;
                    this.dailyRoutine.set(i, st);
                    if (i == 95) continue block0;
                }
                continue;
            }
            if (this.workingStartHour == 33) {
                for (i = startq = start + this.gen.nextInt(80 - start); i < startq + this.leisureDuration; ++i) {
                    st = Status.Leisure;
                    this.dailyRoutine.set(i, st);
                    if (i == 95) continue block0;
                }
                continue;
            }
            for (i = startq = 33 + this.gen.nextInt(20); i < startq + this.leisureDuration; ++i) {
                st = Status.Leisure;
                this.dailyRoutine.set(i, st);
                if (i == 95) continue block0;
            }
        }
    }

    @Override
    void fillWork() {
        if (this.workingStartHour == 0) {
            Status st;
            int i;
            for (i = 0; i < this.workingDuration; ++i) {
                st = Status.Working;
                this.dailyRoutine.set(i, st);
            }
            for (i = this.workingDuration; i < this.workingDuration + 33; ++i) {
                st = Status.Sleeping;
                this.dailyRoutine.set(i, st);
            }
            for (i = this.workingDuration + 33; i < 96; ++i) {
                st = Status.Normal;
                this.dailyRoutine.set(i, st);
            }
        } else if (this.workingStartHour == 33) {
            Status st;
            int i;
            for (i = 0; i < 25; ++i) {
                st = Status.Sleeping;
                this.dailyRoutine.set(i, st);
            }
            for (i = 25; i < 33; ++i) {
                st = Status.Normal;
                this.dailyRoutine.set(i, st);
            }
            for (i = 33; i < this.workingDuration + 33; ++i) {
                st = Status.Working;
                this.dailyRoutine.set(i, st);
            }
            for (i = this.workingDuration + 33; i < 0; ++i) {
                st = Status.Normal;
                this.dailyRoutine.set(i, st);
            }
            for (i = 0; i < 96; ++i) {
                st = Status.Sleeping;
                this.dailyRoutine.set(i, st);
            }
        } else {
            Status st;
            int i;
            for (i = 0; i < 25; ++i) {
                st = Status.Sleeping;
                this.dailyRoutine.set(i, st);
            }
            for (i = 25; i < 65; ++i) {
                st = Status.Normal;
                this.dailyRoutine.set(i, st);
            }
            if (this.workingDuration > 32) {
                for (i = 65; i < 96; ++i) {
                    st = Status.Working;
                    this.dailyRoutine.set(i, st);
                }
            } else {
                for (i = 65; i < 65 + this.workingDuration && i < 96; ++i) {
                    st = Status.Working;
                    this.dailyRoutine.set(i, st);
                }
                for (i = 65 + this.workingDuration; i < 96; ++i) {
                    st = Status.Sleeping;
                    this.dailyRoutine.set(i, st);
                }
            }
        }
    }

    @Override
    public void refresh(Properties conf) {
        double leisureDurationMean = Double.parseDouble(conf.getProperty("LeisureDurationMean"));
        double leisureDurationDev = Double.parseDouble(conf.getProperty("LeisureDurationDev"));
        double RALeisure = Double.parseDouble(conf.getProperty("RALeisure"));
        double vacationAbsence = Double.parseDouble(conf.getProperty("VacationAbsence"));
        int work = this.workingDaysRandomizer(conf);
        this.workingDays = this.createWorkingDaysVector(work);
        this.workingStartHour = this.createWorkingStartHour();
        int x = (int)(this.gen.nextGaussian() + RALeisure);
        this.leisureDuration = (int)(leisureDurationDev * this.gen.nextGaussian() + leisureDurationMean);
        this.leisureVector = this.createLeisureVector(x);
        for (int i = 0; i < 7; ++i) {
            this.fillDailyRoutine(i, vacationAbsence);
            this.weeklyRoutine.add(this.dailyRoutine);
        }
    }
}

