/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.logtool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.msg.SimEnd;
import org.powertac.logtool.common.DomainBuilder;
import org.powertac.logtool.common.DomainObjectReader;
import org.powertac.logtool.common.MissingDomainObject;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.logtool.ifc.Analyzer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogtoolCore {
    private static Logger log = Logger.getLogger((String)LogtoolCore.class.getName());
    @Autowired
    private DomainObjectReader reader;
    @Autowired
    private DomainBuilder builder;
    private boolean simEnd = false;

    public void processCmdLine(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: Logtool file analyzer ...");
            return;
        }
        String filename = args[0];
        ArrayList<Analyzer> tools = new ArrayList<Analyzer>();
        for (int i = 1; i < args.length; ++i) {
            try {
                Class<?> toolClass = Class.forName(args[i]);
                tools.add((Analyzer)toolClass.newInstance());
                continue;
            }
            catch (ClassNotFoundException e1) {
                System.out.println("Cannot find analyzer class " + args[i]);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception creating analyzer " + ex.toString());
            }
        }
        this.readStateLog(filename, tools);
    }

    public void readStateLog(String filename, List<Analyzer> tools) {
        this.reader.registerNewObjectListener(new SimEndHandler(), SimEnd.class);
        String line = null;
        try {
            InputStreamReader inputReader;
            if (null == filename || "-".equals(filename)) {
                inputReader = new InputStreamReader(System.in);
                filename = "standard input";
                log.info((Object)"Reading from standard input");
            } else {
                File input = new File(filename);
                if (!input.canRead()) {
                    System.out.println("Cannot read file " + filename);
                    return;
                }
                inputReader = new FileReader(input);
                log.info((Object)("Reading file " + filename));
            }
            this.builder.setup();
            for (Analyzer tool : tools) {
                tool.setup();
            }
            BufferedReader in = new BufferedReader(inputReader);
            int lineNumber = 0;
            while (!this.simEnd) {
                line = in.readLine();
                if (null == line) {
                    log.info((Object)("Last line " + lineNumber));
                    break;
                }
                ++lineNumber;
                this.reader.readObject(line);
            }
            this.builder.report();
            for (Analyzer tool : tools) {
                tool.report();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Cannot open file " + filename);
        }
        catch (IOException e) {
            System.out.println("error reading from file " + filename);
        }
        catch (MissingDomainObject e) {
            System.out.println("MDO on " + line);
        }
    }

    public void readStateLog(String filename, Analyzer tool) {
        ArrayList<Analyzer> tools = new ArrayList<Analyzer>();
        tools.add(tool);
        this.readStateLog(filename, tools);
    }

    class SimEndHandler
    implements NewObjectListener {
        SimEndHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            LogtoolCore.this.simEnd = true;
        }
    }
}

