/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.logtool;

import org.powertac.logtool.LogtoolCore;
import org.powertac.logtool.common.DomainObjectReader;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.logtool.ifc.Analyzer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class LogtoolContext {
    ApplicationContext context;
    LogtoolCore core;

    protected void initialize() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("logtool.xml");
        ctx.registerShutdownHook();
        this.setContext((ApplicationContext)ctx);
    }

    protected void setContext(ApplicationContext context) {
        this.context = context;
        this.core = (LogtoolCore)context.getBeansOfType(LogtoolCore.class).values().toArray()[0];
    }

    protected ApplicationContext getContext() {
        return this.context;
    }

    protected LogtoolCore getCore() {
        if (this.context == null) {
            this.initialize();
        }
        return this.core;
    }

    protected Object getBean(String beanName) {
        return this.context.getBean(beanName);
    }

    protected void cli(String inputFile, Analyzer analyzer) {
        LogtoolCore core = this.getCore();
        core.readStateLog(inputFile, analyzer);
    }

    protected void registerNewObjectListener(NewObjectListener listener, Class<?> type) {
        DomainObjectReader dor = (DomainObjectReader)this.getBean("domainObjectReader");
        dor.registerNewObjectListener(listener, type);
    }
}

