/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.logtool.common;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Broker;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Rate;
import org.powertac.common.RateCore;
import org.powertac.common.TariffSpecification;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.OrderbookRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.logtool.common.DomainObjectReader;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.logtool.ifc.Analyzer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DomainBuilder
implements Analyzer {
    private static Logger log = LogManager.getLogger((String)DomainBuilder.class.getName());
    @Autowired
    private DomainObjectReader dor;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private OrderbookRepo orderbookRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    private HashMap<Long, ArrayList<Rate>> pendingRates = new HashMap();

    @Override
    public void setup() {
        this.dor.registerNewObjectListener(new BrokerHandler(), Broker.class);
        this.dor.registerNewObjectListener(new CustomerHandler(), CustomerInfo.class);
        this.dor.registerNewObjectListener(new TariffSpecHandler(), TariffSpecification.class);
        this.dor.registerNewObjectListener(new RateHandler(), Rate.class);
        this.dor.registerNewObjectListener(new TimeslotHandler(), Timeslot.class);
    }

    @Override
    public void report() {
    }

    class TimeslotHandler
    implements NewObjectListener {
        TimeslotHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            Timeslot timeslot = (Timeslot)thing;
            DomainBuilder.this.timeslotRepo.add(timeslot);
        }
    }

    class RateHandler
    implements NewObjectListener {
        RateHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            Rate rate = (Rate)thing;
            TariffSpecification spec = DomainBuilder.this.tariffRepo.findSpecificationById(rate.getTariffId());
            if (null != spec) {
                spec.addRate((RateCore)rate);
            } else {
                ArrayList<Rate> rates = (ArrayList<Rate>)DomainBuilder.this.pendingRates.get(rate.getTariffId());
                if (null == rates) {
                    rates = new ArrayList<Rate>();
                    DomainBuilder.this.pendingRates.put(rate.getTariffId(), rates);
                }
                rates.add(rate);
            }
        }
    }

    class TariffSpecHandler
    implements NewObjectListener {
        TariffSpecHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            TariffSpecification spec = (TariffSpecification)thing;
            ArrayList rates = (ArrayList)DomainBuilder.this.pendingRates.get(spec.getId());
            if (null != rates) {
                for (Rate rate : rates) {
                    spec.addRate((RateCore)rate);
                }
            }
            DomainBuilder.this.tariffRepo.addSpecification(spec);
        }
    }

    class CustomerHandler
    implements NewObjectListener {
        CustomerHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            CustomerInfo customer = (CustomerInfo)thing;
            DomainBuilder.this.customerRepo.add(customer);
        }
    }

    class BrokerHandler
    implements NewObjectListener {
        BrokerHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            Broker broker = (Broker)thing;
            log.info("add broker " + broker.getUsername());
            DomainBuilder.this.brokerRepo.add(broker);
        }
    }
}

