/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.logtool;

import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.logtool.LogtoolCore;
import org.powertac.logtool.common.DomainObjectReader;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.logtool.ifc.Analyzer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class LogtoolContext {
    static Logger log = LogManager.getLogger(LogtoolContext.class);
    ApplicationContext context;
    LogtoolCore core;
    DomainObjectReader dor;

    protected void initialize() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("logtool.xml");
        ctx.registerShutdownHook();
        this.setContext((ApplicationContext)ctx);
    }

    protected void setContext(ApplicationContext context) {
        if (this.context != null) {
            log.warn("Resetting application context!");
            log.debug("Current context " + this.context.getClass().getName());
            log.debug("New context " + context.getClass().getName());
        }
        this.context = context;
        this.registerMessageHandlers();
    }

    private void registerMessageHandlers() {
        Method[] methods;
        Class<?> thingClass = this.getClass();
        log.info("Analyzing class {}", (Object)thingClass.getName());
        for (Method method : methods = thingClass.getMethods()) {
            Class<?>[] args;
            if (!method.getName().equals("handleMessage") || 1 != (args = method.getParameterTypes()).length) continue;
            log.info("Register " + this.getClass().getSimpleName() + ".handleMessage(" + args[0].getSimpleName() + ")");
            this.registerMessageListener(args[0]);
        }
    }

    protected ApplicationContext getContext() {
        return this.context;
    }

    protected LogtoolCore getCore() {
        if (this.core == null) {
            this.core = (LogtoolCore)this.getBean("logtoolCore");
        }
        return this.core;
    }

    protected DomainObjectReader getDomainObjectReader() {
        if (this.dor == null) {
            this.dor = (DomainObjectReader)this.getBean("domainObjectReader");
        }
        return this.dor;
    }

    protected Object getBean(String beanName) {
        if (this.context == null) {
            this.initialize();
        }
        return this.context.getBean(beanName);
    }

    protected void cli(String inputFile, Analyzer analyzer) {
        LogtoolCore core = this.getCore();
        core.readStateLog(inputFile, analyzer);
    }

    protected void registerNewObjectListener(NewObjectListener listener, Class<?> type) {
        DomainObjectReader dor = this.getDomainObjectReader();
        dor.registerNewObjectListener(listener, type);
    }

    protected void registerMessageListener(Class<?> type) {
        DomainObjectReader dor = this.getDomainObjectReader();
        dor.registerMessageListener(this, type);
    }
}

