/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.logtool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.msg.SimEnd;
import org.powertac.logtool.common.DomainBuilder;
import org.powertac.logtool.common.DomainObjectReader;
import org.powertac.logtool.common.MissingDomainObject;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.logtool.ifc.Analyzer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogtoolCore {
    private static Logger log = LogManager.getLogger((String)LogtoolCore.class.getName());
    @Autowired
    private DomainObjectReader reader;
    @Autowired
    private DomainBuilder builder;
    private boolean simEnd = false;
    private boolean isInterrupted = false;
    private static CompressorStreamFactory compressFactory = new CompressorStreamFactory();
    private static ArchiveStreamFactory archiveFactory = new ArchiveStreamFactory();

    public String processCmdLine(String[] args) {
        if (args.length < 2) {
            return "Usage: Logtool file analyzer ...";
        }
        String source = args[0];
        Analyzer[] tools = new Analyzer[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            try {
                Class<?> toolClass = Class.forName(args[i]);
                tools[i - 1] = (Analyzer)toolClass.newInstance();
                continue;
            }
            catch (ClassNotFoundException e1) {
                return "Cannot find analyzer class " + args[i];
            }
            catch (Exception ex) {
                return "Exception creating analyzer " + ex.toString();
            }
        }
        return this.readStateLog(source, tools);
    }

    public String readStateLog(String source, Analyzer ... tools) {
        if (null == source || "-".equals(source)) {
            log.info("Reading from standard input");
            return this.readStateLog(System.in, tools);
        }
        try {
            URL inputURL = new URL(source);
            log.info("Reading url " + source);
            return this.readStateLog(inputURL, tools);
        }
        catch (MalformedURLException inputURL) {
            log.info("Reading file " + source);
            File inputFile = new File(source);
            if (!inputFile.canRead()) {
                return "Cannot read file " + source;
            }
            return this.readStateLog(inputFile, tools);
        }
    }

    public String readStateLog(File inputFile, Analyzer ... tools) {
        try {
            return this.readStateLog(new FileInputStream(inputFile), tools);
        }
        catch (FileNotFoundException e) {
            return "Cannot open file " + inputFile.getPath();
        }
    }

    public String readStateLog(URL inputURL, Analyzer ... tools) {
        try {
            return this.readStateLog(inputURL.openStream(), tools);
        }
        catch (IOException e) {
            return "Cannot open url " + inputURL.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStateLog(InputStream inputStream, Analyzer ... tools) {
        this.reader.registerNewObjectListener(new SimEndHandler(), SimEnd.class);
        String line = null;
        log.info("Reading state log from stream for {}", (Object)tools[0].getClass().getName());
        this.simEnd = false;
        this.isInterrupted = false;
        try {
            try {
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream((InputStream)inputStream);
                }
                inputStream = compressFactory.createCompressorInputStream((InputStream)inputStream);
            }
            catch (CompressorException compressorException) {
                // empty catch block
            }
            try {
                ArchiveEntry entry;
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream((InputStream)inputStream);
                }
                Analyzer[] archiveStream = archiveFactory.createArchiveInputStream((InputStream)inputStream);
                inputStream = null;
                while ((entry = archiveStream.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.startsWith("log/") || !name.endsWith(".state") || name.endsWith("init.state")) continue;
                    inputStream = archiveStream;
                    break;
                }
                if (inputStream == null) {
                    return "Cannot read archive, no valid state log entry";
                }
            }
            catch (ArchiveException archiveStream) {
                // empty catch block
            }
            InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream);
            this.builder.setup();
            for (Analyzer tool : tools) {
                log.info("Setting up {}", (Object)tool.getClass().getName());
                tool.setup();
            }
            BufferedReader in = new BufferedReader(inputReader);
            int lineNumber = 0;
            while (!this.simEnd) {
                LogtoolCore logtoolCore = this;
                synchronized (logtoolCore) {
                    if (this.isInterrupted) {
                        in.close();
                        break;
                    }
                }
                line = in.readLine();
                if (null == line) {
                    log.info("Last line " + lineNumber);
                    break;
                }
                ++lineNumber;
                this.reader.readObject(line);
            }
            this.builder.report();
            for (Analyzer tool : tools) {
                tool.report();
            }
        }
        catch (IOException e) {
            return "Error reading from stream";
        }
        catch (MissingDomainObject e) {
            return "MDO on " + line;
        }
        return null;
    }

    public synchronized void interrupt() {
        this.isInterrupted = true;
    }

    class SimEndHandler
    implements NewObjectListener {
        SimEndHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            LogtoolCore.this.simEnd = true;
        }
    }
}

