/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.logtool.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.TimeService;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.msg.BalanceReport;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimStart;
import org.powertac.common.state.Domain;
import org.powertac.common.xml.PowerTypeConverter;
import org.powertac.du.DefaultBroker;
import org.powertac.logtool.LogtoolContext;
import org.powertac.logtool.common.MissingDomainObject;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.util.MessageDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.ReflectionUtils;

@Service
public class DomainObjectReader {
    private static Logger log = LogManager.getLogger((String)DomainObjectReader.class.getName());
    @Autowired
    private TimeService timeService;
    HashMap<Long, Object> idMap;
    HashMap<Class<?>, Class<?>> ifImplementors;
    HashMap<String, Class<?>> substitutes;
    HashSet<String> ignores;
    HashSet<Class<?>> noIdTypes;
    PowerTypeConverter ptConverter = new PowerTypeConverter();
    HashMap<Class<?>, ArrayList<NewObjectListener>> newObjectListeners;
    HashMap<Class<?>, ArrayList<LogtoolContext>> messageListeners;

    public DomainObjectReader() {
        this.idMap = new HashMap();
        this.ifImplementors = new HashMap();
        this.ifImplementors.put(List.class, ArrayList.class);
        this.substitutes = new HashMap();
        this.substitutes.put("org.powertac.du.DefaultBrokerService$LocalBroker", DefaultBroker.class);
        this.ignores = new HashSet();
        this.ignores.add("org.powertac.common.Tariff");
        this.ignores.add("org.powertac.common.TariffSubscription");
        this.ignores.add("org.powertac.common.Rate$ProbeCharge");
        this.ignores.add("org.powertac.common.msg.SimPause");
        this.ignores.add("org.powertac.common.msg.SimResume");
        this.ignores.add("org.powertac.common.msg.PauseRequest");
        this.ignores.add("org.powertac.common.msg.PauseRelease");
        this.ignores.add("org.powertac.common.RandomSeed");
        this.ignores.add("org.powertac.factoredcustomer.DefaultUtilityOptimizer$DummyTariffSubscription");
        this.noIdTypes = new HashSet();
        this.noIdTypes.add(TimeService.class);
        this.noIdTypes.add(BalanceReport.class);
        this.noIdTypes.add(SimStart.class);
        this.noIdTypes.add(SimEnd.class);
        this.newObjectListeners = new HashMap();
        this.messageListeners = new HashMap();
    }

    public void registerNewObjectListener(NewObjectListener listener, Class<?> type) {
        ArrayList<NewObjectListener> list = this.newObjectListeners.get(type);
        if (null == list) {
            list = new ArrayList();
            this.newObjectListeners.put(type, list);
        }
        list.add(listener);
    }

    public void registerMessageListener(LogtoolContext listener, Class<?> type) {
        ArrayList<LogtoolContext> list = this.messageListeners.get(type);
        if (null == list) {
            list = new ArrayList();
            this.messageListeners.put(type, list);
        }
        list.add(listener);
    }

    public Object readObject(String line) throws MissingDomainObject {
        Class<?> clazz;
        log.debug("readObject(" + line + ")");
        String body = line.substring(line.indexOf(58) + 1);
        String[] tokens = body.split("::");
        if (this.ignores.contains(tokens[0])) {
            return null;
        }
        try {
            clazz = Class.forName(tokens[0]);
        }
        catch (ClassNotFoundException e) {
            Class<?> subst = this.substitutes.get(tokens[0]);
            if (null == subst) {
                log.warn("class " + tokens[0] + " not found");
                return null;
            }
            clazz = subst;
        }
        long id = -1L;
        try {
            id = Long.parseLong(tokens[1]);
        }
        catch (NumberFormatException nfe) {
            if (clazz == TimeService.class) {
                this.updateTime(tokens[3]);
                return null;
            }
            if (this.noIdTypes.contains(clazz)) {
                id = 0L;
            }
            log.debug("Number format exception reading id");
            return null;
        }
        String methodName = tokens[2];
        log.debug("methodName=" + methodName);
        if (methodName.equals("new")) {
            Object newInst = this.constructInstance(clazz, Arrays.copyOfRange(tokens, 3, tokens.length));
            if (null != newInst) {
                if (!this.noIdTypes.contains(clazz)) {
                    this.setId(newInst, id);
                    this.idMap.put(id, newInst);
                }
                log.debug("Created new instance " + id + " of class " + tokens[0]);
                this.fireNewObjectEvent(newInst);
            }
            return newInst;
        }
        if (methodName.equals("-rr")) {
            Object newInst = this.restoreInstance(clazz, Arrays.copyOfRange(tokens, 3, tokens.length));
            if (null != newInst) {
                this.setId(newInst, id);
                this.idMap.put(id, newInst);
                log.debug("Restored instance " + id + " of class " + tokens[0]);
                this.fireNewObjectEvent(newInst);
            }
            return newInst;
        }
        Object inst = this.idMap.get(id);
        if (null == inst) {
            log.warn("Cannot find instance for id " + id + " of type " + clazz.getCanonicalName());
            return null;
        }
        Method[] methods = clazz.getMethods();
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            candidates.add(method);
        }
        if (0 == candidates.size()) {
            log.error("Cannot find method " + methodName + " for class " + clazz.getName());
            return null;
        }
        if (1 == candidates.size()) {
            if (!this.tryMethodCall(inst, (Method)candidates.get(0), Arrays.copyOfRange(tokens, 3, tokens.length))) {
                log.error("Failed to invoke method " + methodName + " on instance of " + clazz.getName());
            }
        } else {
            Method candidate;
            boolean success = false;
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext() && !(success = this.tryMethodCall(inst, candidate = (Method)iterator.next(), Arrays.copyOfRange(tokens, 3, tokens.length)))) {
            }
            if (!success) {
                log.error("Failed to find viable candidate for " + methodName + " on instance of " + clazz.getName());
            }
        }
        return null;
    }

    public Object getById(long id) {
        return this.idMap.get(id);
    }

    private void updateTime(String time) {
        Instant value = Instant.parse((String)time);
        this.timeService.setCurrentTime(value);
        log.debug("time set to " + time);
    }

    private void fireNewObjectEvent(Object thing) {
        this.dispatchNewObjectListeners(thing);
        this.dispatchMessageListeners(thing);
    }

    private void dispatchNewObjectListeners(Object thing) {
        ArrayList<NewObjectListener> listeners = this.newObjectListeners.get(thing.getClass());
        if (null == listeners) {
            listeners = this.newObjectListeners.get(thing.getClass().getSuperclass());
        }
        if (null != listeners) {
            for (NewObjectListener li : listeners) {
                li.handleNewObject(thing);
            }
        }
        if (null != (listeners = this.newObjectListeners.get(null))) {
            for (NewObjectListener li : listeners) {
                li.handleNewObject(thing);
            }
        }
    }

    private void dispatchMessageListeners(Object thing) {
        ArrayList<LogtoolContext> listeners = this.messageListeners.get(thing.getClass());
        if (null != listeners) {
            for (LogtoolContext target : listeners) {
                MessageDispatcher.dispatch((Object)target, (String)"handleMessage", (Object[])new Object[]{thing});
            }
        }
    }

    private Object constructInstance(Class<?> clazz, String[] args) throws MissingDomainObject {
        Constructor<?>[] potentials = clazz.getDeclaredConstructors();
        Constructor<?> target = null;
        Object[] params = null;
        for (Constructor<?> cons : potentials) {
            Type[] types = cons.getGenericParameterTypes();
            if (types.length != args.length) continue;
            try {
                params = this.resolveArgs(types, args);
            }
            catch (MissingDomainObject missingDomainObject) {
                // empty catch block
            }
            if (null == params) continue;
            target = cons;
            break;
        }
        if (null != target) {
            Object result = null;
            try {
                target.setAccessible(true);
                result = target.newInstance(params);
            }
            catch (InvocationTargetException ite) {
                return this.restoreInstance(clazz, args);
            }
            catch (Exception e) {
                log.error("could not construct instance of " + clazz.getName() + ": " + e.toString());
                return null;
            }
            return result;
        }
        return this.restoreInstance(clazz, args);
    }

    private Object restoreInstance(Class<?> clazz, String[] args) throws MissingDomainObject {
        Domain domain = clazz.getAnnotation(Domain.class);
        if (domain instanceof Domain) {
            Object[] data;
            Object thing = null;
            try {
                Constructor<?> cons = clazz.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                thing = cons.newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.warn("No default constructor for " + clazz.getName() + ": " + e.toString());
                return null;
            }
            String[] fieldNames = domain.fields();
            Field[] fields = new Field[fieldNames.length];
            Type[] types = new Class[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                fields[i] = ReflectionUtils.findField(clazz, (String)this.resolveDoubleCaps(fieldNames[i]));
                if (null == fields[i]) {
                    log.warn("No field in " + clazz.getName() + " named " + fieldNames[i]);
                    types[i] = null;
                    continue;
                }
                types[i] = fields[i].getType();
            }
            if (types.length != args.length) {
                log.error("RR arg mismatch class {}, {} fields, args {}", (Object)clazz.getName(), (Object)fields.length, (Object)args);
            }
            if (null == (data = this.resolveArgs(types, args))) {
                log.error("Could not resolve args for " + clazz.getName());
                return null;
            }
            for (int i = 0; i < fields.length; ++i) {
                if (null == fields[i]) continue;
                fields[i].setAccessible(true);
                try {
                    fields[i].set(thing, data[i]);
                    continue;
                }
                catch (Exception e) {
                    log.error("Exception setting field: " + e.toString());
                    return null;
                }
            }
            return thing;
        }
        return null;
    }

    private String resolveDoubleCaps(String name) {
        if (Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return String.valueOf(chars);
        }
        return name;
    }

    private boolean tryMethodCall(Object thing, Method method, String[] args) {
        Object[] realArgs;
        Type[] argTypes = method.getGenericParameterTypes();
        if (argTypes.length != args.length) {
            return false;
        }
        if (0 == argTypes.length) {
            realArgs = null;
        } else {
            try {
                realArgs = this.resolveArgs(argTypes, args);
                if (null == realArgs || realArgs.length != args.length) {
                    log.debug("Could not resolve args: method " + method.getName() + ", class = " + thing.getClass().getName() + ", args = " + args);
                    return false;
                }
            }
            catch (MissingDomainObject mdo) {
                return false;
            }
        }
        try {
            method.invoke(thing, realArgs);
            return true;
        }
        catch (Exception e) {
            log.error("Exception calling method " + thing.getClass().getName() + "." + method.getName() + " on args " + realArgs);
            return false;
        }
    }

    private Object[] resolveArgs(Type[] types, String[] args) throws MissingDomainObject {
        Object[] result = new Object[types.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.resolveArg(types[i], args[i]);
        }
        return result;
    }

    private Object resolveArg(Type type, String arg) throws MissingDomainObject {
        if (null == type) {
            return null;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isEnum()) {
                return Enum.valueOf((Class)type, arg);
            }
            if (PowerType.class == clazz) {
                return this.ptConverter.fromString(arg);
            }
            return this.resolveSimpleArg(clazz, arg);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Class<?> clazz = (Class<?>)ptype.getRawType();
            boolean isCollection = false;
            if (clazz.equals(Collection.class)) {
                isCollection = true;
            } else {
                Class<?>[] ifs;
                for (Class<?> ifc : ifs = clazz.getInterfaces()) {
                    if (!ifc.equals(Collection.class)) continue;
                    isCollection = true;
                    break;
                }
            }
            if (isCollection) {
                log.debug("processing collection " + clazz.getName());
                if (arg.charAt(0) != '(') {
                    log.error("Collection arg " + arg + " does not start with paren");
                    return null;
                }
                Type[] tas = ptype.getActualTypeArguments();
                if (1 == tas.length) {
                    String[] items;
                    Collection coll;
                    Class argClazz = (Class)tas[0];
                    if (clazz.isInterface()) {
                        clazz = this.ifImplementors.get(clazz);
                    }
                    try {
                        coll = (Collection)clazz.newInstance();
                    }
                    catch (Exception e) {
                        log.error("Exception creating collection: " + e.toString());
                        return null;
                    }
                    String body = arg.substring(1, arg.indexOf(41));
                    for (String item : items = body.split(",")) {
                        coll.add(this.resolveSimpleArg(argClazz, item));
                    }
                    return coll;
                }
            }
        }
        log.error("unresolved arg: type = " + type + ", arg = " + arg);
        return null;
    }

    private Object resolveSimpleArg(Class<?> clazz, String arg) throws MissingDomainObject {
        if (arg.equals("null")) {
            return null;
        }
        if (clazz.getName().startsWith("org.powertac")) {
            try {
                Method getId = clazz.getMethod("getId", new Class[0]);
                if (getId.getReturnType() == Long.TYPE) {
                    Long key = Long.parseLong(arg);
                    Object value = this.idMap.get(key);
                    if (null != value && clazz.isAssignableFrom(value.getClass())) {
                        return value;
                    }
                    throw new MissingDomainObject("missing object id=" + key);
                }
            }
            catch (SecurityException e) {
                log.error("Exception on getId(): " + e.toString());
                return null;
            }
            catch (NoSuchMethodException e) {
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (clazz.getName().equals("boolean")) {
            boolean value = Boolean.parseBoolean(arg);
            if (value) {
                return true;
            }
            if (arg.equalsIgnoreCase("false")) {
                return false;
            }
            return null;
        }
        if (clazz.getName().equals("long")) {
            try {
                long value = Long.parseLong(arg);
                return value;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (clazz.getName().equals("int")) {
            try {
                int value = Integer.parseInt(arg);
                return value;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (clazz.getName().equals("double") || clazz == Double.class) {
            try {
                double value = Double.parseDouble(arg);
                return value;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (clazz.getName() == "java.lang.Double") {
            // empty if block
        }
        if (clazz.getName() == "org.joda.time.Instant") {
            try {
                Instant value = Instant.parse((String)arg);
                return value;
            }
            catch (IllegalArgumentException iae) {
                try {
                    Long msec = Long.parseLong(arg);
                    return new Instant((Object)msec);
                }
                catch (Exception e) {
                    log.error("could not parse Long " + arg);
                    return null;
                }
            }
            catch (Exception e) {
                log.error("could not parse Instant " + arg);
                return null;
            }
        }
        try {
            Constructor<?> cons = clazz.getConstructor(String.class);
            return cons.newInstance(arg);
        }
        catch (NoSuchMethodException cons) {
        }
        catch (Exception e) {
            log.error("Exception looking up constructor for " + clazz.getName() + ": " + e.toString());
            return null;
        }
        return null;
    }

    private void setId(Object thing, Long id) {
        Class<?> clazz = thing.getClass();
        try {
            Method setId = clazz.getMethod("setId", Long.TYPE);
            setId.setAccessible(true);
            setId.invoke(thing, (long)id);
        }
        catch (SecurityException e) {
            log.error("Exception on setId(): " + e.toString());
        }
        catch (NoSuchMethodException e) {
            ReflectionTestUtils.setField((Object)thing, (String)"id", (Object)id);
        }
        catch (Exception e) {
            log.error("Error setting id value " + e.toString());
        }
    }

    class WrongArgType
    extends Exception {
        private static final long serialVersionUID = 7044658729956229376L;

        WrongArgType() {
        }
    }
}

