/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.logtool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.msg.SimEnd;
import org.powertac.common.msg.SimStart;
import org.powertac.common.repo.DomainRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.logtool.common.DomainBuilder;
import org.powertac.logtool.common.DomainObjectReader;
import org.powertac.logtool.common.MissingDomainObject;
import org.powertac.logtool.common.NewObjectListener;
import org.powertac.logtool.ifc.Analyzer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogtoolCore {
    private static Logger log = LogManager.getLogger((String)LogtoolCore.class.getName());
    @Autowired
    private DomainObjectReader reader;
    @Autowired
    private DomainBuilder builder;
    private boolean simEnd = false;
    private boolean isInterrupted = false;
    private static CompressorStreamFactory compressFactory = new CompressorStreamFactory();
    private static ArchiveStreamFactory archiveFactory = new ArchiveStreamFactory();

    @PostConstruct
    public void postConstruct() {
        this.reader.registerNewObjectListener(new SimStartHandler(), SimStart.class);
        this.reader.registerNewObjectListener(new SimEndHandler(), SimEnd.class);
        this.builder.setup();
    }

    public void setPerTimeslotPause(int msec) {
        this.reader.setTimeslotPause(msec);
    }

    public String processCmdLine(String[] args) {
        if (args.length < 2) {
            return "Usage: Logtool file analyzer ...";
        }
        String source = args[0];
        Analyzer[] tools = new Analyzer[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            try {
                Class<?> toolClass = Class.forName(args[i]);
                tools[i - 1] = (Analyzer)toolClass.newInstance();
                continue;
            }
            catch (ClassNotFoundException e1) {
                return "Cannot find analyzer class " + args[i];
            }
            catch (Exception ex) {
                return "Exception creating analyzer " + ex.toString();
            }
        }
        return this.readStateLog(source, tools);
    }

    public String readStateLog(String source, Analyzer ... tools) {
        if (null == source || "-".equals(source)) {
            log.info("Reading from standard input");
            return this.readStateLog(System.in, tools);
        }
        try {
            URL inputURL = new URL(source);
            log.info("Reading url " + source);
            return this.readStateLog(inputURL, tools);
        }
        catch (MalformedURLException inputURL) {
            log.info("Reading file " + source);
            File inputFile = new File(source);
            if (!inputFile.canRead()) {
                return "Cannot read file " + source;
            }
            return this.readStateLog(inputFile, tools);
        }
    }

    public String readStateLog(File inputFile, Analyzer ... tools) {
        try {
            return this.readStateLog(new FileInputStream(inputFile), tools);
        }
        catch (FileNotFoundException e) {
            return "Cannot open file " + inputFile.getPath();
        }
    }

    public String readStateLog(URL inputURL, Analyzer ... tools) {
        try {
            return this.readStateLog(inputURL.openStream(), tools);
        }
        catch (IOException e) {
            return "Cannot open url " + inputURL.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStateLog(InputStream inputStream, Analyzer ... tools) {
        String line = null;
        log.info("Reading state log from stream for {}", (Object)tools[0].getClass().getName());
        this.simEnd = false;
        this.isInterrupted = false;
        try {
            try {
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                inputStream = compressFactory.createCompressorInputStream(inputStream);
            }
            catch (CompressorException compressorException) {
                // empty catch block
            }
            try {
                Analyzer[] entry;
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                ArchiveInputStream archiveStream = archiveFactory.createArchiveInputStream(inputStream);
                inputStream = null;
                while ((entry = archiveStream.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.startsWith("log/") || !name.endsWith(".state") || name.endsWith("init.state")) continue;
                    inputStream = archiveStream;
                    break;
                }
                if (inputStream == null) {
                    return "Cannot read archive, no valid state log entry";
                }
            }
            catch (ArchiveException archiveStream) {
                // empty catch block
            }
            List repos = SpringApplicationContext.listBeansOfType(DomainRepo.class);
            for (DomainRepo repo : repos) {
                repo.recycle();
            }
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            for (Analyzer tool : tools) {
                log.info("Setting up {}", (Object)tool.getClass().getName());
                tool.setup();
            }
            BufferedReader in = new BufferedReader(inputReader);
            this.reader.setSchema(this.extractSchema(in));
            int lineNumber = 0;
            while (!this.simEnd) {
                LogtoolCore logtoolCore = this;
                synchronized (logtoolCore) {
                    if (this.isInterrupted) {
                        in.close();
                        break;
                    }
                }
                line = in.readLine();
                if (null == line) {
                    log.info("Last line " + lineNumber);
                    break;
                }
                ++lineNumber;
                this.reader.readObject(line);
            }
            this.builder.report();
            for (Analyzer tool : tools) {
                tool.report();
            }
        }
        catch (IOException e) {
            return "Error reading from stream";
        }
        catch (MissingDomainObject e) {
            return "MDO on " + line;
        }
        return null;
    }

    public synchronized void interrupt() {
        this.isInterrupted = true;
    }

    private HashMap<String, String[]> extractSchema(BufferedReader input) throws IOException {
        String[] tokens;
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        BufferedReader schema = input;
        int offset = 1;
        schema.mark(64);
        String line = schema.readLine();
        if (line.indexOf("Domain-schema") == -1) {
            schema.reset();
            InputStream defaultStream = Competition.class.getClassLoader().getResourceAsStream("metadata/domain-default.schema");
            schema = new BufferedReader(new InputStreamReader(defaultStream));
            offset = 0;
        }
        if (!(line = schema.readLine()).startsWith("Domain-schema")) {
            log.error("Bad default schema: {}", (Object)line);
            return result;
        }
        while (null != (line = schema.readLine()) && !(tokens = line.split(":"))[offset].startsWith("schema.end")) {
            result.put(tokens[offset], tokens[offset + 1].split(","));
        }
        return result;
    }

    class SimEndHandler
    implements NewObjectListener {
        SimEndHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
            LogtoolCore.this.simEnd = true;
        }
    }

    class SimStartHandler
    implements NewObjectListener {
        SimStartHandler() {
        }

        @Override
        public void handleNewObject(Object thing) {
        }
    }
}

