/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.customers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.AbstractCustomer;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherReport;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.Office;
import org.springframework.beans.factory.annotation.Autowired;

public class OfficeComplex
extends AbstractCustomer {
    protected static Logger log = Logger.getLogger((String)OfficeComplex.class.getName());
    @Autowired
    TimeService timeService;
    @Autowired
    TimeslotRepo timeslotRepo;
    @Autowired
    WeatherReportRepo weatherReportRepo;
    Vector<Vector<Long>> aggDailyBaseLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyBaseLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyBaseLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyBaseLoadInHoursSS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadInHoursSS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadInHoursSS = new Vector();
    Vector<Integer> daysList = new Vector();
    Random gen;
    HashMap<String, TariffSubscription> subscriptionMap = new HashMap();
    HashMap<String, TariffSubscription> controllableSubscriptionMap = new HashMap();
    HashMap<String, Double> inertiaMap = new HashMap();
    HashMap<String, Integer> periodMap = new HashMap();
    HashMap<String, Double> lamdaMap = new HashMap();
    Vector<Office> notShiftingoffices = new Vector();
    Vector<Office> smartShiftingoffices = new Vector();

    public OfficeComplex(String name) {
        super(name);
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.timeService = (TimeService)SpringApplicationContext.getBean((String)"timeService");
        this.weatherReportRepo = (WeatherReportRepo)SpringApplicationContext.getBean((String)"weatherReportRepo");
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("NS");
        typeList.add("SS");
        for (String type : typeList) {
            this.subscriptionMap.put(type, null);
            this.controllableSubscriptionMap.put(type, null);
            this.inertiaMap.put(type, null);
            this.periodMap.put(type, null);
            this.lamdaMap.put(type, null);
        }
    }

    public OfficeComplex(String name, ArrayList<CustomerInfo> customerInfo) {
        super(name, customerInfo);
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.timeService = (TimeService)SpringApplicationContext.getBean((String)"timeService");
        this.weatherReportRepo = (WeatherReportRepo)SpringApplicationContext.getBean((String)"weatherReportRepo");
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("NS");
        typeList.add("SS");
        for (String type : typeList) {
            this.subscriptionMap.put(type, null);
            this.controllableSubscriptionMap.put(type, null);
            this.inertiaMap.put(type, null);
            this.periodMap.put(type, null);
            this.lamdaMap.put(type, null);
        }
    }

    public void initialize(Properties conf, Random generator) {
        int i;
        int nsoffices = Integer.parseInt(conf.getProperty("NotShiftingCustomers"));
        int ssoffices = Integer.parseInt(conf.getProperty("SmartShiftingCustomers"));
        int days = Integer.parseInt(conf.getProperty("PublicVacationDuration"));
        this.gen = generator;
        this.createCostEstimationDaysList(3);
        Vector<Integer> publicVacationVector = this.createPublicVacationVector(days);
        for (i = 0; i < nsoffices; ++i) {
            log.info((Object)("Initializing " + this.toString() + " NSoffice " + i));
            Office of = new Office();
            of.initialize(this.toString() + " NSoffice" + i, conf, publicVacationVector, this.gen);
            this.notShiftingoffices.add(of);
            of.officeOf = this;
        }
        for (i = 0; i < ssoffices; ++i) {
            log.info((Object)("Initializing " + this.toString() + " SSoffice " + i));
            Office hh = new Office();
            hh.initialize(this.toString() + " SSoffice" + i, conf, publicVacationVector, this.gen);
            this.smartShiftingoffices.add(hh);
            hh.officeOf = this;
        }
        for (String type : this.subscriptionMap.keySet()) {
            this.fillAggWeeklyLoad(type);
            this.inertiaMap.put(type, Double.parseDouble(conf.getProperty(type + "Inertia")));
            this.periodMap.put(type, Integer.parseInt(conf.getProperty(type + "Period")));
            this.lamdaMap.put(type, Double.parseDouble(conf.getProperty(type + "Lamda")));
        }
    }

    public void subscribeDefault() {
        super.subscribeDefault();
        for (CustomerInfo customer : this.customerInfos) {
            List subscriptions;
            if (customer.getPowerType() == PowerType.INTERRUPTIBLE_CONSUMPTION && this.tariffMarketService.getDefaultTariff(PowerType.INTERRUPTIBLE_CONSUMPTION) == null) {
                log.debug((Object)("No Default Tariff for INTERRUPTIBLE_CONSUMPTION so the customer " + customer.toString() + " subscribe to CONSUMPTION Default Tariff instead"));
                this.tariffMarketService.subscribeToTariff(this.tariffMarketService.getDefaultTariff(PowerType.CONSUMPTION), customer, customer.getPopulation());
                log.info((Object)("CustomerInfo of type INTERRUPTIBLE_CONSUMPTION of " + this.toString() + " was subscribed to the default CONSUMPTION tariff successfully."));
            }
            if ((subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(customer)).size() <= 0) continue;
            log.debug((Object)subscriptions.toString());
            for (String type : this.subscriptionMap.keySet()) {
                if (customer.getPowerType() == PowerType.CONSUMPTION) {
                    this.subscriptionMap.put(type, (TariffSubscription)subscriptions.get(0));
                    continue;
                }
                if (customer.getPowerType() != PowerType.INTERRUPTIBLE_CONSUMPTION) continue;
                this.controllableSubscriptionMap.put(type, (TariffSubscription)subscriptions.get(0));
            }
        }
        log.debug((Object)("Base Load Subscriptions:" + this.subscriptionMap.toString()));
        log.debug((Object)("Controllable Load Subscriptions:" + this.controllableSubscriptionMap.toString()));
    }

    public void changeSubscription(Tariff tariff, CustomerInfo customer) {
        TariffSubscription ts = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(tariff, customer);
        int populationCount = ts.getCustomersCommitted();
        this.unsubscribe(ts, populationCount);
        Tariff newTariff = customer.getPowerType() == PowerType.INTERRUPTIBLE_CONSUMPTION && this.tariffMarketService.getActiveTariffList(PowerType.INTERRUPTIBLE_CONSUMPTION).size() > 1 ? this.selectTariff(PowerType.INTERRUPTIBLE_CONSUMPTION) : this.selectTariff(PowerType.CONSUMPTION);
        this.subscribe(newTariff, populationCount, customer);
        this.updateSubscriptions(tariff, newTariff, customer);
    }

    public void changeSubscription(Tariff tariff, String type, CustomerInfo customer) {
        TariffSubscription ts = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(tariff, customer);
        int populationCount = this.getOffices(type).size();
        this.unsubscribe(ts, populationCount);
        Tariff newTariff = customer.getPowerType() == PowerType.INTERRUPTIBLE_CONSUMPTION && this.tariffMarketService.getActiveTariffList(PowerType.INTERRUPTIBLE_CONSUMPTION).size() > 1 ? this.selectTariff(PowerType.INTERRUPTIBLE_CONSUMPTION) : this.selectTariff(PowerType.CONSUMPTION);
        this.subscribe(newTariff, populationCount, customer);
        this.updateSubscriptions(tariff, newTariff, type, customer);
    }

    public void changeSubscription(Tariff tariff, Tariff newTariff, CustomerInfo customer) {
        TariffSubscription ts = this.tariffSubscriptionRepo.getSubscription(customer, tariff);
        int populationCount = ts.getCustomersCommitted();
        this.unsubscribe(ts, populationCount);
        this.subscribe(newTariff, populationCount, customer);
        this.updateSubscriptions(tariff, newTariff, customer);
    }

    public void changeSubscription(Tariff tariff, Tariff newTariff, String type, CustomerInfo customer) {
        TariffSubscription ts = this.tariffSubscriptionRepo.getSubscription(customer, tariff);
        int populationCount = this.getOffices(type).size();
        this.unsubscribe(ts, populationCount);
        this.subscribe(newTariff, populationCount, customer);
        this.updateSubscriptions(tariff, newTariff, type, customer);
    }

    private void updateSubscriptions(Tariff tariff, Tariff newTariff, CustomerInfo customer) {
        TariffSubscription ts = this.tariffSubscriptionRepo.getSubscription(customer, tariff);
        TariffSubscription newTs = this.tariffSubscriptionRepo.getSubscription(customer, newTariff);
        boolean controllable = customer.getPowerType() == PowerType.INTERRUPTIBLE_CONSUMPTION;
        log.debug((Object)(this.toString() + " Changing"));
        log.debug((Object)("Old:" + ts.toString() + "  New:" + newTs.toString()));
        if (controllable) {
            if (this.controllableSubscriptionMap.get("NS") == ts || this.controllableSubscriptionMap.get("NS") == null) {
                this.controllableSubscriptionMap.put("NS", newTs);
            }
            if (this.controllableSubscriptionMap.get("RaS") == ts || this.controllableSubscriptionMap.get("RaS") == null) {
                this.controllableSubscriptionMap.put("RaS", newTs);
            }
            if (this.controllableSubscriptionMap.get("ReS") == ts || this.controllableSubscriptionMap.get("ReS") == null) {
                this.controllableSubscriptionMap.put("ReS", newTs);
            }
            if (this.controllableSubscriptionMap.get("SS") == ts || this.controllableSubscriptionMap.get("SS") == null) {
                this.controllableSubscriptionMap.put("SS", newTs);
            }
            log.debug((Object)("Controllable Subscription Map: " + this.controllableSubscriptionMap.toString()));
        } else {
            if (this.subscriptionMap.get("NS") == ts || this.subscriptionMap.get("NS") == null) {
                this.subscriptionMap.put("NS", newTs);
            }
            if (this.subscriptionMap.get("RaS") == ts || this.subscriptionMap.get("RaS") == null) {
                this.subscriptionMap.put("RaS", newTs);
            }
            if (this.subscriptionMap.get("ReS") == ts || this.subscriptionMap.get("ReS") == null) {
                this.subscriptionMap.put("ReS", newTs);
            }
            if (this.subscriptionMap.get("SS") == ts || this.subscriptionMap.get("SS") == null) {
                this.subscriptionMap.put("SS", newTs);
            }
            log.debug((Object)("Subscription Map: " + this.subscriptionMap.toString()));
        }
    }

    private void updateSubscriptions(Tariff tariff, Tariff newTariff, String type, CustomerInfo customer) {
        TariffSubscription ts = this.tariffSubscriptionRepo.getSubscription(customer, tariff);
        TariffSubscription newTs = this.tariffSubscriptionRepo.getSubscription(customer, newTariff);
        boolean controllable = customer.getPowerType() == PowerType.INTERRUPTIBLE_CONSUMPTION;
        log.debug((Object)(this.toString() + " Changing Only " + type));
        log.debug((Object)("Old:" + ts.toString() + "  New:" + newTs.toString()));
        if (controllable) {
            log.debug((Object)"For Controllable");
            if (type.equals("NS")) {
                this.controllableSubscriptionMap.put("NS", newTs);
            } else if (type.equals("RaS")) {
                this.controllableSubscriptionMap.put("RaS", newTs);
            } else if (type.equals("ReS")) {
                this.controllableSubscriptionMap.put("ReS", newTs);
            } else {
                this.controllableSubscriptionMap.put("SS", newTs);
            }
            log.debug((Object)("Controllable Subscription Map: " + this.controllableSubscriptionMap.toString()));
        } else {
            if (type.equals("NS")) {
                this.subscriptionMap.put("NS", newTs);
            } else if (type.equals("RaS")) {
                this.subscriptionMap.put("RaS", newTs);
            } else if (type.equals("ReS")) {
                this.subscriptionMap.put("ReS", newTs);
            } else {
                this.subscriptionMap.put("SS", newTs);
            }
            log.debug((Object)("Subscription Map: " + this.subscriptionMap.toString()));
        }
    }

    public void checkRevokedSubscriptions() {
        for (CustomerInfo customer : this.customerInfos) {
            List revoked = this.tariffSubscriptionRepo.getRevokedSubscriptionList(customer);
            log.debug((Object)revoked.toString());
            for (TariffSubscription revokedSubscription : revoked) {
                revokedSubscription.handleRevokedTariff();
                Tariff tariff = revokedSubscription.getTariff();
                Tariff newTariff = revokedSubscription.getTariff().getIsSupersededBy();
                Tariff defaultTariff = this.tariffMarketService.getDefaultTariff(PowerType.CONSUMPTION);
                log.debug((Object)("Tariff:" + tariff.toString() + " PowerType: " + tariff.getPowerType()));
                if (newTariff != null) {
                    log.debug((Object)("New Tariff:" + newTariff.toString()));
                } else {
                    log.debug((Object)"New Tariff is Null");
                    log.debug((Object)("Default Tariff:" + defaultTariff.toString()));
                }
                if (newTariff == null) {
                    this.updateSubscriptions(tariff, defaultTariff, customer);
                    continue;
                }
                this.updateSubscriptions(tariff, newTariff, customer);
            }
        }
    }

    void fillAggWeeklyLoad(String type) {
        if (type.equals("NS")) {
            for (int i = 0; i < 7 * (OfficeComplexConstants.WEEKS_OF_COMPETITION + 2); ++i) {
                this.aggDailyBaseLoadNS.add(this.fillAggDailyBaseLoad(i, type));
                this.aggDailyControllableLoadNS.add(this.fillAggDailyControllableLoad(i, type));
                this.aggDailyWeatherSensitiveLoadNS.add(this.fillAggDailyWeatherSensitiveLoad(i, type));
                this.aggDailyBaseLoadInHoursNS.add(this.fillAggDailyBaseLoadInHours(i, type));
                this.aggDailyControllableLoadInHoursNS.add(this.fillAggDailyControllableLoadInHours(i, type));
                this.aggDailyWeatherSensitiveLoadInHoursNS.add(this.fillAggDailyWeatherSensitiveLoadInHours(i, type));
            }
        } else {
            for (int i = 0; i < 7 * (OfficeComplexConstants.WEEKS_OF_COMPETITION + 2); ++i) {
                this.aggDailyBaseLoadSS.add(this.fillAggDailyBaseLoad(i, type));
                this.aggDailyControllableLoadSS.add(this.fillAggDailyControllableLoad(i, type));
                this.aggDailyWeatherSensitiveLoadSS.add(this.fillAggDailyWeatherSensitiveLoad(i, type));
                this.aggDailyBaseLoadInHoursSS.add(this.fillAggDailyBaseLoadInHours(i, type));
                this.aggDailyControllableLoadInHoursSS.add(this.fillAggDailyControllableLoadInHours(i, type));
                this.aggDailyWeatherSensitiveLoadInHoursSS.add(this.fillAggDailyWeatherSensitiveLoadInHours(i, type));
            }
        }
    }

    void updateAggDailyWeatherSensitiveLoad(String type, int day) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        if (type.equals("NS")) {
            this.aggDailyWeatherSensitiveLoadNS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoad(dayTemp, type));
            this.aggDailyWeatherSensitiveLoadInHoursNS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoadInHours(dayTemp, type));
        } else {
            this.aggDailyWeatherSensitiveLoadSS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoad(dayTemp, type));
            this.aggDailyWeatherSensitiveLoadInHoursSS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoadInHours(dayTemp, type));
        }
    }

    Vector<Long> fillAggDailyBaseLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingoffices : this.smartShiftingoffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyBaseLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyControllableLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingoffices : this.smartShiftingoffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyControllableLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyWeatherSensitiveLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingoffices : this.smartShiftingoffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyWeatherSensitiveLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyBaseLoadInHours(int day, String type) {
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyBaseLoadNS.get(day).get(i * 4) + this.aggDailyBaseLoadNS.get(day).get(i * 4 + 1) + this.aggDailyBaseLoadNS.get(day).get(i * 4 + 2) + this.aggDailyBaseLoadNS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyBaseLoadSS.get(day).get(i * 4) + this.aggDailyBaseLoadSS.get(day).get(i * 4 + 1) + this.aggDailyBaseLoadSS.get(day).get(i * 4 + 2) + this.aggDailyBaseLoadSS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    Vector<Long> fillAggDailyControllableLoadInHours(int day, String type) {
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyControllableLoadNS.get(day).get(i * 4) + this.aggDailyControllableLoadNS.get(day).get(i * 4 + 1) + this.aggDailyControllableLoadNS.get(day).get(i * 4 + 2) + this.aggDailyControllableLoadNS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyControllableLoadSS.get(day).get(i * 4) + this.aggDailyControllableLoadSS.get(day).get(i * 4 + 1) + this.aggDailyControllableLoadSS.get(day).get(i * 4 + 2) + this.aggDailyControllableLoadSS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    Vector<Long> fillAggDailyWeatherSensitiveLoadInHours(int day, String type) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4) + this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4 + 1) + this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4 + 2) + this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4) + this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4 + 1) + this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4 + 2) + this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    void showAggLoad(String type) {
        log.info((Object)("Portion " + type + " Weekly Aggregated Load"));
        if (type.equals("NS")) {
            for (int i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
                log.debug((Object)("Day " + i));
                for (int j = 0; j < 24; ++j) {
                    log.debug((Object)("Hour : " + j + " Base Load : " + this.aggDailyBaseLoadInHoursNS.get(i).get(j) + " Controllable Load: " + this.aggDailyControllableLoadInHoursNS.get(i).get(j) + " Weather Sensitive Load: " + this.aggDailyWeatherSensitiveLoadInHoursNS.get(i).get(j)));
                }
            }
        } else {
            for (int i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
                log.debug((Object)("Day " + i));
                for (int j = 0; j < 24; ++j) {
                    log.debug((Object)("Hour : " + j + " Base Load : " + this.aggDailyBaseLoadInHoursSS.get(i).get(j) + " Controllable Load: " + this.aggDailyControllableLoadInHoursSS.get(i).get(j) + " Weather Sensitive Load: " + this.aggDailyWeatherSensitiveLoadInHoursSS.get(i).get(j)));
                }
            }
        }
    }

    public void showAggDailyLoad(String type, int day) {
        log.debug((Object)("Portion " + type + " Daily Aggregated Load"));
        log.debug((Object)("Day " + day));
        if (type.equals("NS")) {
            for (int j = 0; j < 24; ++j) {
                log.debug((Object)("Hour : " + j + " Base Load : " + this.aggDailyBaseLoadInHoursNS.get(day).get(j) + " Controllable Load: " + this.aggDailyControllableLoadInHoursNS.get(day).get(j) + " Weather Sensitive Load: " + this.aggDailyWeatherSensitiveLoadInHoursNS.get(day).get(j)));
            }
        } else {
            for (int j = 0; j < 24; ++j) {
                log.debug((Object)("Hour : " + j + " Base Load : " + this.aggDailyBaseLoadInHoursSS.get(day).get(j) + " Controllable Load: " + this.aggDailyControllableLoadInHoursSS.get(day).get(j) + " Weather Sensitive Load: " + this.aggDailyWeatherSensitiveLoadInHoursSS.get(day).get(j)));
            }
        }
    }

    public void consumePower() {
        Timeslot ts = this.timeslotRepo.currentTimeslot();
        double summary = 0.0;
        double summaryControllable = 0.0;
        for (String type : this.subscriptionMap.keySet()) {
            TariffSubscription sub = this.subscriptionMap.get(type);
            TariffSubscription sub2 = this.controllableSubscriptionMap.get(type);
            if (ts == null) {
                log.debug((Object)"Current timeslot is null");
                int serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
                summary = this.getConsumptionByTimeslot(serial, type, false);
                summaryControllable = this.getConsumptionByTimeslot(serial, type, true);
            } else {
                summary = this.getConsumptionByTimeslot(ts.getSerialNumber(), type, false);
                summaryControllable = this.getConsumptionByTimeslot(ts.getSerialNumber(), type, true);
            }
            log.debug((Object)("Consumption Load for " + type + ": Base Load " + summary + " Controllable Load " + summaryControllable));
            if (sub.getCustomersCommitted() > 0) {
                sub.usePower(summary);
            }
            if (sub2.getCustomersCommitted() <= 0) continue;
            sub2.usePower(summaryControllable);
        }
    }

    double getConsumptionByTimeslot(int serial, String type, boolean controllable) {
        int day = serial / 24;
        int hour = serial % 24;
        long summary = 0L;
        log.debug((Object)("Serial : " + serial + " Day: " + day + " Hour: " + hour));
        summary = controllable ? this.getControllableConsumptions(day, hour, type) : this.getBaseConsumptions(day, hour, type) + this.getWeatherSensitiveConsumptions(day, hour, type);
        return (double)summary / 1000.0;
    }

    public HashMap<String, TariffSubscription> getSubscriptionMap() {
        return this.subscriptionMap;
    }

    public HashMap<String, TariffSubscription> getControllableSubscriptionMap() {
        return this.controllableSubscriptionMap;
    }

    public HashMap<String, Double> getInertiaMap() {
        return this.inertiaMap;
    }

    public HashMap<String, Integer> getPeriodMap() {
        return this.periodMap;
    }

    long getBaseConsumptions(int day, int hour, String type) {
        long summaryBase = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        summaryBase = type.equals("NS") ? this.aggDailyBaseLoadInHoursNS.get(dayTemp).get(hour).longValue() : this.aggDailyBaseLoadInHoursSS.get(dayTemp).get(hour).longValue();
        log.debug((Object)("Base Load for " + type + ":" + summaryBase));
        return summaryBase;
    }

    long getControllableConsumptions(int day, int hour, String type) {
        long summaryControllable = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        summaryControllable = type.equals("NS") ? this.aggDailyControllableLoadInHoursNS.get(dayTemp).get(hour).longValue() : this.aggDailyControllableLoadInHoursSS.get(dayTemp).get(hour).longValue();
        log.debug((Object)("Controllable Load for " + type + ":" + summaryControllable));
        return summaryControllable;
    }

    void curtailControllableConsumption(int day, int hour, String type, long curtail) {
        long before = 0L;
        long after = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        if (type.equals("NS")) {
            before = this.aggDailyControllableLoadInHoursNS.get(dayTemp).get(hour);
            this.aggDailyControllableLoadInHoursNS.get(dayTemp).set(hour, before + curtail);
            after = this.aggDailyControllableLoadInHoursNS.get(dayTemp).get(hour);
        } else {
            before = this.aggDailyControllableLoadInHoursSS.get(dayTemp).get(hour);
            this.aggDailyControllableLoadInHoursSS.get(dayTemp).set(hour, before + curtail);
            after = this.aggDailyControllableLoadInHoursSS.get(dayTemp).get(hour);
        }
        log.debug((Object)("Controllable Load for " + type + ": Before Curtailment " + before + " After Curtailment " + after));
    }

    long getWeatherSensitiveConsumptions(int day, int hour, String type) {
        long summaryWeatherSensitive = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        summaryWeatherSensitive = type.equals("NS") ? this.aggDailyWeatherSensitiveLoadInHoursNS.get(dayTemp).get(hour).longValue() : this.aggDailyWeatherSensitiveLoadInHoursSS.get(dayTemp).get(hour).longValue();
        log.debug((Object)("WeatherSensitive Load for " + type + ":" + summaryWeatherSensitive));
        return summaryWeatherSensitive;
    }

    Vector<Long> getControllableConsumptions(int day, String type) {
        Vector<Long> controllableVector = new Vector();
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        controllableVector = type.equals("NS") ? this.aggDailyControllableLoadInHoursNS.get(dayTemp) : this.aggDailyControllableLoadInHoursSS.get(dayTemp);
        return controllableVector;
    }

    Vector<Long> getWeatherSensitiveConsumptions(int day, String type) {
        Vector<Long> weatherSensitiveVector = new Vector();
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        weatherSensitiveVector = type.equals("NS") ? this.aggDailyWeatherSensitiveLoadInHoursNS.get(dayTemp) : this.aggDailyWeatherSensitiveLoadInHoursSS.get(dayTemp);
        return weatherSensitiveVector;
    }

    public Vector<Office> getOffices() {
        Vector<Office> offices = new Vector<Office>();
        for (Office office : this.notShiftingoffices) {
            offices.add(office);
        }
        for (Office office : this.smartShiftingoffices) {
            offices.add(office);
        }
        return offices;
    }

    public Vector<Office> getOffices(String type) {
        Vector<Office> offices = new Vector<Office>();
        if (type.equals("NS")) {
            for (Office office : this.notShiftingoffices) {
                offices.add(office);
            }
        } else {
            for (Office office : this.smartShiftingoffices) {
                offices.add(office);
            }
        }
        return offices;
    }

    public void possibilityEvaluationNewTariffs(List<Tariff> newTariffs, String type) {
        for (CustomerInfo customer : this.customerInfos) {
            List subscriptions = this.tariffSubscriptionRepo.findActiveSubscriptionsForCustomer(customer);
            if (subscriptions == null || subscriptions.size() == 0) {
                this.subscribeDefault();
                return;
            }
            Vector<Double> estimation = new Vector<Double>();
            ArrayList<Tariff> evaluationTariffs = new ArrayList<Tariff>(newTariffs);
            log.debug((Object)("Estimation size for " + this.toString() + " = " + evaluationTariffs.size()));
            if (evaluationTariffs.size() <= 1) continue;
            for (Tariff tariff : evaluationTariffs) {
                log.debug((Object)("Tariff : " + tariff.toString() + " Tariff Type : " + tariff.getTariffSpecification().getPowerType()));
                if (!tariff.isExpired() && (tariff.getTariffSpecification().getPowerType() == customer.getPowerType() || customer.getPowerType() == PowerType.INTERRUPTIBLE_CONSUMPTION && tariff.getTariffSpecification().getPowerType() == PowerType.CONSUMPTION)) {
                    estimation.add(-this.costEstimation(tariff, type));
                    continue;
                }
                estimation.add(Double.NEGATIVE_INFINITY);
            }
            int minIndex = this.logitPossibilityEstimation(estimation, type);
            TariffSubscription sub = this.subscriptionMap.get(type);
            if (customer.getPowerType() == PowerType.INTERRUPTIBLE_CONSUMPTION) {
                sub = this.controllableSubscriptionMap.get(type);
            }
            log.debug((Object)("Equality: " + sub.getTariff().getTariffSpec().toString() + " = " + evaluationTariffs.get(minIndex).getTariffSpec().toString()));
            if (sub.getTariff().getTariffSpec() == evaluationTariffs.get(minIndex).getTariffSpec()) continue;
            log.debug((Object)("Changing From " + sub.toString() + " For PowerType " + customer.getPowerType() + " After Evaluation"));
            this.changeSubscription(sub.getTariff(), evaluationTariffs.get(minIndex), type, customer);
        }
    }

    double costEstimation(Tariff tariff, String type) {
        double costVariable = 0.0;
        if (type.equals("NS")) {
            log.debug((Object)("Simple Evaluation for " + type));
            costVariable = this.estimateVariableTariffPayment(tariff, type);
        } else if (type.equals("RaS")) {
            Double rand = this.gen.nextDouble();
            if (rand < this.getInertiaMap().get(type)) {
                log.debug((Object)("Simple Evaluation for " + type));
                costVariable = this.estimateShiftingVariableTariffPayment(tariff, type);
            } else {
                log.debug((Object)("Shifting Evaluation for " + type));
                costVariable = this.estimateVariableTariffPayment(tariff, type);
            }
        } else {
            log.debug((Object)("Shifting Evaluation for " + type));
            costVariable = this.estimateShiftingVariableTariffPayment(tariff, type);
        }
        double costFixed = this.estimateFixedTariffPayments(tariff);
        return (costVariable + costFixed) / 1000000.0;
    }

    double estimateFixedTariffPayments(Tariff tariff) {
        double lifecyclePayment = -tariff.getEarlyWithdrawPayment() - tariff.getSignupPayment();
        double minDuration = tariff.getMinDuration() == 0L ? 4.32E8 : (double)tariff.getMinDuration();
        log.debug((Object)("Minimum Duration: " + minDuration));
        return -tariff.getPeriodicPayment() + lifecyclePayment / minDuration;
    }

    double estimateVariableTariffPayment(Tariff tariff, String type) {
        double finalCostSummary = 0.0;
        int serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
        Instant base = new Instant(this.timeService.getCurrentTime().getMillis() - (long)serial * 3600000L);
        int daylimit = serial / 24 + 1;
        for (int day : this.daysList) {
            if (day < daylimit) {
                day += daylimit / 3;
            }
            Instant now = base.plus((long)day * 86400000L);
            double costSummary = 0.0;
            double summary = 0.0;
            double cumulativeSummary = 0.0;
            for (int hour = 0; hour < 24; ++hour) {
                summary = this.getBaseConsumptions(day, hour, type) + this.getControllableConsumptions(day, hour, type);
                log.debug((Object)("Cost for hour " + hour + ":" + tariff.getUsageCharge(now, 1.0, 0.0)));
                costSummary -= tariff.getUsageCharge(now, summary, cumulativeSummary += summary);
                now = now.plus(3600000L);
            }
            log.debug((Object)("Variable Cost Summary: " + finalCostSummary));
            finalCostSummary += costSummary;
        }
        return finalCostSummary / 3.0;
    }

    double estimateShiftingVariableTariffPayment(Tariff tariff, String type) {
        double finalCostSummary = 0.0;
        int serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
        Instant base = this.timeService.getCurrentTime().minus((long)serial * 3600000L);
        int daylimit = serial / 24 + 1;
        for (int day : this.daysList) {
            if (day < daylimit) {
                day += daylimit / 3;
            }
            Instant now = base.plus((long)day * 86400000L);
            double costSummary = 0.0;
            double summary = 0.0;
            double cumulativeSummary = 0.0;
            long[] newControllableLoad = this.dailyShifting(tariff, now, day, type);
            for (int hour = 0; hour < 24; ++hour) {
                summary = this.getBaseConsumptions(day, hour, type) + newControllableLoad[hour];
                costSummary -= tariff.getUsageCharge(now, summary, cumulativeSummary += summary);
                now = now.plus(3600000L);
            }
            log.debug((Object)("Variable Cost Summary: " + finalCostSummary));
            finalCostSummary += costSummary;
        }
        return finalCostSummary / 3.0;
    }

    int logitPossibilityEstimation(Vector<Double> estimation, String type) {
        int i;
        double lamda = this.lamdaMap.get(type);
        double summedEstimations = 0.0;
        Vector<Integer> randomizer = new Vector<Integer>();
        Vector<Integer> possibilities = new Vector<Integer>();
        for (i = 0; i < estimation.size(); ++i) {
            log.debug((Object)("Cost variable: " + estimation.get(i)));
            log.debug((Object)("Summary of Estimation: " + (summedEstimations += Math.pow(2.7, lamda * estimation.get(i)))));
        }
        for (i = 0; i < estimation.size(); ++i) {
            possibilities.add((int)(100.0 * (Math.pow(2.7, lamda * estimation.get(i)) / summedEstimations)));
            for (int j = 0; j < (Integer)possibilities.get(i); ++j) {
                randomizer.add(i);
            }
        }
        log.debug((Object)("Randomizer Vector: " + randomizer));
        log.debug((Object)("Possibility Vector: " + possibilities.toString()));
        int index = (Integer)randomizer.get((int)((double)randomizer.size() * this.rs1.nextDouble()));
        log.debug((Object)("Resulting Index = " + index));
        return index;
    }

    long[] dailyShifting(Tariff tariff, Instant now, int day, String type) {
        long[] newControllableLoad = new long[24];
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingoffices : this.smartShiftingoffices;
        for (Office office : offices) {
            long[] temp = office.dailyShifting(tariff, now, dayTemp, this.gen);
            for (int j = 0; j < 24; ++j) {
                int n = j;
                newControllableLoad[n] = newControllableLoad[n] + temp[j];
            }
        }
        log.debug((Object)("New Controllable Load of OfficeComplex " + this.toString() + " type " + type + " for Tariff " + tariff.toString()));
        for (int i = 0; i < 24; ++i) {
            log.debug((Object)("Hour: " + i + " Cost: " + tariff.getUsageCharge(now, 1.0, 0.0) + " Load For Type " + type + " : " + newControllableLoad[i]));
            now = new Instant(now.getMillis() + 3600000L);
        }
        return newControllableLoad;
    }

    void printDailyLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        offices = type.equals("NS") ? this.notShiftingoffices : this.smartShiftingoffices;
        log.debug((Object)("Day " + day));
        for (Office office : offices) {
            office.printDailyLoad(dayTemp);
        }
    }

    Vector<Integer> createPublicVacationVector(int days) {
        Vector<Integer> v = new Vector<Integer>(days);
        for (int i = 0; i < days; ++i) {
            int x = this.gen.nextInt(OfficeComplexConstants.DAYS_OF_COMPETITION + 14);
            ListIterator<Integer> iter = v.listIterator();
            while (iter.hasNext()) {
                int temp = iter.next();
                if (x != temp) continue;
                ++x;
                iter = v.listIterator();
            }
            v.add(x);
        }
        Collections.sort(v);
        return v;
    }

    void createCostEstimationDaysList(int days) {
        for (int i = 0; i < days; ++i) {
            int x = this.gen.nextInt(OfficeComplexConstants.DAYS_OF_COMPETITION + 14);
            ListIterator<Integer> iter = this.daysList.listIterator();
            while (iter.hasNext()) {
                int temp = iter.next();
                if (x != temp) continue;
                ++x;
                iter = this.daysList.listIterator();
            }
            this.daysList.add(x);
        }
        Collections.sort(this.daysList);
    }

    public void step() {
        int serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
        int day = serial / 24;
        int hour = this.timeService.getHourOfDay();
        Instant now = new Instant(this.timeService.getCurrentTime().getMillis());
        this.weatherCheck(day, hour, now);
        this.checkRevokedSubscriptions();
        this.checkCurtailment(serial, day, hour);
        this.consumePower();
        if (hour == 23) {
            for (String type : this.subscriptionMap.keySet()) {
                if (type.equals("NS")) continue;
                log.info((Object)("Rescheduling " + type));
                this.rescheduleNextDay(type);
            }
        }
    }

    void weatherCheck(int day, int hour, Instant now) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        WeatherReport wr = this.weatherReportRepo.currentWeatherReport();
        if (wr != null) {
            double temperature = wr.getTemperature();
            Vector<Office> offices = this.getOffices();
            for (Office office : offices) {
                office.weatherCheck(dayTemp, hour, now, temperature);
            }
            for (String type : this.subscriptionMap.keySet()) {
                this.updateAggDailyWeatherSensitiveLoad(type, day);
                if (dayTemp + 1 >= OfficeComplexConstants.DAYS_OF_COMPETITION) continue;
                this.updateAggDailyWeatherSensitiveLoad(type, dayTemp + 1);
            }
        }
    }

    void checkCurtailment(int serial, int day, int hour) {
        int nextSerial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L) + 1;
        int nextDay = nextSerial / 24;
        int nextHour = nextSerial % 24;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        int nextDayTemp = nextDay % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Collection<TariffSubscription> tempCol = this.controllableSubscriptionMap.values();
        ArrayList<TariffSubscription> subs = new ArrayList<TariffSubscription>();
        for (TariffSubscription sub : tempCol) {
            if (subs.contains(sub)) continue;
            subs.add(sub);
        }
        log.debug((Object)(this.toString() + " " + subs.toString()));
        for (TariffSubscription sub : subs) {
            long curt = (long)sub.getCurtailment() * 1000L;
            log.debug((Object)(this.toString() + " Subscription " + sub + " Curtailment " + curt));
            if (curt <= 0L) continue;
            ArrayList<String> temp = new ArrayList<String>();
            for (String type : this.controllableSubscriptionMap.keySet()) {
                if (this.controllableSubscriptionMap.get(type) != sub) continue;
                temp.add(type);
            }
            for (int i = 0; i < temp.size(); ++i) {
                String type;
                type = (String)temp.get(i);
                this.curtailControllableConsumption(dayTemp, hour, type, -(curt / (long)temp.size()));
                this.curtailControllableConsumption(nextDayTemp, nextHour, type, curt / (long)temp.size());
            }
        }
    }

    void rescheduleNextDay(String type) {
        int serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
        int day = serial / 24 + 1;
        Instant now = new Instant(this.timeService.getCurrentTime().getMillis() + 3600000L);
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Vector<Long> controllableVector = new Vector<Long>();
        TariffSubscription sub = this.subscriptionMap.get(type);
        log.debug((Object)("Old Consumption for day " + day + ": " + this.getControllableConsumptions(dayTemp, type).toString()));
        long[] newControllableLoad = this.dailyShifting(sub.getTariff(), now, dayTemp, type);
        for (int i = 0; i < 24; ++i) {
            controllableVector.add(newControllableLoad[i]);
        }
        log.debug((Object)("New Consumption for day " + day + ": " + controllableVector.toString()));
        this.aggDailyControllableLoadInHoursSS.set(dayTemp, controllableVector);
    }

    public String toString() {
        return this.name;
    }
}

