/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.joda.time.Instant;
import org.powertac.common.Tariff;
import org.powertac.officecomplexcustomer.appliances.SemiShiftingAppliance;

public class CopyMachine
extends SemiShiftingAppliance {
    private int standbyPower;

    @Override
    public void initialize(String office, Properties conf, Random gen) {
        this.name = office + " CopyMachine";
        this.saturation = Double.parseDouble(conf.getProperty("CopyMachineSaturation"));
        this.power = (int)(54.0 * gen.nextGaussian() + 350.0);
        this.standbyPower = (int)(14.0 * gen.nextGaussian() + 74.0);
        this.cycleDuration = 1;
        this.times = Integer.parseInt(conf.getProperty("CopyMachineDailyTimes")) + this.applianceOf.getMembers().size() / 5;
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isWorking(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday, Random gen) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        Vector<Integer> temp = new Vector<Integer>();
        for (i = 0; i < 96; ++i) {
            if (i > 32 && i < 84 && !this.applianceOf.isEmpty(weekday, i)) {
                this.loadVector.add(this.standbyPower);
                this.dailyOperation.add(true);
                int count = this.applianceOf.employeeNumber(weekday, i);
                for (int j = 0; j < count; ++j) {
                    temp.add(i);
                }
                continue;
            }
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        if (temp.size() > 0) {
            for (i = 0; i < this.times; ++i) {
                int rand = gen.nextInt(temp.size());
                int quarter = (Integer)temp.get(rand);
                this.loadVector.set(quarter, this.power);
                temp.remove(rand);
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public long[] dailyShifting(Tariff tariff, Instant now, int day, Random gen) {
        long[] newControllableLoad = new long[24];
        int[] minindex = new int[2];
        double[] minvalue = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        Instant hour1 = new Instant(now.getMillis() + 28800000L);
        for (int i = 8; i < 21; ++i) {
            newControllableLoad[i] = 4 * this.standbyPower;
            if (minvalue[0] < tariff.getUsageCharge(hour1, 1.0, 0.0) || minvalue[0] == tariff.getUsageCharge(hour1, 1.0, 0.0) && (double)gen.nextFloat() > 0.6) {
                minvalue[1] = minvalue[0];
                minvalue[0] = tariff.getUsageCharge(hour1, 1.0, 0.0);
                minindex[1] = minindex[0];
                minindex[0] = i;
            } else if (minvalue[1] < tariff.getUsageCharge(hour1, 1.0, 0.0) || minvalue[1] == tariff.getUsageCharge(hour1, 1.0, 0.0) && (double)gen.nextFloat() > 0.6) {
                minvalue[1] = tariff.getUsageCharge(hour1, 1.0, 0.0);
                minindex[1] = i;
            }
            hour1 = new Instant(hour1.getMillis() + 3600000L);
        }
        if (this.times > 4) {
            newControllableLoad[minindex[0]] = 4 * this.power;
            newControllableLoad[minindex[1]] = (this.times - 4) * this.power;
        } else {
            newControllableLoad[minindex[0]] = this.times * this.power;
        }
        return newControllableLoad;
    }

    @Override
    public void refresh(Random gen) {
        this.fillWeeklyOperation(gen);
        this.createWeeklyPossibilityOperationVector();
    }
}

