/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.customers;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Tariff;
import org.powertac.officecomplexcustomer.appliances.AirCondition;
import org.powertac.officecomplexcustomer.appliances.Appliance;
import org.powertac.officecomplexcustomer.appliances.CoffeeMachine;
import org.powertac.officecomplexcustomer.appliances.Computers;
import org.powertac.officecomplexcustomer.appliances.ConsumerElectronics;
import org.powertac.officecomplexcustomer.appliances.CopyMachine;
import org.powertac.officecomplexcustomer.appliances.ICT;
import org.powertac.officecomplexcustomer.appliances.Lights;
import org.powertac.officecomplexcustomer.appliances.MicrowaveOven;
import org.powertac.officecomplexcustomer.appliances.NotShiftingAppliance;
import org.powertac.officecomplexcustomer.appliances.Refrigerator;
import org.powertac.officecomplexcustomer.appliances.Servers;
import org.powertac.officecomplexcustomer.appliances.VendingMachine;
import org.powertac.officecomplexcustomer.appliances.WeatherSensitiveAppliance;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.OfficeComplex;
import org.powertac.officecomplexcustomer.enumerations.Status;
import org.powertac.officecomplexcustomer.persons.PeriodicPresentPerson;
import org.powertac.officecomplexcustomer.persons.Person;

public class Office {
    protected static Logger log = Logger.getLogger((String)Office.class.getName());
    String name;
    Vector<Integer> dailyBaseLoad = new Vector();
    Vector<Integer> dailyControllableLoad = new Vector();
    Vector<Integer> dailyWeatherSensitiveLoad = new Vector();
    Vector<Vector<Integer>> weeklyBaseLoad = new Vector();
    Vector<Vector<Integer>> weeklyControllableLoad = new Vector();
    Vector<Vector<Integer>> weeklyWeatherSensitiveLoad = new Vector();
    Vector<Integer> dailyBaseLoadInHours = new Vector();
    Vector<Integer> dailyControllableLoadInHours = new Vector();
    Vector<Integer> dailyWeatherSensitiveLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyBaseLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyControllableLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyWeatherSensitiveLoadInHours = new Vector();
    int week = 0;
    Vector<Person> members = new Vector();
    Vector<Appliance> appliances = new Vector();
    public OfficeComplex officeOf;

    public void initialize(String OfficeName, Properties conf, Vector<Integer> publicVacationVector, Random gen) {
        this.name = OfficeName;
        int persons = this.memberRandomizer(conf, gen);
        for (int i = 0; i < persons; ++i) {
            this.addPerson(i + 1, conf, publicVacationVector, gen);
        }
        for (Person member : this.members) {
            for (int i = 0; i < 7; ++i) {
                member.fillDailyRoutine(i, gen);
                member.getWeeklyRoutine().add(member.getDailyRoutine());
                member.setMemberOf(this);
            }
        }
        this.fillAppliances(conf, gen);
        for (int i = 0; i < 7; ++i) {
            this.dailyBaseLoad = this.fillDailyBaseLoad(this.week * 7 + i);
            this.dailyControllableLoad = this.fillDailyControllableLoad(this.week * 7 + i);
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(this.week * 7 + i);
            this.weeklyBaseLoad.add(this.dailyBaseLoad);
            this.weeklyControllableLoad.add(this.dailyControllableLoad);
            this.weeklyWeatherSensitiveLoad.add(this.dailyWeatherSensitiveLoad);
            this.dailyBaseLoadInHours = this.fillDailyBaseLoadInHours();
            this.dailyControllableLoadInHours = this.fillDailyControllableLoadInHours();
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyBaseLoadInHours.add(this.dailyBaseLoadInHours);
            this.weeklyControllableLoadInHours.add(this.dailyControllableLoadInHours);
            this.weeklyWeatherSensitiveLoadInHours.add(this.dailyWeatherSensitiveLoadInHours);
        }
        this.week = 1;
        while (this.week < OfficeComplexConstants.WEEKS_OF_COMPETITION + 2) {
            this.refresh(conf, gen);
            ++this.week;
        }
        for (Appliance appliance : this.appliances) {
            appliance.setOperationDays();
        }
    }

    void addPerson(int counter, Properties conf, Vector<Integer> publicVacationVector, Random gen) {
        PeriodicPresentPerson ppp = new PeriodicPresentPerson();
        ppp.initialize("PPP" + counter, conf, publicVacationVector, gen);
        this.members.add(ppp);
    }

    public Vector<Appliance> getAppliances() {
        return this.appliances;
    }

    public Vector<Person> getMembers() {
        return this.members;
    }

    int memberRandomizer(Properties conf, Random gen) {
        int one = Integer.parseInt(conf.getProperty("OneToFivePersons"));
        int two = Integer.parseInt(conf.getProperty("SixToTenPersons"));
        int three = Integer.parseInt(conf.getProperty("ElevenToFifteenPersons"));
        int x = gen.nextInt(100);
        int returnValue = x < one ? 1 + gen.nextInt(5) : (x >= one & x < one + two ? 6 + gen.nextInt(5) : (x >= one + two & x < one + two + three ? 11 + gen.nextInt(5) : 16 + gen.nextInt(5)));
        return returnValue;
    }

    void checkProbability(Appliance app, Random gen) {
        int threshold;
        int x = gen.nextInt(100);
        if (x < (threshold = (int)(app.getSaturation() * 100.0))) {
            app.fillWeeklyOperation(gen);
            app.createWeeklyPossibilityOperationVector();
        } else {
            this.appliances.remove(app);
        }
    }

    void fillAppliances(Properties conf, Random gen) {
        AirCondition ac = new AirCondition();
        this.appliances.add(ac);
        ac.setApplianceOf(this);
        ac.initialize(this.name, conf, gen);
        this.checkProbability(ac, gen);
        ConsumerElectronics ce = new ConsumerElectronics();
        this.appliances.add(ce);
        ce.setApplianceOf(this);
        ce.initialize(this.name, conf, gen);
        ce.fillWeeklyOperation(gen);
        ce.createWeeklyPossibilityOperationVector();
        ICT ict = new ICT();
        this.appliances.add(ict);
        ict.setApplianceOf(this);
        ict.initialize(this.name, conf, gen);
        ict.fillWeeklyOperation(gen);
        ict.createWeeklyPossibilityOperationVector();
        Lights lights = new Lights();
        this.appliances.add(lights);
        lights.setApplianceOf(this);
        lights.initialize(this.name, conf, gen);
        lights.fillWeeklyOperation(gen);
        lights.createWeeklyPossibilityOperationVector();
        Computers com = new Computers();
        this.appliances.add(com);
        com.setApplianceOf(this);
        com.initialize(this.name, conf, gen);
        com.fillWeeklyOperation(gen);
        com.createWeeklyPossibilityOperationVector();
        Servers servers = new Servers();
        this.appliances.add(servers);
        servers.setApplianceOf(this);
        servers.initialize(this.name, conf, gen);
        this.checkProbability(servers, gen);
        Refrigerator ref = new Refrigerator();
        this.appliances.add(ref);
        ref.setApplianceOf(this);
        ref.initialize(this.name, conf, gen);
        ref.fillWeeklyOperation(gen);
        ref.createWeeklyPossibilityOperationVector();
        CoffeeMachine coffee = new CoffeeMachine();
        this.appliances.add(coffee);
        coffee.setApplianceOf(this);
        coffee.initialize(this.name, conf, gen);
        this.checkProbability(coffee, gen);
        VendingMachine vm = new VendingMachine();
        this.appliances.add(vm);
        vm.setApplianceOf(this);
        vm.initialize(this.name, conf, gen);
        this.checkProbability(vm, gen);
        MicrowaveOven mo = new MicrowaveOven();
        this.appliances.add(mo);
        mo.setApplianceOf(this);
        mo.initialize(this.name, conf, gen);
        this.checkProbability(mo, gen);
        CopyMachine cm = new CopyMachine();
        this.appliances.add(cm);
        cm.setApplianceOf(this);
        cm.initialize(this.name, conf, gen);
        this.checkProbability(cm, gen);
    }

    public boolean isWorking(int weekday, int quarter) {
        boolean x = false;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Working) continue;
            x = true;
        }
        return x;
    }

    public boolean isOnBreak(int weekday, int quarter) {
        boolean x = false;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Break) continue;
            x = true;
        }
        return x;
    }

    public boolean isOnVacation(int weekday) {
        boolean x = true;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(0) == Status.Vacation && member.getWeeklyRoutine().get(this.week * 7 + weekday).get(0) == Status.Sick) continue;
            x = false;
        }
        return x;
    }

    public boolean isWorkingDayOfWeek(int weekday) {
        boolean x = false;
        block0: for (int i = 0; i < 96; ++i) {
            for (Person member : this.members) {
                if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(i) != Status.Working && member.getWeeklyRoutine().get(this.week * 7 + weekday).get(i) != Status.Break) continue;
                x = true;
                i = 96;
                continue block0;
            }
        }
        return x;
    }

    public boolean isWorkingDay(int day) {
        boolean x = false;
        block0: for (int i = 0; i < 96; ++i) {
            for (Person member : this.members) {
                if (member.getWeeklyRoutine().get(day).get(i) != Status.Working && member.getWeeklyRoutine().get(day).get(i) != Status.Break) continue;
                x = true;
                i = 96;
                continue block0;
            }
        }
        return x;
    }

    public boolean isEmpty(int weekday, int quarter) {
        boolean x = true;
        if (this.isWorking(weekday, quarter) || this.isOnBreak(weekday, quarter)) {
            x = false;
        }
        return x;
    }

    public int employeeWorkingNumber(int weekday, int quarter) {
        int counter = 0;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Working) continue;
            ++counter;
        }
        return counter;
    }

    public int employeeOnBreakNumber(int weekday, int quarter) {
        int counter = 0;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Break) continue;
            ++counter;
        }
        return counter;
    }

    public int employeeNumber(int weekday, int quarter) {
        int counter = this.employeeWorkingNumber(weekday, quarter) + this.employeeOnBreakNumber(weekday, quarter);
        return counter;
    }

    void showStatus() {
        int j;
        ListIterator<Integer> iter4;
        ListIterator<Integer> iter3;
        ListIterator<Integer> iter2;
        int i;
        log.info((Object)("Office Name : " + this.name));
        log.info((Object)("Number of Persons : " + this.members.size()));
        log.info((Object)" Daily Load = ");
        for (i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.info((Object)("Day " + i));
            iter2 = this.weeklyBaseLoad.get(i).listIterator();
            iter3 = this.weeklyControllableLoad.get(i).listIterator();
            iter4 = this.weeklyWeatherSensitiveLoad.get(i).listIterator();
            for (j = 0; j < 96; ++j) {
                log.info((Object)("Quarter : " + j + " Base Load : " + iter2.next() + " Controllable Load: " + iter3.next() + " WeatherSensitive Load: " + iter4.next()));
            }
        }
        log.info((Object)" Load In Hours = ");
        for (i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.info((Object)("Day " + i));
            iter2 = this.weeklyBaseLoadInHours.get(i).listIterator();
            iter3 = this.weeklyControllableLoadInHours.get(i).listIterator();
            iter4 = this.weeklyWeatherSensitiveLoadInHours.get(i).listIterator();
            for (j = 0; j < 24; ++j) {
                log.info((Object)("Hours : " + j + " Base Load : " + iter2.next() + " Controllable Load: " + iter3.next() + " WeatherSensitive Load: " + iter4.next()));
            }
        }
    }

    Vector<Integer> fillDailyBaseLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (!(appliance instanceof NotShiftingAppliance)) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyControllableLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (appliance instanceof NotShiftingAppliance) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyWeatherSensitiveLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (!(appliance instanceof WeatherSensitiveAppliance)) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyBaseLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyBaseLoad.get(i * 4) + this.dailyBaseLoad.get(i * 4 + 1) + this.dailyBaseLoad.get(i * 4 + 2) + this.dailyBaseLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyControllableLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyControllableLoad.get(i * 4) + this.dailyControllableLoad.get(i * 4 + 1) + this.dailyControllableLoad.get(i * 4 + 2) + this.dailyControllableLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyWeatherSensitiveLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyWeatherSensitiveLoad.get(i * 4) + this.dailyWeatherSensitiveLoad.get(i * 4 + 1) + this.dailyWeatherSensitiveLoad.get(i * 4 + 2) + this.dailyWeatherSensitiveLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    void refresh(Properties conf, Random gen) {
        for (Person member : this.members) {
            member.refresh(conf, gen);
        }
        for (Appliance appliance : this.appliances) {
            appliance.refresh(gen);
        }
        for (int i = 0; i < 7; ++i) {
            this.dailyBaseLoad = this.fillDailyBaseLoad(this.week * 7 + i);
            this.dailyControllableLoad = this.fillDailyControllableLoad(this.week * 7 + i);
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(this.week * 7 + i);
            this.weeklyBaseLoad.add(this.dailyBaseLoad);
            this.weeklyControllableLoad.add(this.dailyControllableLoad);
            this.weeklyWeatherSensitiveLoad.add(this.dailyWeatherSensitiveLoad);
            this.dailyBaseLoadInHours = this.fillDailyBaseLoadInHours();
            this.dailyControllableLoadInHours = this.fillDailyControllableLoadInHours();
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyBaseLoadInHours.add(this.dailyBaseLoadInHours);
            this.weeklyControllableLoadInHours.add(this.dailyControllableLoadInHours);
            this.weeklyWeatherSensitiveLoadInHours.add(this.dailyWeatherSensitiveLoadInHours);
        }
    }

    public void weatherCheck(int day, int hour, Instant now, double temperature) {
        boolean flag = false;
        for (Appliance appliance : this.appliances) {
            if (!(appliance instanceof AirCondition) || flag) continue;
            appliance.weatherDailyFunction(day, hour, temperature);
            if (appliance.getWeeklyLoadVector().get(day).get(hour * 4) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 1) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 2) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 3) <= 0) continue;
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(day);
            this.weeklyWeatherSensitiveLoad.set(day, this.dailyWeatherSensitiveLoad);
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyWeatherSensitiveLoadInHours.set(day, this.dailyWeatherSensitiveLoadInHours);
        }
    }

    long[] dailyShifting(Tariff tariff, Instant now, int day, Random gen) {
        long[] newControllableLoad = new long[24];
        for (Appliance appliance : this.appliances) {
            if (appliance instanceof NotShiftingAppliance || appliance instanceof WeatherSensitiveAppliance) continue;
            long[] temp = appliance.dailyShifting(tariff, now, day, gen);
            Vector<Long> tempVector = new Vector<Long>();
            Vector<Long> controllableVector = new Vector<Long>();
            for (int i = 0; i < 24; ++i) {
                tempVector.add(temp[i]);
            }
            for (int j = 0; j < 24; ++j) {
                int n = j;
                newControllableLoad[n] = newControllableLoad[n] + temp[j];
                controllableVector.add(newControllableLoad[j]);
            }
        }
        return newControllableLoad;
    }

    public void printDailyLoad(int day) {
        ListIterator<Integer> iter = this.weeklyBaseLoadInHours.get(day).listIterator();
        ListIterator<Integer> iter2 = this.weeklyControllableLoadInHours.get(day).listIterator();
        ListIterator<Integer> iter3 = this.weeklyWeatherSensitiveLoadInHours.get(day).listIterator();
        log.info((Object)("Summary of Daily Load of House " + this.name));
        for (int j = 0; j < 24; ++j) {
            log.info((Object)("Hour : " + j + 1 + " Base Load : " + iter.next() + " Controllable Load : " + iter2.next() + " Weather Sensitive Load : " + iter3.next()));
        }
    }

    public String toString() {
        return this.name;
    }
}

