/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.OfficeComplex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfficeComplexCustomerService
extends TimeslotPhaseProcessor
implements NewTariffListener,
InitializationService {
    private static Logger log = Logger.getLogger((String)OfficeComplexCustomerService.class.getName());
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private ServerConfiguration serverPropertiesService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    private RandomSeed rs1;
    private String configFile1 = null;
    private String configFile2 = null;
    private int daysOfCompetition = 0;
    Properties configuration = new Properties();
    ArrayList<OfficeComplex> officeComplexList;
    List<Tariff> publishedTariffs = new ArrayList<Tariff>();
    int publishingPeriods = 0;

    public OfficeComplexCustomerService() {
        this.officeComplexList = new ArrayList();
    }

    public String initialize(Competition competition, List<String> completedInits) {
        OfficeComplex officeComplex;
        CustomerInfo officeComplexInfo2;
        CustomerInfo officeComplexInfo;
        int index = completedInits.indexOf("DefaultBroker");
        if (index == -1) {
            return null;
        }
        this.serverPropertiesService.configureMe((Object)this);
        this.officeComplexList.clear();
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.rs1 = this.randomSeedRepo.getRandomSeed("OfficeComplexCustomerService", 1L, "Office Complex Customer Models");
        if (this.configFile1 == null) {
            log.info((Object)"No Config File for OfficeComplexType1 Taken");
            this.configFile1 = "OfficeComplexDefault.properties";
        }
        if (this.configFile2 == null) {
            log.info((Object)"No Config File for OfficeComplexType2 Taken");
            this.configFile2 = "OfficeComplexDefault.properties";
        }
        super.init();
        this.daysOfCompetition = Competition.currentCompetition().getExpectedTimeslotCount() / 24;
        OfficeComplexConstants.setDaysOfWeek();
        OfficeComplexConstants.setDaysOfCompetition(this.daysOfCompetition);
        this.daysOfCompetition = OfficeComplexConstants.DAYS_OF_COMPETITION;
        if (this.daysOfCompetition == 0) {
            log.info((Object)"No Days Of Competition Taken");
            this.daysOfCompetition = 63;
        }
        InputStream cfgFile = null;
        cfgFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile1);
        try {
            this.configuration.load(cfgFile);
            cfgFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int numberOfOfficeComplexes = Integer.parseInt(this.configuration.getProperty("NumberOfOfficeComplexes"));
        int nsoffices = Integer.parseInt(this.configuration.getProperty("NotShiftingCustomers"));
        int ssoffices = Integer.parseInt(this.configuration.getProperty("SmartShiftingCustomers"));
        int villagePopulation = nsoffices + ssoffices;
        for (int i = 1; i < numberOfOfficeComplexes + 1; ++i) {
            officeComplexInfo = new CustomerInfo("OfficeComplexType1 OfficeComplex " + i, villagePopulation).withPowerType(PowerType.CONSUMPTION);
            officeComplexInfo2 = new CustomerInfo("OfficeComplexType1 OfficeComplex " + i, villagePopulation).withPowerType(PowerType.INTERRUPTIBLE_CONSUMPTION);
            officeComplex = new OfficeComplex("OfficeComplexType1 OfficeComplex " + i);
            officeComplex.addCustomerInfo(officeComplexInfo);
            officeComplex.addCustomerInfo(officeComplexInfo2);
            officeComplex.initialize(this.configuration, (Random)this.rs1);
            this.officeComplexList.add(officeComplex);
            officeComplex.subscribeDefault();
        }
        cfgFile = null;
        cfgFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile2);
        try {
            this.configuration.load(cfgFile);
            cfgFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        numberOfOfficeComplexes = Integer.parseInt(this.configuration.getProperty("NumberOfOfficeComplexes"));
        nsoffices = Integer.parseInt(this.configuration.getProperty("NotShiftingCustomers"));
        ssoffices = Integer.parseInt(this.configuration.getProperty("SmartShiftingCustomers"));
        villagePopulation = nsoffices + ssoffices;
        for (int i = 1; i < numberOfOfficeComplexes + 1; ++i) {
            officeComplexInfo = new CustomerInfo("OfficeComplexType2 OfficeComplex " + i, villagePopulation).withPowerType(PowerType.CONSUMPTION);
            officeComplexInfo2 = new CustomerInfo("OfficeComplexType2 OfficeComplex " + i, villagePopulation).withPowerType(PowerType.INTERRUPTIBLE_CONSUMPTION);
            officeComplex = new OfficeComplex("OfficeComplexType2 OfficeComplex " + i);
            officeComplex.addCustomerInfo(officeComplexInfo);
            officeComplex.addCustomerInfo(officeComplexInfo2);
            officeComplex.initialize(this.configuration, (Random)this.rs1);
            this.officeComplexList.add(officeComplex);
            officeComplex.subscribeDefault();
        }
        return "OfficeComplexCustomer";
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        ++this.publishingPeriods;
        this.publishedTariffs = this.tariffMarketService.getActiveTariffList(PowerType.CONSUMPTION);
        List temp = this.tariffMarketService.getActiveTariffList(PowerType.INTERRUPTIBLE_CONSUMPTION);
        this.publishedTariffs.addAll(temp);
        for (OfficeComplex officeComplex : this.officeComplexList) {
            for (String type : officeComplex.getSubscriptionMap().keySet()) {
                if (this.publishingPeriods % officeComplex.getPeriodMap().get(type) != 0) continue;
                log.debug((Object)("Evaluation for " + type + " of village " + officeComplex.toString()));
                double rand = this.rs1.nextDouble();
                if (!(rand < officeComplex.getInertiaMap().get(type))) continue;
                log.debug((Object)("Inertia Passed for " + type + " of village " + officeComplex.toString()));
                officeComplex.possibilityEvaluationNewTariffs(this.publishedTariffs, type);
            }
        }
    }

    public int getDaysOfCompetition() {
        return this.daysOfCompetition;
    }

    @ConfigurableValue(valueType="Integer", description="The competition duration in days")
    public void setDaysOfCompetition(int days) {
        this.daysOfCompetition = days;
    }

    public String getConfigFile1() {
        return this.configFile1;
    }

    @ConfigurableValue(valueType="String", description="first configuration file of the office complex customers")
    public void setConfigFile1(String config) {
        this.configFile1 = config;
    }

    public String getConfigFile2() {
        return this.configFile2;
    }

    @ConfigurableValue(valueType="String", description="second configuration file of the office complex customers")
    public void setConfigFile2(String config) {
        this.configFile2 = config;
    }

    public List<OfficeComplex> getOfficeComplexList() {
        return this.officeComplexList;
    }

    public void clearConfiguration() {
        this.configFile1 = null;
        this.configFile2 = null;
    }

    public List<CustomerInfo> generateCustomerInfoList() {
        ArrayList<CustomerInfo> result = new ArrayList<CustomerInfo>();
        for (OfficeComplex officeComplex : this.officeComplexList) {
            for (CustomerInfo customer : officeComplex.getCustomerInfo()) {
                result.add(customer);
            }
        }
        return result;
    }

    public void activate(Instant time, int phaseNumber) {
        log.info((Object)"Activate");
        if (this.officeComplexList.size() > 0) {
            for (OfficeComplex officeComplex : this.officeComplexList) {
                officeComplex.step();
            }
        }
    }

    public void setDefaults() {
    }
}

