/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.customers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.AbstractCustomer;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherReport;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.Office;
import org.springframework.beans.factory.annotation.Autowired;

public class OfficeComplex
extends AbstractCustomer {
    protected static Logger log = Logger.getLogger((String)OfficeComplex.class.getName());
    @Autowired
    TimeService timeService;
    @Autowired
    TimeslotRepo timeslotRepo;
    @Autowired
    WeatherReportRepo weatherReportRepo;
    @Autowired
    TariffRepo tariffRepo;
    int seedId = 1;
    Vector<Vector<Long>> aggDailyBaseLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyBaseLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyDominantLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyDominantLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyNonDominantLoadNS = new Vector();
    Vector<Vector<Long>> aggDailyNonDominantLoadSS = new Vector();
    Vector<Vector<Long>> aggDailyBaseLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyBaseLoadInHoursSS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyControllableLoadInHoursSS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyWeatherSensitiveLoadInHoursSS = new Vector();
    Vector<Vector<Long>> aggDailyDominantLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyDominantLoadInHoursSS = new Vector();
    Vector<Vector<Long>> aggDailyNonDominantLoadInHoursNS = new Vector();
    Vector<Vector<Long>> aggDailyNonDominantLoadInHoursSS = new Vector();
    double[] dominantLoadNS = new double[24];
    double[] dominantLoadSS = new double[24];
    double[] nonDominantLoadNS = new double[24];
    double[] nonDominantLoadSS = new double[24];
    protected final TariffEvaluationHelper tariffEvalHelper = new TariffEvaluationHelper();
    RandomSeed gen;
    Map<String, Integer> numberOfOffices = new TreeMap<String, Integer>();
    Map<CustomerInfo, TariffEvaluator> tariffEvaluators;
    Map<CustomerInfo, String> officeMapping = new TreeMap<CustomerInfo, String>();
    Vector<Office> notShiftingOffices = new Vector();
    Vector<Office> smartShiftingOffices = new Vector();

    public OfficeComplex(String name) {
        super(name);
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.timeService = (TimeService)SpringApplicationContext.getBean((String)"timeService");
        this.weatherReportRepo = (WeatherReportRepo)SpringApplicationContext.getBean((String)"weatherReportRepo");
        this.tariffRepo = (TariffRepo)SpringApplicationContext.getBean((String)"tariffRepo");
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("NS");
        typeList.add("SS");
        Comparator<CustomerInfo> comp = new Comparator<CustomerInfo>(){

            @Override
            public int compare(CustomerInfo customer1, CustomerInfo customer2) {
                return customer1.getName().compareToIgnoreCase(customer2.getName());
            }
        };
        for (String type : typeList) {
            this.numberOfOffices.put(type, null);
            this.tariffEvaluators = new TreeMap<CustomerInfo, TariffEvaluator>(comp);
        }
    }

    public void initialize(Properties conf, int seed, Map<CustomerInfo, String> mapping) {
        int i;
        this.officeMapping = mapping;
        this.numberOfOffices.put("NS", Integer.parseInt(conf.getProperty("NotShiftingCustomers")));
        this.numberOfOffices.put("SS", Integer.parseInt(conf.getProperty("SmartShiftingCustomers")));
        int days = Integer.parseInt(conf.getProperty("PublicVacationDuration"));
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "OfficeComplex Model" + seed);
        Vector<Integer> publicVacationVector = this.createPublicVacationVector(days);
        for (i = 0; i < this.numberOfOffices.get("NS"); ++i) {
            log.info((Object)("Initializing " + this.toString() + " NSoffice " + i));
            Office of = new Office();
            of.initialize(this.toString() + " NSoffice" + i, conf, publicVacationVector, this.seedId++);
            this.notShiftingOffices.add(of);
            of.officeOf = this;
        }
        for (i = 0; i < this.numberOfOffices.get("SS"); ++i) {
            log.info((Object)("Initializing " + this.toString() + " SSoffice " + i));
            Office hh = new Office();
            hh.initialize(this.toString() + " SSoffice" + i, conf, publicVacationVector, this.seedId++);
            this.smartShiftingOffices.add(hh);
            hh.officeOf = this;
        }
        for (String type : this.numberOfOffices.keySet()) {
            this.fillAggWeeklyLoad(type);
            double weight = this.gen.nextDouble() * 1.0;
            double weeks = this.gen.nextInt(2) + 1;
            List customer = this.customerRepo.findByName(this.name + " " + type + " Base");
            TariffEvaluationWrapper wrapper = new TariffEvaluationWrapper(type, (CustomerInfo)customer.get(0));
            TariffEvaluator te = new TariffEvaluator((CustomerModelAccessor)wrapper);
            te.initializeInconvenienceFactors(0.05, 0.1, 0.7, 0.5);
            te.withInconvenienceWeight(weight).withInertia(Double.parseDouble(conf.getProperty(type + "Inertia"))).withPreferredContractDuration(weeks * 7.0).withRationality(0.9).withTariffEvalDepth(5).withTariffSwitchFactor(0.02);
            this.tariffEvaluators.put((CustomerInfo)customer.get(0), te);
            customer = this.customerRepo.findByName(this.name + " " + type + " Controllable");
            wrapper = new TariffEvaluationWrapper(type, (CustomerInfo)customer.get(0));
            te = new TariffEvaluator((CustomerModelAccessor)wrapper);
            te.initializeInconvenienceFactors(0.05, 0.1, 0.7, 0.5);
            te.withInconvenienceWeight(weight).withInertia(Double.parseDouble(conf.getProperty(type + "Inertia"))).withPreferredContractDuration(weeks * 7.0).withRationality(0.9).withTariffEvalDepth(5).withTariffSwitchFactor(0.02);
            this.tariffEvaluators.put((CustomerInfo)customer.get(0), te);
        }
    }

    public void addCustomerInfo(CustomerInfo customer) {
        this.customerInfos.add(customer);
        this.customerRepo.add(customer);
    }

    public void subscribeDefault() {
        super.subscribeDefault();
        for (CustomerInfo customer : this.customerInfos) {
            if (customer.getPowerType() != PowerType.INTERRUPTIBLE_CONSUMPTION || this.tariffMarketService.getDefaultTariff(PowerType.INTERRUPTIBLE_CONSUMPTION) != null) continue;
            log.debug((Object)("No Default Tariff for INTERRUPTIBLE_CONSUMPTION so the customer " + customer.toString() + " subscribe to CONSUMPTION Default Tariff instead"));
            this.tariffMarketService.subscribeToTariff(this.tariffMarketService.getDefaultTariff(PowerType.CONSUMPTION), customer, customer.getPopulation());
            log.info((Object)("CustomerInfo of type INTERRUPTIBLE_CONSUMPTION of " + this.toString() + " was subscribed to the default CONSUMPTION tariff successfully."));
        }
    }

    void fillAggWeeklyLoad(String type) {
        if (type.equals("NS")) {
            for (int i = 0; i < 7 * (OfficeComplexConstants.WEEKS_OF_COMPETITION + 2); ++i) {
                this.aggDailyBaseLoadNS.add(this.fillAggDailyBaseLoad(i, type));
                this.aggDailyControllableLoadNS.add(this.fillAggDailyControllableLoad(i, type));
                this.aggDailyWeatherSensitiveLoadNS.add(this.fillAggDailyWeatherSensitiveLoad(i, type));
                this.aggDailyBaseLoadInHoursNS.add(this.fillAggDailyBaseLoadInHours(i, type));
                this.aggDailyControllableLoadInHoursNS.add(this.fillAggDailyControllableLoadInHours(i, type));
                this.aggDailyWeatherSensitiveLoadInHoursNS.add(this.fillAggDailyWeatherSensitiveLoadInHours(i, type));
                this.aggDailyDominantLoadNS.add(this.fillAggDailyDominantLoad(i, type));
                this.aggDailyNonDominantLoadNS.add(this.fillAggDailyNonDominantLoad(i, type));
                this.aggDailyDominantLoadInHoursNS.add(this.fillAggDailyDominantLoadInHours(i, type));
                this.aggDailyNonDominantLoadInHoursNS.add(this.fillAggDailyNonDominantLoadInHours(i, type));
            }
        } else {
            for (int i = 0; i < 7 * (OfficeComplexConstants.WEEKS_OF_COMPETITION + 2); ++i) {
                this.aggDailyBaseLoadSS.add(this.fillAggDailyBaseLoad(i, type));
                this.aggDailyControllableLoadSS.add(this.fillAggDailyControllableLoad(i, type));
                this.aggDailyWeatherSensitiveLoadSS.add(this.fillAggDailyWeatherSensitiveLoad(i, type));
                this.aggDailyBaseLoadInHoursSS.add(this.fillAggDailyBaseLoadInHours(i, type));
                this.aggDailyControllableLoadInHoursSS.add(this.fillAggDailyControllableLoadInHours(i, type));
                this.aggDailyWeatherSensitiveLoadInHoursSS.add(this.fillAggDailyWeatherSensitiveLoadInHours(i, type));
                this.aggDailyDominantLoadSS.add(this.fillAggDailyDominantLoad(i, type));
                this.aggDailyNonDominantLoadSS.add(this.fillAggDailyNonDominantLoad(i, type));
                this.aggDailyDominantLoadInHoursSS.add(this.fillAggDailyDominantLoadInHours(i, type));
                this.aggDailyNonDominantLoadInHoursSS.add(this.fillAggDailyNonDominantLoadInHours(i, type));
            }
        }
        this.fillAggDominantLoads(type);
    }

    private void fillAggDominantLoads(String type) {
        double[] dominant = new double[24];
        double[] nonDominant = new double[24];
        Vector<Office> houses = this.getOffices(type);
        for (int i = 0; i < houses.size(); ++i) {
            for (int j = 0; j < 24; ++j) {
                int n = j;
                dominant[n] = dominant[n] + houses.get(i).getDominantConsumption(j);
                int n2 = j;
                nonDominant[n2] = nonDominant[n2] + houses.get(i).getNonDominantConsumption(j);
            }
        }
        if (type.equals("NS")) {
            this.dominantLoadNS = dominant;
            this.nonDominantLoadNS = nonDominant;
        } else {
            this.dominantLoadSS = dominant;
            this.nonDominantLoadSS = nonDominant;
        }
    }

    void updateAggDailyWeatherSensitiveLoad(String type, int day) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        if (type.equals("NS")) {
            this.aggDailyWeatherSensitiveLoadNS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoad(dayTemp, type));
            this.aggDailyWeatherSensitiveLoadInHoursNS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoadInHours(dayTemp, type));
        } else {
            this.aggDailyWeatherSensitiveLoadSS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoad(dayTemp, type));
            this.aggDailyWeatherSensitiveLoadInHoursSS.set(dayTemp, this.fillAggDailyWeatherSensitiveLoadInHours(dayTemp, type));
        }
    }

    Vector<Long> fillAggDailyBaseLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingOffices : this.smartShiftingOffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyBaseLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyControllableLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingOffices : this.smartShiftingOffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyControllableLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyWeatherSensitiveLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingOffices : this.smartShiftingOffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyWeatherSensitiveLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyDominantLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingOffices : this.smartShiftingOffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyDominantLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyNonDominantLoad(int day, String type) {
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingOffices : this.smartShiftingOffices;
        Vector<Long> v = new Vector<Long>(96);
        long sum = 0L;
        for (int i = 0; i < 96; ++i) {
            sum = 0L;
            for (Office office : offices) {
                sum += (long)office.weeklyNonDominantLoad.get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Long> fillAggDailyBaseLoadInHours(int day, String type) {
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyBaseLoadNS.get(day).get(i * 4) + this.aggDailyBaseLoadNS.get(day).get(i * 4 + 1) + this.aggDailyBaseLoadNS.get(day).get(i * 4 + 2) + this.aggDailyBaseLoadNS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyBaseLoadSS.get(day).get(i * 4) + this.aggDailyBaseLoadSS.get(day).get(i * 4 + 1) + this.aggDailyBaseLoadSS.get(day).get(i * 4 + 2) + this.aggDailyBaseLoadSS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    Vector<Long> fillAggDailyControllableLoadInHours(int day, String type) {
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyControllableLoadNS.get(day).get(i * 4) + this.aggDailyControllableLoadNS.get(day).get(i * 4 + 1) + this.aggDailyControllableLoadNS.get(day).get(i * 4 + 2) + this.aggDailyControllableLoadNS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyControllableLoadSS.get(day).get(i * 4) + this.aggDailyControllableLoadSS.get(day).get(i * 4 + 1) + this.aggDailyControllableLoadSS.get(day).get(i * 4 + 2) + this.aggDailyControllableLoadSS.get(day).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    Vector<Long> fillAggDailyWeatherSensitiveLoadInHours(int day, String type) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4) + this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4 + 1) + this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4 + 2) + this.aggDailyWeatherSensitiveLoadNS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4) + this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4 + 1) + this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4 + 2) + this.aggDailyWeatherSensitiveLoadSS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    Vector<Long> fillAggDailyDominantLoadInHours(int day, String type) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyDominantLoadNS.get(dayTemp).get(i * 4) + this.aggDailyDominantLoadNS.get(dayTemp).get(i * 4 + 1) + this.aggDailyDominantLoadNS.get(dayTemp).get(i * 4 + 2) + this.aggDailyDominantLoadNS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyDominantLoadSS.get(dayTemp).get(i * 4) + this.aggDailyDominantLoadSS.get(dayTemp).get(i * 4 + 1) + this.aggDailyDominantLoadSS.get(dayTemp).get(i * 4 + 2) + this.aggDailyDominantLoadSS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    Vector<Long> fillAggDailyNonDominantLoadInHours(int day, String type) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Vector<Long> daily = new Vector<Long>();
        long sum = 0L;
        if (type.equals("NS")) {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyNonDominantLoadNS.get(dayTemp).get(i * 4) + this.aggDailyNonDominantLoadNS.get(dayTemp).get(i * 4 + 1) + this.aggDailyNonDominantLoadNS.get(dayTemp).get(i * 4 + 2) + this.aggDailyNonDominantLoadNS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        } else {
            for (int i = 0; i < 24; ++i) {
                sum = 0L;
                sum = this.aggDailyNonDominantLoadSS.get(dayTemp).get(i * 4) + this.aggDailyNonDominantLoadSS.get(dayTemp).get(i * 4 + 1) + this.aggDailyNonDominantLoadSS.get(dayTemp).get(i * 4 + 2) + this.aggDailyNonDominantLoadSS.get(dayTemp).get(i * 4 + 3);
                daily.add(sum);
            }
        }
        return daily;
    }

    public void consumePower() {
        Timeslot ts = this.timeslotRepo.currentTimeslot();
        for (CustomerInfo customer : this.customerInfos) {
            int serial;
            List subscriptions = this.tariffSubscriptionRepo.findActiveSubscriptionsForCustomer(customer);
            String temp = this.officeMapping.get(customer);
            String type = temp.substring(0, 2);
            boolean controllable = temp.contains("Controllable");
            if (ts == null) {
                log.debug((Object)"Current timeslot is null");
                serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
            } else {
                log.debug((Object)("Timeslot Serial: " + ts.getSerialNumber()));
                serial = ts.getSerialNumber();
            }
            double load = this.getConsumptionByTimeslot(serial, type, controllable);
            log.debug((Object)("Consumption Load for Customer " + customer.toString() + ": " + load + " for subscriptions " + subscriptions.toString()));
            if (subscriptions == null && subscriptions.size() == 0) continue;
            ((TariffSubscription)subscriptions.get(0)).usePower(load);
        }
    }

    double getConsumptionByTimeslot(int serial, String type, boolean controllable) {
        int day = serial / 24;
        int hour = serial % 24;
        long summary = 0L;
        log.debug((Object)("Serial : " + serial + " Day: " + day + " Hour: " + hour));
        summary = controllable ? this.getControllableConsumptions(day, hour, type) : this.getBaseConsumptions(day, hour, type) + this.getWeatherSensitiveConsumptions(day, hour, type);
        return (double)summary / 1000.0;
    }

    public Map<CustomerInfo, String> getOfficeMapping() {
        return this.officeMapping;
    }

    public Map<CustomerInfo, TariffEvaluator> getTariffEvaluators() {
        return this.tariffEvaluators;
    }

    long getBaseConsumptions(int day, int hour, String type) {
        long summaryBase = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        summaryBase = type.equals("NS") ? this.aggDailyBaseLoadInHoursNS.get(dayTemp).get(hour).longValue() : this.aggDailyBaseLoadInHoursSS.get(dayTemp).get(hour).longValue();
        log.debug((Object)("Base Load for " + type + ":" + summaryBase));
        return summaryBase;
    }

    long getControllableConsumptions(int day, int hour, String type) {
        long summaryControllable = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        summaryControllable = type.equals("NS") ? this.aggDailyControllableLoadInHoursNS.get(dayTemp).get(hour).longValue() : this.aggDailyControllableLoadInHoursSS.get(dayTemp).get(hour).longValue();
        log.debug((Object)("Controllable Load for " + type + ":" + summaryControllable));
        return summaryControllable;
    }

    long getWeatherSensitiveConsumptions(int day, int hour, String type) {
        long summaryWeatherSensitive = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        summaryWeatherSensitive = type.equals("NS") ? this.aggDailyWeatherSensitiveLoadInHoursNS.get(dayTemp).get(hour).longValue() : this.aggDailyWeatherSensitiveLoadInHoursSS.get(dayTemp).get(hour).longValue();
        log.debug((Object)("WeatherSensitive Load for " + type + ":" + summaryWeatherSensitive));
        return summaryWeatherSensitive;
    }

    long getNonDominantConsumptions(int day, int hour, String type) {
        long summaryNonDominant = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        summaryNonDominant = type.equals("NS") ? this.aggDailyNonDominantLoadInHoursNS.get(dayTemp).get(hour).longValue() : this.aggDailyNonDominantLoadInHoursSS.get(dayTemp).get(hour).longValue();
        log.debug((Object)("NonDominant Load for " + type + ":" + summaryNonDominant));
        return summaryNonDominant;
    }

    public double[] getDominantLoad(String type) {
        if (type.equals("NS")) {
            return this.dominantLoadNS;
        }
        return this.dominantLoadSS;
    }

    public double[] getNonDominantLoad(String type) {
        if (type.equals("NS")) {
            return this.nonDominantLoadNS;
        }
        return this.nonDominantLoadSS;
    }

    void curtailControllableConsumption(int day, int hour, String type, long curtail) {
        long before = 0L;
        long after = 0L;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        if (type.equals("NS")) {
            before = this.aggDailyControllableLoadInHoursNS.get(dayTemp).get(hour);
            this.aggDailyControllableLoadInHoursNS.get(dayTemp).set(hour, before + curtail);
            after = this.aggDailyControllableLoadInHoursNS.get(dayTemp).get(hour);
        } else {
            before = this.aggDailyControllableLoadInHoursSS.get(dayTemp).get(hour);
            this.aggDailyControllableLoadInHoursSS.get(dayTemp).set(hour, before + curtail);
            after = this.aggDailyControllableLoadInHoursSS.get(dayTemp).get(hour);
        }
        log.debug((Object)("Controllable Load for " + type + ": Before Curtailment " + before + " After Curtailment " + after));
    }

    Vector<Long> getControllableConsumptions(int day, String type) {
        Vector<Long> controllableVector = new Vector();
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        controllableVector = type.equals("NS") ? this.aggDailyControllableLoadInHoursNS.get(dayTemp) : this.aggDailyControllableLoadInHoursSS.get(dayTemp);
        return controllableVector;
    }

    Vector<Long> getWeatherSensitiveConsumptions(int day, String type) {
        Vector<Long> weatherSensitiveVector = new Vector();
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        weatherSensitiveVector = type.equals("NS") ? this.aggDailyWeatherSensitiveLoadInHoursNS.get(dayTemp) : this.aggDailyWeatherSensitiveLoadInHoursSS.get(dayTemp);
        return weatherSensitiveVector;
    }

    Vector<Long> getNonDominantConsumptions(int day, String type) {
        Vector<Long> nonDominantVector = new Vector();
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        nonDominantVector = type.equals("NS") ? this.aggDailyNonDominantLoadInHoursNS.get(dayTemp) : this.aggDailyNonDominantLoadInHoursSS.get(dayTemp);
        return nonDominantVector;
    }

    double[] getNonDominantUsage(int day, String type) {
        double[] nonDominantUsage = new double[24];
        for (int hour = 0; hour < 24; ++hour) {
            nonDominantUsage[hour] = hour == 23 ? (double)this.getNonDominantConsumptions(day, 0, type) : (double)this.getNonDominantConsumptions(day, hour + 1, type);
            log.debug((Object)("Non Dominant Usage for hour " + hour + ":" + nonDominantUsage[hour]));
        }
        return nonDominantUsage;
    }

    public Vector<Office> getOffices() {
        Vector<Office> offices = new Vector<Office>();
        for (Office office : this.notShiftingOffices) {
            offices.add(office);
        }
        for (Office office : this.smartShiftingOffices) {
            offices.add(office);
        }
        return offices;
    }

    public Vector<Office> getOffices(String type) {
        Vector<Office> offices = new Vector<Office>();
        if (type.equals("NS")) {
            for (Office office : this.notShiftingOffices) {
                offices.add(office);
            }
        } else {
            for (Office office : this.smartShiftingOffices) {
                offices.add(office);
            }
        }
        return offices;
    }

    public void evaluateNewTariffs() {
        for (CustomerInfo customer : this.customerInfos) {
            TariffEvaluator evaluator = this.tariffEvaluators.get(customer);
            evaluator.evaluateTariffs();
        }
    }

    double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, int day, String type) {
        double[] newControllableLoad = nonDominantUsage;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        Vector<Object> offices = new Vector();
        offices = type.equals("NS") ? this.notShiftingOffices : this.smartShiftingOffices;
        for (Office office : offices) {
            double[] temp = office.dailyShifting(tariff, newControllableLoad, this.tariffEvalHelper, dayTemp);
            log.debug((Object)("New Dominant Load for house " + office.toString() + " for Tariff " + tariff.toString() + ": " + Arrays.toString(temp)));
            for (int j = 0; j < 24; ++j) {
                int n = j;
                newControllableLoad[n] = newControllableLoad[n] + temp[j];
            }
        }
        log.debug((Object)("New Overall Load of OfficeComplex " + this.toString() + " type " + type + " for Tariff " + tariff.toString() + ": " + Arrays.toString(newControllableLoad)));
        return newControllableLoad;
    }

    Vector<Integer> createPublicVacationVector(int days) {
        Vector<Integer> v = new Vector<Integer>(days);
        for (int i = 0; i < days; ++i) {
            int x = this.gen.nextInt(OfficeComplexConstants.DAYS_OF_COMPETITION + 14);
            ListIterator<Integer> iter = v.listIterator();
            while (iter.hasNext()) {
                int temp = iter.next();
                if (x != temp) continue;
                ++x;
                iter = v.listIterator();
            }
            v.add(x);
        }
        Collections.sort(v);
        return v;
    }

    public void step() {
        int serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
        int day = serial / 24;
        int hour = this.timeService.getHourOfDay();
        Instant now = new Instant(this.timeService.getCurrentTime().getMillis());
        this.weatherCheck(day, hour, now);
        this.checkCurtailment(serial, day, hour);
        this.consumePower();
        if (hour == 23) {
            for (String type : this.numberOfOffices.keySet()) {
                if (type.equals("NS")) continue;
                log.info((Object)("Rescheduling " + type));
                this.rescheduleNextDay(type);
            }
        }
    }

    void weatherCheck(int day, int hour, Instant now) {
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        WeatherReport wr = this.weatherReportRepo.currentWeatherReport();
        if (wr != null) {
            double temperature = wr.getTemperature();
            Vector<Office> offices = this.getOffices();
            for (Office office : offices) {
                office.weatherCheck(dayTemp, hour, now, temperature);
            }
            for (String type : this.numberOfOffices.keySet()) {
                this.updateAggDailyWeatherSensitiveLoad(type, day);
                if (dayTemp + 1 >= OfficeComplexConstants.DAYS_OF_COMPETITION) continue;
                this.updateAggDailyWeatherSensitiveLoad(type, dayTemp + 1);
            }
        }
    }

    void checkCurtailment(int serial, int day, int hour) {
        int nextSerial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L) + 1;
        int nextDay = nextSerial / 24;
        int nextHour = nextSerial % 24;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        int nextDayTemp = nextDay % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        for (CustomerInfo customer : this.customerInfos) {
            if (customer.getPowerType() != PowerType.INTERRUPTIBLE_CONSUMPTION) continue;
            List subs = this.tariffSubscriptionRepo.findActiveSubscriptionsForCustomer(customer);
            long curt = (long)((TariffSubscription)subs.get(0)).getCurtailment() * 1000L;
            log.debug((Object)(this.toString() + " Subscription " + ((TariffSubscription)subs.get(0)).toString() + " Curtailment " + curt));
            if (curt <= 0L) continue;
            String temp = this.officeMapping.get(customer);
            String type = temp.substring(0, 2);
            this.curtailControllableConsumption(dayTemp, hour, type, -curt);
            this.curtailControllableConsumption(nextDayTemp, nextHour, type, curt);
        }
    }

    void rescheduleNextDay(String type) {
        int serial = (int)((this.timeService.getCurrentTime().getMillis() - this.timeService.getBase()) / 3600000L);
        int day = serial / 24 + 1;
        int dayTemp = day % (14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        double[] nonDominantUsage = this.getNonDominantUsage(dayTemp, type);
        Vector<Long> controllableVector = new Vector<Long>();
        CustomerInfo customer = this.customerRepo.findByNameAndPowerType(this.name + " " + type + " Controllable", PowerType.INTERRUPTIBLE_CONSUMPTION);
        TariffSubscription sub = (TariffSubscription)this.tariffSubscriptionRepo.findActiveSubscriptionsForCustomer(customer).get(0);
        log.debug((Object)("Old Consumption for day " + day + ": " + this.getControllableConsumptions(dayTemp, type).toString()));
        double[] newControllableLoad = this.dailyShifting(sub.getTariff(), nonDominantUsage, dayTemp, type);
        for (int i = 0; i < 24; ++i) {
            String newControllableLoadString = Double.toString(newControllableLoad[i]);
            newControllableLoadString = newControllableLoadString.replace(".0", "");
            controllableVector.add(Long.parseLong(newControllableLoadString));
        }
        log.debug((Object)("New Consumption for day " + day + ": " + controllableVector.toString()));
        this.aggDailyControllableLoadInHoursSS.set(dayTemp, controllableVector);
    }

    public String toString() {
        return this.name;
    }

    public class TariffEvaluationWrapper
    implements CustomerModelAccessor {
        private String type;
        private int day;
        private CustomerInfo customerInfo;

        public TariffEvaluationWrapper(String type, CustomerInfo customer) {
            this.type = type;
            this.customerInfo = customer;
            this.day = OfficeComplex.this.gen.nextInt(14 + OfficeComplexConstants.DAYS_OF_COMPETITION);
        }

        public CustomerInfo getCustomerInfo() {
            return this.customerInfo;
        }

        public String getType() {
            return this.type;
        }

        public int getPopulation() {
            return OfficeComplex.this.getOffices(this.type).size();
        }

        public double[] getCapacityProfile(Tariff tariff) {
            double[] result = new double[24];
            if (this.type.equalsIgnoreCase("NS")) {
                result = OfficeComplex.this.getDominantLoad(this.type);
            } else {
                double[] nonDominantUsage = OfficeComplex.this.getNonDominantUsage(this.day, this.type);
                result = OfficeComplex.this.dailyShifting(tariff, nonDominantUsage, this.day, this.type);
            }
            return result;
        }

        public double getBrokerSwitchFactor(boolean isSuperseding) {
            double result = 0.02;
            if (isSuperseding) {
                return result * 5.0;
            }
            return result;
        }

        public double getTariffChoiceSample() {
            return OfficeComplex.this.gen.nextDouble();
        }

        public double getInertiaSample() {
            return OfficeComplex.this.gen.nextDouble();
        }
    }
}

