/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.NotShiftingAppliance;

public class Lights
extends NotShiftingAppliance {
    @Override
    public void initialize(String office, Properties conf, int seed) {
        this.name = office + " Lights";
        this.saturation = 1.0;
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.power = (int)(5.0 * this.gen.nextGaussian() + 50.0) * this.applianceOf.getMembers().size();
        this.cycleDuration = 1;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
            if (!this.applianceOf.isWorking(weekday, i) && !this.applianceOf.isOnBreak(weekday, i)) continue;
            this.loadVector.set(i, this.power);
            this.dailyOperation.set(i, true);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

