/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.WeatherSensitiveAppliance;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.enumerations.AirConditionClass;
import org.powertac.officecomplexcustomer.enumerations.AirConditionOperation;
import org.powertac.officecomplexcustomer.enumerations.AirConditionPowerClass;
import org.powertac.officecomplexcustomer.enumerations.AirConditionType;

public class AirCondition
extends WeatherSensitiveAppliance {
    AirConditionType type;
    AirConditionClass acClass;
    double acClassEER;
    double acClassCOP;
    AirConditionPowerClass acPowerClass;
    AirConditionOperation acOperation;
    int cycleOn;
    int cycleOff;
    int BTU;
    int powerHeating;
    int powerCooling;
    int powerOffHeating;
    int powerOffCooling;
    int powerStartHeating;
    int powerStartCooling;
    int lowerLimit;
    int upperLimit;
    int cycleCounter;

    @Override
    public void initialize(String household, Properties conf, int seed) {
        this.name = household + " AirCondition";
        this.saturation = Double.parseDouble(conf.getProperty("AirConditionSaturation"));
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        int x = this.gen.nextInt(101);
        double limit = 100.0 * Double.parseDouble(conf.getProperty("AirConditionTypeNormal"));
        this.acOperation = AirConditionOperation.Off;
        this.cycleCounter = 0;
        if ((double)x < limit) {
            this.type = AirConditionType.Normal;
            this.cycleOn = 3;
            this.cycleOff = 2;
            this.cycleDuration = this.cycleOn + this.cycleOff;
        } else {
            this.type = AirConditionType.Inverter;
            this.cycleOn = 1;
            this.cycleOff = 1;
            this.cycleDuration = this.cycleOn + this.cycleOff;
        }
        x = this.gen.nextInt(101);
        double classA = 100.0 * Double.parseDouble(conf.getProperty("AirConditionClassA"));
        double classB = 100.0 * Double.parseDouble(conf.getProperty("AirConditionClassB"));
        double classC = 100.0 * Double.parseDouble(conf.getProperty("AirConditionClassC"));
        double classD = 100.0 * Double.parseDouble(conf.getProperty("AirConditionClassD"));
        double classE = 100.0 * Double.parseDouble(conf.getProperty("AirConditionClassE"));
        double classF = 100.0 * Double.parseDouble(conf.getProperty("AirConditionClassF"));
        if ((double)x < classA) {
            this.acClass = AirConditionClass.A;
            this.acClassEER = 4.0;
            this.acClassCOP = 6.0;
        } else if ((double)x >= classA & (double)x < classA + classB) {
            this.acClass = AirConditionClass.B;
            this.acClassEER = 3.1;
            this.acClassCOP = 3.5;
        } else if ((double)x >= classA + classB & (double)x < classA + classB + classC) {
            this.acClass = AirConditionClass.C;
            this.acClassEER = 2.9;
            this.acClassCOP = 3.3;
        } else if ((double)x >= classA + classB + classC & (double)x < classA + classB + classC + classD) {
            this.acClass = AirConditionClass.D;
            this.acClassEER = 2.7;
            this.acClassCOP = 3.0;
        } else if ((double)x >= classA + classB + classC + classD & (double)x < classA + classB + classC + classD + classE) {
            this.acClass = AirConditionClass.E;
            this.acClassEER = 2.5;
            this.acClassCOP = 2.7;
        } else if ((double)x >= classA + classB + classC + classD + classE & (double)x < classA + classB + classC + classD + classE + classF) {
            this.acClass = AirConditionClass.F;
            this.acClassEER = 2.3;
            this.acClassCOP = 2.5;
        } else {
            this.acClass = AirConditionClass.G;
            this.acClassEER = 2.0;
            this.acClassCOP = 2.2;
        }
        x = this.gen.nextInt(101);
        double powerA = 100.0 * Double.parseDouble(conf.getProperty("AirConditionPowerTypeSmall"));
        double powerB = 100.0 * Double.parseDouble(conf.getProperty("AirConditionPowerTypeMedium"));
        this.powerOffHeating = 0;
        this.powerOffCooling = 0;
        this.powerStartHeating = 0;
        this.powerStartCooling = 0;
        if ((double)x < powerA) {
            this.acPowerClass = AirConditionPowerClass.Small;
            this.BTU = 9000;
            this.powerCooling = (int)((double)this.BTU / (this.acClassEER * 4.0));
            this.powerHeating = (int)((double)this.BTU / (this.acClassCOP * 4.0));
        } else if ((double)x >= powerA & (double)x < powerA + powerB) {
            this.acPowerClass = AirConditionPowerClass.Medium;
            this.BTU = 18000;
            this.powerCooling = (int)((double)this.BTU / this.acClassEER);
            this.powerHeating = (int)((double)this.BTU / this.acClassCOP);
        } else {
            this.BTU = 25000;
            this.acPowerClass = AirConditionPowerClass.Large;
            this.powerCooling = (int)((double)this.BTU / this.acClassEER);
            this.powerHeating = (int)((double)this.BTU / this.acClassCOP);
        }
        if (this.type == AirConditionType.Inverter) {
            this.powerStartHeating = (int)((double)this.powerHeating * 1.09);
            this.powerStartCooling = (int)((double)this.powerCooling * 1.09);
            this.powerOffHeating = (int)((double)this.powerHeating * 0.41000000000000003);
            this.powerOffCooling = (int)((double)this.powerCooling * 0.41000000000000003);
            this.powerHeating = (int)((double)this.powerHeating * 0.59);
            this.powerCooling = (int)((double)this.powerCooling * 0.59);
        }
        this.lowerLimit = (int)(2.0 * this.gen.nextGaussian() + 14.0);
        this.upperLimit = (int)(2.0 * this.gen.nextGaussian() + 28.0);
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            this.dailyOperation.add(false);
            this.loadVector.add(0);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void weatherDailyFunction(int day, int hour, double temperature) {
        int trueCounter = 0;
        boolean open = true;
        int start = 0;
        int end = 0;
        boolean starting = true;
        this.acOperation = temperature > (double)this.upperLimit ? AirConditionOperation.Cooling : (temperature < (double)this.lowerLimit ? AirConditionOperation.Heating : AirConditionOperation.Off);
        if (this.acOperation != AirConditionOperation.Off) {
            int i;
            boolean[] hourPresence = new boolean[4];
            for (i = 0; i < 4; ++i) {
                hourPresence[i] = (Boolean)((Vector)this.possibilityOperationVector.get(day)).get(hour * 4 + i);
                if (!hourPresence[i]) continue;
                ++trueCounter;
            }
            if (trueCounter == 4) {
                start = 0;
            } else if (trueCounter == 3) {
                if (!hourPresence[0]) {
                    start = 1;
                } else if (!hourPresence[3]) {
                    end = 3;
                    starting = false;
                } else {
                    start = 0;
                }
            } else if (trueCounter == 2) {
                if (!hourPresence[0] && !hourPresence[1]) {
                    start = 2;
                } else if (!hourPresence[2] && !hourPresence[3]) {
                    end = 2;
                    starting = false;
                } else {
                    open = false;
                }
            } else {
                open = false;
            }
            if (open) {
                this.loadVector = (Vector)this.weeklyLoadVector.get(day);
                this.dailyOperation = (Vector)this.weeklyOperation.get(day);
                if (this.type == AirConditionType.Normal) {
                    if (starting) {
                        for (i = start; i < 4; ++i) {
                            int time = this.cycleCounter % this.cycleDuration;
                            if (time < this.cycleOn) {
                                if (this.acOperation == AirConditionOperation.Cooling) {
                                    this.loadVector.set(hour * 4 + i, this.powerCooling);
                                } else {
                                    this.loadVector.set(hour * 4 + i, this.powerHeating);
                                }
                                this.dailyOperation.set(hour * 4 + i, true);
                            }
                            ++this.cycleCounter;
                        }
                    } else {
                        for (i = 0; i < end; ++i) {
                            int time = this.cycleCounter % this.cycleDuration;
                            if (time < this.cycleOn) {
                                if (this.acOperation == AirConditionOperation.Cooling) {
                                    this.loadVector.set(hour * 4 + i, this.powerCooling);
                                } else {
                                    this.loadVector.set(hour * 4 + i, this.powerHeating);
                                }
                                this.dailyOperation.set(hour * 4 + i, true);
                            }
                            ++this.cycleCounter;
                        }
                        this.cycleCounter = 0;
                    }
                } else if (starting) {
                    for (i = start; i < 4; ++i) {
                        int time = this.cycleCounter % this.cycleDuration;
                        if (time < this.cycleOn) {
                            if (this.acOperation == AirConditionOperation.Cooling) {
                                if (this.cycleCounter == 0) {
                                    this.loadVector.set(hour * 4 + i, this.powerStartCooling);
                                } else {
                                    this.loadVector.set(hour * 4 + i, this.powerCooling);
                                }
                            } else if (this.cycleCounter == 0) {
                                this.loadVector.set(hour * 4 + i, this.powerStartHeating);
                            } else {
                                this.loadVector.set(hour * 4 + i, this.powerHeating);
                            }
                        } else if (this.acOperation == AirConditionOperation.Cooling) {
                            this.loadVector.set(hour * 4 + i, this.powerOffCooling);
                        } else {
                            this.loadVector.set(hour * 4 + i, this.powerOffHeating);
                        }
                        this.dailyOperation.set(hour * 4 + i, true);
                        ++this.cycleCounter;
                    }
                } else {
                    for (i = 0; i < end; ++i) {
                        int time = this.cycleCounter % this.cycleDuration;
                        if (time < this.cycleOn) {
                            if (this.acOperation == AirConditionOperation.Cooling) {
                                this.loadVector.set(hour * 4 + i, this.powerCooling);
                            } else {
                                this.loadVector.set(hour * 4 + i, this.powerHeating);
                            }
                            this.dailyOperation.set(hour * 4 + i, true);
                        }
                        ++this.cycleCounter;
                    }
                    this.cycleCounter = 0;
                }
                this.weeklyLoadVector.set(day, this.loadVector);
                this.weeklyOperation.set(day, this.dailyOperation);
            } else {
                this.cycleCounter = 0;
            }
        } else {
            this.cycleCounter = 0;
        }
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isWorking(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void showStatus() {
        log.debug("Name = " + this.name);
        log.debug("Saturation = " + this.saturation);
        log.debug("Air Condition Type = " + (Object)((Object)this.type));
        log.debug("Air Condition Power Class = " + (Object)((Object)this.acPowerClass));
        log.debug("Air Condition BTU = " + this.BTU);
        log.debug("Air Condition Class = " + (Object)((Object)this.acClass));
        log.debug("Air Condition Class EER = " + this.acClassEER);
        log.debug("Air Condition Class COP = " + this.acClassCOP);
        log.debug("Air Condition Operation = " + (Object)((Object)this.acOperation));
        log.debug("Power Start Heating = " + this.powerStartHeating);
        log.debug("Power Start Cooling = " + this.powerStartCooling);
        log.debug("Power Heating = " + this.powerHeating);
        log.debug("Power Cooling = " + this.powerCooling);
        log.debug("Power Off Heating = " + this.powerOffHeating);
        log.debug("Power Off Cooling = " + this.powerOffCooling);
        log.debug("Cycle Duration On = " + this.cycleOn);
        log.debug("Cycle Duration Off = " + this.cycleOff);
        log.debug("Cycle Duration = " + this.cycleDuration);
        log.debug("Lower Limit = " + this.lowerLimit);
        log.debug("Upper Limit = " + this.upperLimit);
        log.debug("Weekly Operation Vector and Load = ");
        for (int i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.debug("Day " + i);
            ListIterator iter3 = ((Vector)this.weeklyOperation.get(i)).listIterator();
            ListIterator iter4 = ((Vector)this.weeklyLoadVector.get(i)).listIterator();
            for (int j = 0; j < 96; ++j) {
                log.debug("Quarter " + j + " = " + iter3.next() + "   Load = " + iter4.next());
            }
        }
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

