/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TimeService;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerServiceAccessor;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.officecomplexcustomer.customers.OfficeComplex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfficeComplexCustomerService
extends TimeslotPhaseProcessor
implements NewTariffListener,
InitializationService,
CustomerServiceAccessor {
    private static Logger log = LogManager.getLogger((String)OfficeComplexCustomerService.class.getName());
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private ServerConfiguration serverPropertiesService;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private TimeService timeService;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    int seedId = 1;
    private String configFile1 = null;
    Properties configuration;
    ArrayList<OfficeComplex> officeComplexList;

    public String initialize(Competition competition, List<String> completedInits) {
        if (!completedInits.contains("DefaultBroker") || !completedInits.contains("TariffMarket")) {
            return null;
        }
        super.init();
        this.configuration = new Properties();
        this.officeComplexList = new ArrayList();
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.serverPropertiesService.configureMe((Object)this);
        if (this.configFile1 == null) {
            log.info("No Config File for OfficeComplexType1 Taken");
            this.configFile1 = "OfficeComplexDefault.properties";
        }
        this.addOfficeComplexes(this.configFile1, "1");
        return "OfficeComplexCustomer";
    }

    private void addOfficeComplexes(String configFile, String type) {
        InputStream cfgFile = null;
        cfgFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile1);
        try {
            this.configuration.load(cfgFile);
            cfgFile.close();
        }
        catch (IOException e) {
            log.error("failed to open configuration file");
            e.printStackTrace();
            return;
        }
        String[] types = new String[]{"NS", "SS"};
        String[] shifts = new String[]{"Base", "Controllable"};
        TreeMap<String, Integer> offices = new TreeMap<String, Integer>();
        int numberOfOfficeComplexes = Integer.parseInt(this.configuration.getProperty("NumberOfOfficeComplexes"));
        int nsoffices = Integer.parseInt(this.configuration.getProperty("NotShiftingCustomers"));
        offices.put("NS", nsoffices);
        int ssoffices = Integer.parseInt(this.configuration.getProperty("SmartShiftingCustomers"));
        offices.put("SS", ssoffices);
        Comparator<CustomerInfo> comp = new Comparator<CustomerInfo>(){

            @Override
            public int compare(CustomerInfo customer1, CustomerInfo customer2) {
                return customer1.getName().compareToIgnoreCase(customer2.getName());
            }
        };
        for (int i = 1; i < numberOfOfficeComplexes + 1; ++i) {
            OfficeComplex officeComplex = new OfficeComplex("OfficeComplex " + i);
            TreeMap<CustomerInfo, String> map = new TreeMap<CustomerInfo, String>(comp);
            for (String officeType : types) {
                for (String shifting : shifts) {
                    CustomerInfo officeComplexInfo = new CustomerInfo("OfficeComplex " + i + " " + officeType + " " + shifting, ((Integer)offices.get(officeType)).intValue());
                    if (shifting.equalsIgnoreCase("Base")) {
                        officeComplexInfo.withPowerType(PowerType.CONSUMPTION);
                    } else {
                        officeComplexInfo.withPowerType(PowerType.INTERRUPTIBLE_CONSUMPTION);
                    }
                    map.put(officeComplexInfo, officeType + " " + shifting);
                    officeComplex.addCustomerInfo(officeComplexInfo);
                    this.customerRepo.add(officeComplexInfo);
                }
            }
            officeComplex.setServiceAccessor(this);
            officeComplex.initialize(this.configuration, this.seedId++, map);
            this.officeComplexList.add(officeComplex);
            officeComplex.subscribeDefault(this.tariffMarketService);
        }
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        for (OfficeComplex officeComplex : this.officeComplexList) {
            officeComplex.evaluateTariffs(tariffs);
        }
    }

    public String getConfigFile1() {
        return this.configFile1;
    }

    @ConfigurableValue(valueType="String", description="first configuration file of the office complex customers")
    public void setConfigFile1(String config) {
        this.configFile1 = config;
    }

    public List<OfficeComplex> getOfficeComplexList() {
        return this.officeComplexList;
    }

    public void clearConfiguration() {
        this.configFile1 = null;
    }

    public List<CustomerInfo> generateCustomerInfoList() {
        ArrayList<CustomerInfo> result = new ArrayList<CustomerInfo>();
        for (OfficeComplex officeComplex : this.officeComplexList) {
            for (CustomerInfo customer : officeComplex.getCustomerInfos()) {
                result.add(customer);
            }
        }
        return result;
    }

    public void activate(Instant time, int phaseNumber) {
        log.info("Activate");
        if (this.officeComplexList.size() > 0) {
            for (OfficeComplex officeComplex : this.officeComplexList) {
                officeComplex.step();
            }
        }
    }

    public CustomerRepo getCustomerRepo() {
        return this.customerRepo;
    }

    public RandomSeedRepo getRandomSeedRepo() {
        return this.randomSeedRepo;
    }

    public TariffRepo getTariffRepo() {
        return this.tariffRepo;
    }

    public TariffSubscriptionRepo getTariffSubscriptionRepo() {
        return this.tariffSubscriptionRepo;
    }

    public TimeslotRepo getTimeslotRepo() {
        return this.timeslotRepo;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public WeatherReportRepo getWeatherReportRepo() {
        return this.weatherReportRepo;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverPropertiesService;
    }

    public TariffMarket getTariffMarket() {
        return null;
    }
}

