/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import org.joda.time.Instant;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.SemiShiftingAppliance;

public class MicrowaveOven
extends SemiShiftingAppliance {
    private double operationPercentage;

    @Override
    public void initialize(String office, Properties conf, int seed) {
        this.name = office + " MicrowaveOven";
        this.saturation = Double.parseDouble(conf.getProperty("MicrowaveOvenSaturation"));
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.power = (int)(307.0 * this.gen.nextGaussian() + 800.0);
        this.cycleDuration = 1;
        this.operationPercentage = 1.0;
        this.times = Integer.parseInt(conf.getProperty("MicrowaveOvenDailyTimes"));
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            double tempPercentage;
            this.dailyOperation.add(false);
            this.loadVector.add(0);
            if (!this.applianceOf.isOnBreak(weekday, i) || !((tempPercentage = this.operationPercentage + 0.02 * (double)this.applianceOf.employeeOnBreakNumber(weekday, i)) > this.gen.nextDouble()) || i <= 52 || i >= 60) continue;
            this.dailyOperation.set(i, true);
            this.loadVector.set(i, this.power);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isOnBreak(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public double[] dailyShifting(Tariff tariff, double[] nonDominantUsage, TariffEvaluationHelper tariffEvalHelper, int day, Instant start) {
        double[] newControllableLoad = new double[24];
        double[] newTemp = new double[24];
        for (int i = 0; i < this.times; ++i) {
            int minIndex = -1;
            int counter = 1;
            double minCost = Double.POSITIVE_INFINITY;
            for (int j = 12; j < 17; ++j) {
                newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
                int n = j;
                newTemp[n] = newTemp[n] + (double)this.power;
                double cost = Math.abs(tariffEvalHelper.estimateCost(tariff, newTemp, start));
                if (minCost == cost) {
                    ++counter;
                }
                if (!(minCost > cost) && (minCost != cost || !((double)this.gen.nextFloat() > 0.6))) continue;
                minCost = cost;
                minIndex = j;
            }
            if (counter == 5 || minIndex == -1) {
                minIndex = (int)(this.gen.nextDouble() * (double)counter) + 13 - 1;
            }
            log.debug("Less costly hour: " + minIndex);
            int n = minIndex;
            newControllableLoad[n] = newControllableLoad[n] + (double)this.power;
            newTemp = Arrays.copyOf(nonDominantUsage, nonDominantUsage.length);
            int n2 = minIndex;
            newTemp[n2] = newTemp[n2] + (double)(4 * this.power);
            nonDominantUsage = Arrays.copyOf(newTemp, newTemp.length);
        }
        return newControllableLoad;
    }

    @Override
    public void calculateOverallPower() {
        this.overallPower = this.power * this.times;
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

