/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.NotShiftingAppliance;

public class Computers
extends NotShiftingAppliance {
    private double operationPercentage;

    @Override
    public void initialize(String office, Properties conf, int seed) {
        this.name = office + " Computers";
        this.saturation = Double.parseDouble(conf.getProperty("ComputersSaturation"));
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.power = (int)(30.0 * this.gen.nextGaussian() + 150.0);
        this.cycleDuration = 1;
        this.operationPercentage = Double.parseDouble(conf.getProperty("ComputersWorking"));
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isWorking(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
            if (!this.applianceOf.isWorking(weekday, i)) continue;
            for (int j = 0; j < this.applianceOf.employeeWorkingNumber(weekday, i); ++j) {
                if (!(this.gen.nextDouble() < this.operationPercentage)) continue;
                this.dailyOperation.set(i, true);
                this.loadVector.set(i, (Integer)this.loadVector.get(i) + this.power);
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

