/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.NotShiftingAppliance;

public class ConsumerElectronics
extends NotShiftingAppliance {
    private double operationPercentage;

    @Override
    public void initialize(String office, Properties conf, int seed) {
        this.name = office + " ConsumerElectronics";
        this.saturation = 1.0;
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.power = (int)(17.0 * this.gen.nextGaussian() + 100.0);
        this.cycleDuration = 1;
        this.operationPercentage = Double.parseDouble(conf.getProperty("ConsumerElectronicsWorking"));
    }

    @Override
    public void fillDailyOperation(int weekday) {
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        for (int i = 0; i < 96; ++i) {
            double tempPercentage;
            this.dailyOperation.add(false);
            this.loadVector.add(0);
            if (!this.applianceOf.isOnBreak(weekday, i) || !((tempPercentage = this.operationPercentage + 0.02 * (double)this.applianceOf.employeeOnBreakNumber(weekday, i)) > this.gen.nextDouble())) continue;
            this.dailyOperation.set(i, true);
            this.loadVector.set(i, this.power);
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isOnBreak(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }
}

