/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.customers;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.RandomSeed;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.AirCondition;
import org.powertac.officecomplexcustomer.appliances.Appliance;
import org.powertac.officecomplexcustomer.appliances.CoffeeMachine;
import org.powertac.officecomplexcustomer.appliances.Computers;
import org.powertac.officecomplexcustomer.appliances.ConsumerElectronics;
import org.powertac.officecomplexcustomer.appliances.CopyMachine;
import org.powertac.officecomplexcustomer.appliances.ICT;
import org.powertac.officecomplexcustomer.appliances.Lights;
import org.powertac.officecomplexcustomer.appliances.MicrowaveOven;
import org.powertac.officecomplexcustomer.appliances.NotShiftingAppliance;
import org.powertac.officecomplexcustomer.appliances.Refrigerator;
import org.powertac.officecomplexcustomer.appliances.Servers;
import org.powertac.officecomplexcustomer.appliances.VendingMachine;
import org.powertac.officecomplexcustomer.appliances.WeatherSensitiveAppliance;
import org.powertac.officecomplexcustomer.configurations.OfficeComplexConstants;
import org.powertac.officecomplexcustomer.customers.OfficeComplex;
import org.powertac.officecomplexcustomer.enumerations.Status;
import org.powertac.officecomplexcustomer.persons.PeriodicPresentPerson;
import org.powertac.officecomplexcustomer.persons.Person;
import org.springframework.beans.factory.annotation.Autowired;

public class Office {
    protected static Logger log = LogManager.getLogger((String)Office.class.getName());
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    int seedId = 1;
    String name;
    Vector<Integer> dailyBaseLoad = new Vector();
    Vector<Integer> dailyControllableLoad = new Vector();
    Vector<Integer> dailyWeatherSensitiveLoad = new Vector();
    Vector<Integer> dailyNonDominantLoad = new Vector();
    Vector<Integer> dailyDominantLoad = new Vector();
    Vector<Vector<Integer>> weeklyBaseLoad = new Vector();
    Vector<Vector<Integer>> weeklyControllableLoad = new Vector();
    Vector<Vector<Integer>> weeklyWeatherSensitiveLoad = new Vector();
    Vector<Vector<Integer>> weeklyNonDominantLoad = new Vector();
    Vector<Vector<Integer>> weeklyDominantLoad = new Vector();
    Vector<Integer> dailyBaseLoadInHours = new Vector();
    Vector<Integer> dailyControllableLoadInHours = new Vector();
    Vector<Integer> dailyWeatherSensitiveLoadInHours = new Vector();
    Vector<Integer> dailyNonDominantLoadInHours = new Vector();
    Vector<Integer> dailyDominantLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyBaseLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyControllableLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyWeatherSensitiveLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyNonDominantLoadInHours = new Vector();
    Vector<Vector<Integer>> weeklyDominantLoadInHours = new Vector();
    int week = 0;
    Vector<Person> members = new Vector();
    Vector<Appliance> appliances = new Vector();
    int dominantAppliance;
    int daysDominant = 0;
    int daysNonDominant = 0;
    double[] dominantConsumption = new double[24];
    double[] nonDominantConsumption = new double[24];
    public OfficeComplex officeOf;
    RandomSeed gen;

    public void initialize(String OfficeName, Properties conf, Vector<Integer> publicVacationVector, int seed) {
        this.name = OfficeName;
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Office Model" + seed);
        int persons = this.memberRandomizer(conf);
        for (int i = 0; i < persons; ++i) {
            this.addPerson(i + 1, conf, publicVacationVector);
        }
        for (Person member : this.members) {
            for (int i = 0; i < 7; ++i) {
                member.fillDailyRoutine(i);
                member.getWeeklyRoutine().add(member.getDailyRoutine());
                member.setMemberOf(this);
            }
        }
        this.fillAppliances(conf);
        for (int i = 0; i < 7; ++i) {
            this.dailyBaseLoad = this.fillDailyBaseLoad(this.week * 7 + i);
            this.dailyControllableLoad = this.fillDailyControllableLoad(this.week * 7 + i);
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(this.week * 7 + i);
            this.weeklyBaseLoad.add(this.dailyBaseLoad);
            this.weeklyControllableLoad.add(this.dailyControllableLoad);
            this.weeklyWeatherSensitiveLoad.add(this.dailyWeatherSensitiveLoad);
            this.dailyBaseLoadInHours = this.fillDailyBaseLoadInHours();
            this.dailyControllableLoadInHours = this.fillDailyControllableLoadInHours();
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyBaseLoadInHours.add(this.dailyBaseLoadInHours);
            this.weeklyControllableLoadInHours.add(this.dailyControllableLoadInHours);
            this.weeklyWeatherSensitiveLoadInHours.add(this.dailyWeatherSensitiveLoadInHours);
        }
        this.week = 1;
        while (this.week < OfficeComplexConstants.WEEKS_OF_COMPETITION + 2) {
            this.refresh(conf);
            ++this.week;
        }
        for (Appliance appliance : this.appliances) {
            appliance.setOperationDays();
            appliance.calculateOverallPower();
        }
        this.findDominantAppliance();
        if (this.getDominantAppliance().getOverallPower() != 1) {
            this.createDominantOperationVectors();
        }
        int overallDays = (OfficeComplexConstants.WEEKS_OF_COMPETITION + 2) * 7;
        for (int i = 0; i < overallDays; ++i) {
            this.dailyNonDominantLoad = this.fillDailyNonDominantLoad(i);
            this.weeklyNonDominantLoad.add(this.dailyNonDominantLoad);
            this.dailyNonDominantLoadInHours = this.fillDailyNonDominantLoadInHours();
            this.weeklyNonDominantLoadInHours.add(this.dailyNonDominantLoadInHours);
            this.dailyDominantLoad = this.fillDailyDominantLoad(i);
            this.weeklyDominantLoad.add(this.dailyDominantLoad);
            this.dailyDominantLoadInHours = this.fillDailyDominantLoadInHours();
            this.weeklyDominantLoadInHours.add(this.dailyDominantLoadInHours);
        }
    }

    void addPerson(int counter, Properties conf, Vector<Integer> publicVacationVector) {
        PeriodicPresentPerson ppp = new PeriodicPresentPerson();
        ppp.initialize("PPP" + counter, conf, publicVacationVector, this.seedId++);
        this.members.add(ppp);
    }

    private void createDominantOperationVectors() {
        Appliance app = this.appliances.get(this.dominantAppliance);
        Vector<Boolean> op = app.getOperationDaysVector();
        for (int i = 0; i < op.size(); ++i) {
            if (op.get(i).booleanValue()) {
                ++this.daysDominant;
            } else {
                ++this.daysNonDominant;
            }
            for (int j = 0; j < 24; ++j) {
                if (op.get(i).booleanValue()) {
                    int n = j;
                    this.dominantConsumption[n] = this.dominantConsumption[n] + (double)(this.weeklyBaseLoadInHours.get(i).get(j) + this.weeklyControllableLoadInHours.get(i).get(j) + this.weeklyWeatherSensitiveLoadInHours.get(i).get(j));
                    continue;
                }
                int n = j;
                this.nonDominantConsumption[n] = this.nonDominantConsumption[n] + (double)(this.weeklyBaseLoadInHours.get(i).get(j) + this.weeklyControllableLoadInHours.get(i).get(j) + this.weeklyWeatherSensitiveLoadInHours.get(i).get(j));
            }
        }
        for (int j = 0; j < 24; ++j) {
            if (this.daysDominant != 0) {
                int n = j;
                this.dominantConsumption[n] = this.dominantConsumption[n] / (double)this.daysDominant;
            }
            if (this.daysNonDominant == 0) continue;
            int n = j;
            this.nonDominantConsumption[n] = this.nonDominantConsumption[n] / (double)this.daysNonDominant;
        }
    }

    public Vector<Appliance> getAppliances() {
        return this.appliances;
    }

    public Vector<Person> getMembers() {
        return this.members;
    }

    public double getDominantConsumption(int hour) {
        return this.dominantConsumption[hour];
    }

    public double getNonDominantConsumption(int hour) {
        return this.nonDominantConsumption[hour];
    }

    public void findDominantAppliance() {
        double maxConsumption = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.appliances.size(); ++i) {
            if (!(maxConsumption < (double)this.appliances.get(i).getOverallPower())) continue;
            maxConsumption = this.appliances.get(i).getOverallPower();
            this.dominantAppliance = i;
        }
    }

    public Appliance getDominantAppliance() {
        return this.appliances.get(this.dominantAppliance);
    }

    int memberRandomizer(Properties conf) {
        int one = Integer.parseInt(conf.getProperty("OneToFivePersons"));
        int two = Integer.parseInt(conf.getProperty("SixToTenPersons"));
        int three = Integer.parseInt(conf.getProperty("ElevenToFifteenPersons"));
        int x = this.gen.nextInt(100);
        int returnValue = x < one ? 1 + this.gen.nextInt(5) : (x >= one & x < one + two ? 6 + this.gen.nextInt(5) : (x >= one + two & x < one + two + three ? 11 + this.gen.nextInt(5) : 16 + this.gen.nextInt(5)));
        return returnValue;
    }

    void checkProbability(Appliance app) {
        int threshold;
        int x = this.gen.nextInt(100);
        if (x < (threshold = (int)(app.getSaturation() * 100.0))) {
            app.fillWeeklyOperation();
            app.createWeeklyPossibilityOperationVector();
        } else {
            this.appliances.remove(app);
        }
    }

    void fillAppliances(Properties conf) {
        AirCondition ac = new AirCondition();
        this.appliances.add(ac);
        ac.setApplianceOf(this);
        ac.initialize(this.name, conf, this.seedId++);
        this.checkProbability(ac);
        ConsumerElectronics ce = new ConsumerElectronics();
        this.appliances.add(ce);
        ce.setApplianceOf(this);
        ce.initialize(this.name, conf, this.seedId++);
        ce.fillWeeklyOperation();
        ce.createWeeklyPossibilityOperationVector();
        ICT ict = new ICT();
        this.appliances.add(ict);
        ict.setApplianceOf(this);
        ict.initialize(this.name, conf, this.seedId++);
        ict.fillWeeklyOperation();
        ict.createWeeklyPossibilityOperationVector();
        Lights lights = new Lights();
        this.appliances.add(lights);
        lights.setApplianceOf(this);
        lights.initialize(this.name, conf, this.seedId++);
        lights.fillWeeklyOperation();
        lights.createWeeklyPossibilityOperationVector();
        Computers com = new Computers();
        this.appliances.add(com);
        com.setApplianceOf(this);
        com.initialize(this.name, conf, this.seedId++);
        com.fillWeeklyOperation();
        com.createWeeklyPossibilityOperationVector();
        Servers servers = new Servers();
        this.appliances.add(servers);
        servers.setApplianceOf(this);
        servers.initialize(this.name, conf, this.seedId++);
        this.checkProbability(servers);
        Refrigerator ref = new Refrigerator();
        this.appliances.add(ref);
        ref.setApplianceOf(this);
        ref.initialize(this.name, conf, this.seedId++);
        ref.fillWeeklyOperation();
        ref.createWeeklyPossibilityOperationVector();
        CoffeeMachine coffee = new CoffeeMachine();
        this.appliances.add(coffee);
        coffee.setApplianceOf(this);
        coffee.initialize(this.name, conf, this.seedId++);
        this.checkProbability(coffee);
        VendingMachine vm = new VendingMachine();
        this.appliances.add(vm);
        vm.setApplianceOf(this);
        vm.initialize(this.name, conf, this.seedId++);
        this.checkProbability(vm);
        MicrowaveOven mo = new MicrowaveOven();
        this.appliances.add(mo);
        mo.setApplianceOf(this);
        mo.initialize(this.name, conf, this.seedId++);
        this.checkProbability(mo);
        CopyMachine cm = new CopyMachine();
        this.appliances.add(cm);
        cm.setApplianceOf(this);
        cm.initialize(this.name, conf, this.seedId++);
        this.checkProbability(cm);
    }

    public boolean isWorking(int weekday, int quarter) {
        boolean x = false;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Working) continue;
            x = true;
        }
        return x;
    }

    public boolean isOnBreak(int weekday, int quarter) {
        boolean x = false;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Break) continue;
            x = true;
        }
        return x;
    }

    public boolean isOnVacation(int weekday) {
        boolean x = true;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(0) == Status.Vacation && member.getWeeklyRoutine().get(this.week * 7 + weekday).get(0) == Status.Sick) continue;
            x = false;
        }
        return x;
    }

    public boolean isWorkingDayOfWeek(int weekday) {
        boolean x = false;
        block0: for (int i = 0; i < 96; ++i) {
            for (Person member : this.members) {
                if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(i) != Status.Working && member.getWeeklyRoutine().get(this.week * 7 + weekday).get(i) != Status.Break) continue;
                x = true;
                i = 96;
                continue block0;
            }
        }
        return x;
    }

    public boolean isWorkingDay(int day) {
        boolean x = false;
        block0: for (int i = 0; i < 96; ++i) {
            for (Person member : this.members) {
                if (member.getWeeklyRoutine().get(day).get(i) != Status.Working && member.getWeeklyRoutine().get(day).get(i) != Status.Break) continue;
                x = true;
                i = 96;
                continue block0;
            }
        }
        return x;
    }

    public boolean isEmpty(int weekday, int quarter) {
        boolean x = true;
        if (this.isWorking(weekday, quarter) || this.isOnBreak(weekday, quarter)) {
            x = false;
        }
        return x;
    }

    public int employeeWorkingNumber(int weekday, int quarter) {
        int counter = 0;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Working) continue;
            ++counter;
        }
        return counter;
    }

    public int employeeOnBreakNumber(int weekday, int quarter) {
        int counter = 0;
        for (Person member : this.members) {
            if (member.getWeeklyRoutine().get(this.week * 7 + weekday).get(quarter) != Status.Break) continue;
            ++counter;
        }
        return counter;
    }

    public int employeeNumber(int weekday, int quarter) {
        int counter = this.employeeWorkingNumber(weekday, quarter) + this.employeeOnBreakNumber(weekday, quarter);
        return counter;
    }

    void showStatus() {
        int j;
        ListIterator<Integer> iter4;
        ListIterator<Integer> iter3;
        ListIterator<Integer> iter2;
        int i;
        log.info("Office Name : " + this.name);
        log.info("Number of Persons : " + this.members.size());
        log.info(" Daily Load = ");
        for (i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.info("Day " + i);
            iter2 = this.weeklyBaseLoad.get(i).listIterator();
            iter3 = this.weeklyControllableLoad.get(i).listIterator();
            iter4 = this.weeklyWeatherSensitiveLoad.get(i).listIterator();
            for (j = 0; j < 96; ++j) {
                log.info("Quarter : " + j + " Base Load : " + iter2.next() + " Controllable Load: " + iter3.next() + " WeatherSensitive Load: " + iter4.next());
            }
        }
        log.info(" Load In Hours = ");
        for (i = 0; i < OfficeComplexConstants.DAYS_OF_COMPETITION + 14; ++i) {
            log.info("Day " + i);
            iter2 = this.weeklyBaseLoadInHours.get(i).listIterator();
            iter3 = this.weeklyControllableLoadInHours.get(i).listIterator();
            iter4 = this.weeklyWeatherSensitiveLoadInHours.get(i).listIterator();
            for (j = 0; j < 24; ++j) {
                log.info("Hours : " + j + " Base Load : " + iter2.next() + " Controllable Load: " + iter3.next() + " WeatherSensitive Load: " + iter4.next());
            }
        }
    }

    Vector<Integer> fillDailyBaseLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (!(appliance instanceof NotShiftingAppliance)) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyControllableLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (appliance instanceof NotShiftingAppliance) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyWeatherSensitiveLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (Appliance appliance : this.appliances) {
                if (!(appliance instanceof WeatherSensitiveAppliance)) continue;
                sum += appliance.getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyDominantLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            if (this.appliances.get(this.dominantAppliance).getOverallPower() != -1) {
                sum = this.appliances.get(this.dominantAppliance).getWeeklyLoadVector().get(day).get(i);
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyNonDominantLoad(int day) {
        Vector<Integer> v = new Vector<Integer>(96);
        int sum = 0;
        for (int i = 0; i < 96; ++i) {
            sum = 0;
            for (int j = 0; j < this.appliances.size(); ++j) {
                if (j == this.dominantAppliance) continue;
                sum += this.appliances.get(j).getWeeklyLoadVector().get(day).get(i).intValue();
            }
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyBaseLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyBaseLoad.get(i * 4) + this.dailyBaseLoad.get(i * 4 + 1) + this.dailyBaseLoad.get(i * 4 + 2) + this.dailyBaseLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyControllableLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyControllableLoad.get(i * 4) + this.dailyControllableLoad.get(i * 4 + 1) + this.dailyControllableLoad.get(i * 4 + 2) + this.dailyControllableLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyWeatherSensitiveLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyWeatherSensitiveLoad.get(i * 4) + this.dailyWeatherSensitiveLoad.get(i * 4 + 1) + this.dailyWeatherSensitiveLoad.get(i * 4 + 2) + this.dailyWeatherSensitiveLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyDominantLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyDominantLoad.get(i * 4) + this.dailyDominantLoad.get(i * 4 + 1) + this.dailyDominantLoad.get(i * 4 + 2) + this.dailyDominantLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    Vector<Integer> fillDailyNonDominantLoadInHours() {
        Vector<Integer> v = new Vector<Integer>(24);
        int sum = 0;
        for (int i = 0; i < 24; ++i) {
            sum = 0;
            sum = this.dailyNonDominantLoad.get(i * 4) + this.dailyNonDominantLoad.get(i * 4 + 1) + this.dailyNonDominantLoad.get(i * 4 + 2) + this.dailyNonDominantLoad.get(i * 4 + 3);
            v.add(sum);
        }
        return v;
    }

    void refresh(Properties conf) {
        for (Person member : this.members) {
            member.refresh(conf);
        }
        for (Appliance appliance : this.appliances) {
            appliance.refresh();
        }
        for (int i = 0; i < 7; ++i) {
            this.dailyBaseLoad = this.fillDailyBaseLoad(this.week * 7 + i);
            this.dailyControllableLoad = this.fillDailyControllableLoad(this.week * 7 + i);
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(this.week * 7 + i);
            this.weeklyBaseLoad.add(this.dailyBaseLoad);
            this.weeklyControllableLoad.add(this.dailyControllableLoad);
            this.weeklyWeatherSensitiveLoad.add(this.dailyWeatherSensitiveLoad);
            this.dailyBaseLoadInHours = this.fillDailyBaseLoadInHours();
            this.dailyControllableLoadInHours = this.fillDailyControllableLoadInHours();
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyBaseLoadInHours.add(this.dailyBaseLoadInHours);
            this.weeklyControllableLoadInHours.add(this.dailyControllableLoadInHours);
            this.weeklyWeatherSensitiveLoadInHours.add(this.dailyWeatherSensitiveLoadInHours);
        }
    }

    public void weatherCheck(int day, int hour, Instant now, double temperature) {
        boolean flag = false;
        for (Appliance appliance : this.appliances) {
            if (!(appliance instanceof AirCondition) || flag) continue;
            appliance.weatherDailyFunction(day, hour, temperature);
            if (appliance.getWeeklyLoadVector().get(day).get(hour * 4) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 1) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 2) <= 0 && appliance.getWeeklyLoadVector().get(day).get(hour * 4 + 3) <= 0) continue;
            this.dailyWeatherSensitiveLoad = this.fillDailyWeatherSensitiveLoad(day);
            this.weeklyWeatherSensitiveLoad.set(day, this.dailyWeatherSensitiveLoad);
            this.dailyWeatherSensitiveLoadInHours = this.fillDailyWeatherSensitiveLoadInHours();
            this.weeklyWeatherSensitiveLoadInHours.set(day, this.dailyWeatherSensitiveLoadInHours);
        }
    }

    double[] dailyShifting(Tariff tariff, double[] nonDominantLoad, TariffEvaluationHelper tariffEvalHelper, int day, Instant start) {
        double[] dominantLoad = new double[24];
        Appliance appliance = this.appliances.get(this.dominantAppliance);
        if (appliance.getOverallPower() != -1) {
            dominantLoad = appliance.dailyShifting(tariff, nonDominantLoad, tariffEvalHelper, day, start);
        }
        log.debug("Dominant Appliance " + appliance.toString() + " Overall Power: " + appliance.getOverallPower());
        log.debug("New Dominant Load: " + Arrays.toString(dominantLoad));
        return dominantLoad;
    }

    public void printDailyLoad(int day) {
        ListIterator<Integer> iter = this.weeklyBaseLoadInHours.get(day).listIterator();
        ListIterator<Integer> iter2 = this.weeklyControllableLoadInHours.get(day).listIterator();
        ListIterator<Integer> iter3 = this.weeklyWeatherSensitiveLoadInHours.get(day).listIterator();
        log.info("Summary of Daily Load of House " + this.name);
        for (int j = 0; j < 24; ++j) {
            log.info("Hour : " + j + "1 Base Load : " + iter.next() + " Controllable Load : " + iter2.next() + " Weather Sensitive Load : " + iter3.next());
        }
    }

    public String toString() {
        return this.name;
    }
}

